function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/componentMenuAgent
 */
define(['baja!', 'bajaux/commands/CommandGroup', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/wb/commands/transfer/TransferCommand', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (baja, CommandGroup, Promise, _, asyncUtils, TransferCommand, menuUtils, mixinUtils) {
  'use strict';

  var doRequire = asyncUtils.doRequire,
    ifAllowedByProfile = menuUtils.ifAllowedByProfile,
    makeActionsGroup = menuUtils.makeActionsGroup,
    makeNewGroup = menuUtils.makeNewGroup,
    makeViewsGroup = menuUtils.makeViewsGroup,
    hasMixin = mixinUtils.hasMixin;
  function isParented(comp) {
    return !!comp.getPropertyInParent();
  }

  /**
   * Check to see if the component is frozen (either unparented, or a frozen
   * slot).
   *
   * @inner
   * @param {baja.Complex} comp
   * @returns {Boolean}
   */
  function isFrozen(comp) {
    var prop = comp.getPropertyInParent();
    return !prop || prop.isFrozen();
  }
  function isReadonly(comp) {
    var space = comp.getComponentSpace();
    return space && space.isSpaceReadonly();
  }

  /**
   * Asynchronously require the appropriate command modules and instantiate
   * the `CommandGroup`. Assign the appropriate enabled/disabled status for
   * the different commands depending on the write/invoke permissions on this
   * component.
   *
   * @inner
   * @param {*} owner
   * @param {baja.Component} comp
   * @returns {Promise}
   */
  function makeGroup(owner, comp) {
    return doRequire(['nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/commands/AddSlotCommand', 'nmodule/webEditors/rc/wb/commands/RenameCommand', 'nmodule/webEditors/rc/wb/commands/LinkMarkCommand', 'nmodule/webEditors/rc/wb/commands/LinkFromCommand', 'nmodule/webEditors/rc/wb/commands/LinkToCommand', 'nmodule/webEditors/rc/wb/commands/ReorderSlotsCommand', 'nmodule/webEditors/rc/wb/commands/SetDisplayNameCommand', 'nmodule/webEditors/rc/wb/commands/CompositeEditorCommand', 'nmodule/webEditors/rc/wb/menu/Separator']).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 10),
        ExportCommand = _ref2[0],
        AddSlotCommand = _ref2[1],
        RenameCommand = _ref2[2],
        LinkMarkCommand = _ref2[3],
        LinkFromCommand = _ref2[4],
        LinkToCommand = _ref2[5],
        ReorderSlotsCommand = _ref2[6],
        SetDisplayNameCommand = _ref2[7],
        CompositeEditorCommand = _ref2[8],
        Separator = _ref2[9];
      var group = new CommandGroup(),
        newGroup,
        deleteCmd,
        renameCmd,
        setDisplayNameCmd,
        reorderCmd,
        compositeCmd,
        exportCmd;
      if (!isReadonly(comp)) {
        var frozen = isFrozen(comp),
          parented = isParented(comp),
          hasAdminWrite = comp.getPermissions().hasAdminWrite();
        newGroup = makeNewGroup(comp, new AddSlotCommand(comp));
        setDisplayNameCmd = new SetDisplayNameCommand(comp);
        reorderCmd = new ReorderSlotsCommand(comp);
        compositeCmd = new CompositeEditorCommand(comp);
        exportCmd = new ExportCommand(comp);
        setDisplayNameCmd.setEnabled(hasAdminWrite && parented);
        reorderCmd.setEnabled(hasAdminWrite);
        compositeCmd.setEnabled(hasAdminWrite && parented);
        exportCmd.setEnabled(hasAdminWrite);
        if (hasMixin(owner, 'transfer')) {
          var subject = [comp];
          if (owner.isTransferOpSupported('delete', subject)) {
            deleteCmd = TransferCommand.make(owner, 'delete', {
              subject: subject,
              module: 'webEditors',
              lex: 'commands.delete'
            }).then(function (cmd) {
              if (!hasAdminWrite || frozen) {
                cmd.setEnabled(false);
              }
              return cmd;
            });
          }
          if (owner.isTransferOpSupported('rename', subject)) {
            renameCmd = TransferCommand.make(owner, 'rename', {
              subject: subject,
              module: 'webEditors',
              lex: 'commands.rename'
            }).then(function (cmd) {
              if (!hasAdminWrite || frozen) {
                cmd.setEnabled(false);
              }
              return cmd;
            });
          }
        } else {
          renameCmd = new RenameCommand(comp);
          renameCmd.setEnabled(hasAdminWrite && !frozen);
        }
      }
      var makeEditTagsCommmand = _.once(function (component, enabled) {
        // Edit Tags should not be not available for AceComponents
        if (!componentMenuAgent.$supportsEditTagsCommand(component)) {
          return Promise.resolve(null);
        }
        return asyncUtils.doRequire([
        //prevent JsBuildVerificationTests failures
        //nmodule/tagdictionary/rc/commands/TagManagerCommand
        'nmodule'.toLowerCase() + '/tagdictionary/rc/commands/TagManagerCommand',
        //nmodule/tagdictionary/rc/util/taggingUtil
        'nmodule'.toLowerCase() + '/tagdictionary/rc/util/taggingUtil'], {
          deps: menuUtils.useTagDictionaryMinified() && ['nmodule'.toLowerCase() + '/tagdictionary/rc/tagdictionary.built.min']
        }).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            TagManagerCommand = _ref4[0],
            taggingUtil = _ref4[1];
          return taggingUtil.getTagDictionaryService().then(function (tagDictionaryService) {
            // only add the TagManagerCommand if there is a TagDictionaryService
            if (!tagDictionaryService) {
              return null;
            }
            var cmd = new TagManagerCommand(component);
            cmd.setEnabled(enabled);
            return cmd;
          });
        })["catch"](function (ignore) {
          return null;
        });
      });

      //TODO: TransferWidget.isDeleteEnabled()?
      return Promise.all([ifAllowedByProfile('viewSelection', function () {
        return makeViewsGroup(comp.getNavOrd());
      }), makeActionsGroup(comp), new Separator(), newGroup, new Separator(), makeEditTagsCommmand(comp, hasAdminWrite), new Separator(), deleteCmd, new Separator(), LinkMarkCommand.make(comp), LinkFromCommand.make(comp), LinkToCommand.make(comp), new Separator(), renameCmd, setDisplayNameCmd, reorderCmd, compositeCmd, new Separator(), exportCmd]).then(function (allKids) {
        group.add.apply(group, _.compact(allKids));
        return group;
      });
    });
  }

  /**
   * Create a command group that can be used to construct a context menu. Note
   * that the component, if mounted, will be leased at this time so any
   * dynamic actions can be included in the menu.
   *
   * The value may also be a `NavContainer`, e.g., a nav node corresponding to
   * a component inside a .bog file inside the station's file space, that
   * BajaScript has not fully resolved yet. In this case, the `NavContainer`'s
   * nav ORD will be resolved and the menu will be generated from the result.
   *
   * @alias module:nmodule/webEditors/rc/wb/menu/componentMenuAgent
   * @param {*} owner if the owner has the `TransferSupport` mixin, then
   * transfer commands will be included
   * @param {baja.Component|baja.NavContainer} comp
   * @returns {Promise} promise to be resolved with a `CommandGroup`
   * for the given component
   * @see module:nmodule/webEditors/rc/wb/mixin/TransferSupport
   */
  var componentMenuAgent = function componentMenuAgent(owner, comp) {
    if (comp instanceof baja.NavContainer) {
      return comp.getNavOrd().get({
        lease: true
      }).then(function (comp) {
        return makeGroup(owner, comp);
      });
    }
    return Promise.resolve(comp.isMounted() && comp.lease()).then(function () {
      return makeGroup(owner, comp);
    });
  };

  /**
   * @private
   * @param {baja.Component} comp
   */
  componentMenuAgent.$supportsEditTagsCommand = function (comp) {
    return !baja.hasType(comp, 'ace:AceComponent') && !baja.hasType(comp, 'baja:VirtualComponent') && !baja.hasType(comp, 'baja:VirtualGateway');
  };
  return componentMenuAgent;
});
