/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/links/IncomingLinksView
 */
define(['jquery', 'underscore', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'hbs!nmodule/webEditors/rc/wb/links/template/IncomingLinksView'], function ($, _, BaseEditor, tplIncomingLinksView) {
  'use strict';

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/links/IncomingLinksView
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var IncomingLinksView = function IncomingLinksView() {
    BaseEditor.apply(this, arguments);
  };
  IncomingLinksView.prototype = Object.create(BaseEditor.prototype);
  IncomingLinksView.prototype.constructor = IncomingLinksView;
  IncomingLinksView.prototype.$getTable = function () {
    return this.jq().children('table');
  };
  IncomingLinksView.prototype.doInitialize = function (dom) {
    dom.html(tplIncomingLinksView({}));
  };
  IncomingLinksView.prototype.doLoad = function (comp) {
    var that = this,
      tbody = that.$getTable().children('tbody'),
      links = comp.getLinks();
    tbody.html(_.map(links, function (link) {
      return $('<tr/>').append($('<td/>').text(link.getSourceOrd())).append($('<td/>').text(link.getSourceSlotName()));
    }));
  };
  return IncomingLinksView;
});
