function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/composite/commands/RenameCommand
 */

define(['baja!', 'jquery', 'lex!workbench', 'Promise', 'underscore', 'dialogs', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/commands/Command'], function (baja, $, lexs, Promise, _, dialogs, feDialogs, Command) {
  'use strict';

  var lex = lexs[0],
    dialogTitle = lex.get("compositeEditor.rename.label"),
    errorMsg = lex.get("compositeEditor.rename.exists");
  function showError(err) {
    dialogs.showOk({
      title: dialogTitle,
      content: err.message
    });
  }
  function handleRename(editor) {
    var composite = editor.value(),
      slots = composite.getSlots().toArray(),
      table = editor.$getTable(),
      selection = table.$getSelection(),
      model = table.value(),
      rows = model.getRows(),
      selectedRows = selection.getSelectedElements(model.getRows()),
      rowsChanged = [];
    function renameRows() {
      if (selectedRows.length > 0) {
        var row = selectedRows.shift(),
          slot = row.getSubject();
        return feDialogs.showFor({
          title: dialogTitle,
          value: slot.name,
          formFactor: 'mini'
        }).then(function (name) {
          if (name && name !== slot.name) {
            if (_(slots).some(function (slot) {
              return slot.getName() === name;
            }) || _(rows).some(function (row) {
              return row.getSubject().name === name;
            })) {
              throw new Error(errorMsg);
            } else {
              slot.name = name;
              rowsChanged.push(row);
            }
          }
        }).then(renameRows);
      }
      return Promise.resolve();
    }
    return renameRows().then(function () {
      return model.emit('rowsChanged', rowsChanged);
    })["catch"](showError);
  }

  /**
   * RenameCommand
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/composite/commands/RenameCommand
   */
  var RenameCommand = /*#__PURE__*/function (_Command) {
    function RenameCommand(editor) {
      _classCallCheck(this, RenameCommand);
      return _callSuper(this, RenameCommand, [{
        module: "workbench",
        lex: 'compositeEditor.rename',
        enabled: false,
        func: function func() {
          return handleRename(editor);
        }
      }]);
    }
    _inherits(RenameCommand, _Command);
    return _createClass(RenameCommand);
  }(Command);
  return RenameCommand;
});
