function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/composite/commands/MoveDownCommand
 */

define(['baja!', 'jquery', 'lex!workbench', 'Promise', 'underscore', 'bajaux/commands/Command'], function (baja, $, lexs, Promise, _, Command) {
  'use strict';

  function handleMoveDown(editor) {
    var table = editor.$getTable(),
      selection = table.$getSelection(),
      model = table.value(),
      rows = model.getRows(),
      selectedRows = selection.getSelectedElements(rows),
      rowsReordered = selectedRows.length > 0;
    if (rowsReordered) {
      _.each(selectedRows.reverse(), function (row) {
        //reverse to allow next unselected row to bubble up during the swaps
        var index = model.getRowIndex(row),
          newIndex = index + 1;
        if (newIndex < rows.length && !selection.isSelected(newIndex)) {
          var src = row.getSubject(),
            target = rows[newIndex].getSubject(),
            temp = _.clone(target);

          //copy source to target
          for (var prop in src) {
            if (src.hasOwnProperty(prop)) {
              target[prop] = src[prop];
            }
          }

          //copy temp to source
          for (var _prop in temp) {
            if (temp.hasOwnProperty(_prop)) {
              src[_prop] = temp[_prop];
            }
          }
          selection.put(index, false);
          selection.put(newIndex, true);
        }
      });
      model.emit('rowsReordered');
    }
  }

  /**
   * MoveDownCommand
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/composite/commands/MoveDownCommand
   */
  var MoveDownCommand = /*#__PURE__*/function (_Command) {
    function MoveDownCommand(editor) {
      _classCallCheck(this, MoveDownCommand);
      return _callSuper(this, MoveDownCommand, [{
        module: "workbench",
        lex: 'compositeEditor.moveDown',
        enabled: false,
        func: function func() {
          return handleMoveDown(editor);
        }
      }]);
    }
    _inherits(MoveDownCommand, _Command);
    return _createClass(MoveDownCommand);
  }(Command);
  return MoveDownCommand;
});
