/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*eslint-env browser */ /*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LogoutCommand
 */
define(['bajaux/commands/Command', 'lex!webEditors', 'dialogs', 'nmodule/js/rc/csrf/csrfUtil'], function (Command, lexs, dialogs, csrfUtil) {
  'use strict';

  var webEditorsLex = lexs[0];

  /**
   * A command for logging out
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/LogoutCommand
   */
  var LogoutCommand = function LogoutCommand() {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.logout',
      /**
       * Asks the user to log off. If yes the user is logged off.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/LogoutCommand#invoke
       */
      func: function func(location) {
        return dialogs.showYesNo(webEditorsLex.getSafe("logoff.question")).yes(function () {
          (location || window.location).assign("/logout?csrfToken=" + csrfUtil.getCsrfToken());
        }).promise();
      }
    });
  };
  LogoutCommand.prototype = Object.create(Command.prototype);
  LogoutCommand.prototype.constructor = LogoutCommand;
  return LogoutCommand;
});
