/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LinkFromCommand
 */
define(['nmodule/webEditors/rc/wb/commands/LinkCommand'], function (LinkCommand) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/LinkCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/LinkFromCommand
   * @param {baja.Component} component the link source component
   * @throws {Error} if no `Widget` provided
   */
  var LinkFromCommand = function LinkFromCommand(component) {
    LinkCommand.call(this, component, 'commands.linkFrom');
  };
  LinkFromCommand.prototype = Object.create(LinkCommand.prototype);
  LinkFromCommand.prototype.constructor = LinkFromCommand;

  /**
   * Returns an object with source and target components populated,
   * given the specified component.
   *
   * The component is the source and the marked link is the target
   *
   * @param {baja.Component} component - the target component.
   * @return {Promise} that resolves to an `Object`
   */
  LinkFromCommand.prototype.getSourceTarget = function (component) {
    return this.getLinkMark().then(function (navNodes) {
      // TODO Handle multiple LinkMark and Components
      return navNodes[0].getNavOrd().get({
        lease: true
      });
    }).then(function (linkMark) {
      return {
        sources: [linkMark],
        targets: [component]
      };
    });
  };

  /**
   * Make a LinkFromCommand and initialize it.
   *
   * @param component
   * @returns {Promise.<LinkFromCommand>} promise that resolves to a LinkFromCommand after the
   * command has been initialized.
   */
  LinkFromCommand.make = function (component) {
    var cmd = new LinkFromCommand(component);
    return cmd.init(component).then(function () {
      return cmd;
    });
  };
  return LinkFromCommand;
});
