/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*eslint-env browser */ /*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/HomeCommand
 */
define(['bajaux/commands/Command', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (Command, asyncUtils) {
  'use strict';

  var doRequire = asyncUtils.doRequire;

  /**
   * A command for navigating to home.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/HomeCommand
   */
  var HomeCommand = function HomeCommand() {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.home',
      /**
       * Navigates the user to home.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/HomeCommand#invoke
       */
      func: function func(niagara) {
        return doRequire('profileInfo').then(function (profileInfo) {
          (niagara || window.niagara).env.hyperlink(profileInfo.getHomeOrd());
        });
      }
    });
  };
  HomeCommand.prototype = Object.create(Command.prototype);
  HomeCommand.prototype.constructor = HomeCommand;
  return HomeCommand;
});
