function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/RoleManager
 */
define(['baja!', 'baja!baja:RoleService,baja:Role,baja:AdminRole,baja:PermissionsMap,hierarchy:RoleHierarchies,baja:CategoryService', 'log!nmodule.webEditors.rc.wb.RoleManager', 'Promise', 'jquery', 'underscore', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'bajaux/commands/Command', 'nmodule/webEditors/rc/wb/mgr/commands/EditCommand', 'nmodule/webEditors/rc/wb/mgr/commands/NewCommand', 'nmodule/webEditors/rc/wb/mgr/commands/RemoveCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MgrDuplicateCommand', 'nmodule/webEditors/rc/wb/commands/DeleteCommand', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/mgrAgents', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource', 'nmodule/webEditors/rc/wb/util/role/RoleNameMgrColumn', 'nmodule/webEditors/rc/wb/util/role/PermissionsMapMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, types, log, Promise, $, _, subscriberMixIn, addContextMenuSupport, DepthSubscriber, Command, EditCommand, NewCommand, RemoveCommand, DuplicateCommand, DeleteCommand, Manager, Column, spaceUtils, subscriberUtils, mgrUtils, MgrTypeInfo, MgrModel, mgrAgents, ContainerComponentSource, RoleNameMgrColumn, PermissionsMapMgrColumn, PropertyMgrColumn) {
  'use strict';

  var logError = log.severe.bind(log),
    EDITABLE = Column.flags.EDITABLE,
    ROLE = 'baja:Role',
    ROLE_TYPE = baja.lt(ROLE),
    resolveService = spaceUtils.resolveService,
    leaseWhenNeeded = subscriberUtils.leaseWhenNeeded,
    getCategoryService = leaseWhenNeeded(_.partial(resolveService, 'baja:CategoryService')),
    getMainTableSelection = mgrUtils.getMainTableSelection;

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/RoleManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   */
  var RoleManager = function RoleManager(params) {
    var that = this;
    Manager.call(that, {
      moduleName: 'webEditors',
      keyName: 'RoleManager'
    });
    that.getCommandGroup().add(new NewCommand(that), new EditCommand(that), new RemoveCommand(that), new DuplicateCommand(that));
    that.$subscriber = new DepthSubscriber(3);
    subscriberMixIn(that);
    addContextMenuSupport(that);
  };
  RoleManager.prototype = Object.create(Manager.prototype);
  RoleManager.prototype.constructor = RoleManager;

  /**
   * Get the command to edit the selected user(s).
   *
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  RoleManager.prototype.$getEditCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * Get the command to remove the selected user(s).
   *
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  RoleManager.prototype.$getRemoveCommand = function () {
    return this.getCommandGroup().get(2);
  };

  /**
   * Get the command to duplicate the selected user(s).
   *
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  RoleManager.prototype.$getDuplicateCommand = function () {
    return this.getCommandGroup().get(3);
  };

  ////////////////////////////////////////////////////////////
  //Context Menu Support
  ////////////////////////////////////////////////////////////

  /**
   * Trigger context menus specifically on table row right clicks
   * @override
   * @returns {string}
   */
  RoleManager.prototype.getContextMenuSelector = function () {
    return 'tr';
  };

  /**
   * Callback from ContextMenuSupport to provide a chance to pre-process
   * the right click menu's CommandGroup prior to displaying it
   *
   * @param group default CommandGroup consisting of subject's menu agents
   * @returns CommandGroup updated CommandGroup
   */
  RoleManager.prototype.updateMenuCommandGroup = function (group) {
    if (group) {
      group.add(this.$getDuplicateCommand(), this.$getEditCommand());
    }
    return group;
  };

  /**
   * When a row is double-clicked, invoke the Edit command for that row.
   * Enable the Duplicate option when one or more rows are selected
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  RoleManager.prototype.doInitialize = function (dom) {
    var that = this,
      args = arguments;
    dom.on('dblclick', '.mainTable tr', function (e) {
      that.$getEditCommand().invoke()["catch"](logError);
    });
    return that.$getCategoryService().then(function (categoryService) {
      // check for changes to the Category names
      that.getSubscriber().attach('renamed', function () {
        that.getModel().emit('rowsChanged', that.getModel().getRows());
      });
      return that.getSubscriber().subscribe(categoryService);
    }).then(function () {
      return Manager.prototype.doInitialize.apply(that, args);
    });
  };

  /**
   * Load the model into the main table and configure the commands.
   *
   * @param {baja.Component} roleService
   * @returns {Promise}
   */
  RoleManager.prototype.doLoad = function (roleService) {
    var that = this,
      dupCmd = that.$getDuplicateCommand();
    dupCmd.setComponent(roleService);
    return Manager.prototype.doLoad.call(that, roleService).then(function () {
      var selection = getMainTableSelection(that);
      selection.on('changed', function () {
        that.$getEditCommand().setEnabled(!selection.isEmpty());
        that.$getDuplicateCommand().setEnabled(!selection.isEmpty());
      });
    });
  };
  RoleManager.prototype.$makeColumns = function (categories) {
    return [new RoleNameMgrColumn({
      flags: EDITABLE
    }), new PermissionsMapMgrColumn({
      flags: EDITABLE,
      categories: categories
    })];
  };

  /**
   * Create a `RoleManagerMgrModel` instance with the appropriate columns.
   *
   * @param {baja.Component} roleService
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
   */
  RoleManager.prototype.makeModel = function (roleService) {
    var that = this;
    return Promise.all([MgrTypeInfo.make([baja.lt(ROLE)]), that.$getCategories(), mgrAgents.getMixInColumns(ROLE_TYPE)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        newTypes = _ref2[0],
        categories = _ref2[1],
        mixinCols = _ref2[2];
      return new MgrModel({
        componentSource: new ContainerComponentSource({
          filter: [ROLE],
          // prevents the admin role from showing
          container: roleService
        }),
        newTypes: newTypes,
        columns: that.$makeColumns(categories).concat(mixinCols)
      });
    });
  };
  RoleManager.prototype.$getCategories = function () {
    var that = this;
    return that.$getCategoryService().then(function (categoryService) {
      return categoryService.getSlots().is('baja:Category').toValueArray();
    })["catch"](function () {
      return _.constant([]);
    });
  };
  RoleManager.prototype.$getCategoryService = function () {
    return this.getOrdBase().then(getCategoryService);
  };
  RoleManager.prototype.doDestroy = function () {
    var that = this,
      args = arguments;
    return that.getSubscriber().unsubscribeAll().then(function () {
      return Manager.prototype.doDestroy.apply(that, args);
    });
  };
  return RoleManager;
});
