function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint-env browser */ /*jshint browser: true */
/*global niagara */
/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/PropertySheetRow
 */
define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.wb.PropertySheetRow', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/Properties', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/util/Attachable', 'nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/wb/commands/ActionsCommand', 'nmodule/webEditors/rc/wb/commands/PopOutCommand', 'nmodule/webEditors/rc/wb/mixin/AttachableSupport', 'nmodule/webEditors/rc/wb/mixin/TransferSupport', 'hbs!nmodule/webEditors/rc/wb/template/PropertySheet-row'], function (baja, lexs, log, $, Promise, _, events, Properties, CommandGroup, CommandButtonGroup, asyncUtils, switchboard, fe, BaseEditor, DisplayOnlyEditor, IconEditor, Attachable, slotUtils, typeUtils, StationRegistry, htmlUtils, ActionsCommand, PopOutCommand, addAttachableSupport, TransferSupport, tplPropertySheetRow) {
  'use strict';

  var DESTROY_EVENT = events.DESTROY_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT,
    EXPAND_SPINNER_DELAY = 500,
    MODIFIED_FROM_EXPANSION = {},
    doRequire = asyncUtils.doRequire,
    contextMenuOnLongPress = htmlUtils.contextMenuOnLongPress,
    getTypeDisplay = slotUtils.getTypeDisplay,
    isComplex = typeUtils.isComplex,
    isComponent = typeUtils.isComponent,
    isSimple = typeUtils.isSimple,
    webEditorsLex = lexs[0],
    logError = log.severe.bind(log);

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Check to see if the value is a mounted Component.
   *
   * @inner
   * @param {baja.Component} comp
   * @returns {Boolean}
   */
  function isMounted(comp) {
    return isComponent(comp) && comp.isMounted();
  }

  /**
   * Check to see if a value loaded into a property sheet row is a nav node
   * (and thus should be a clickable link).
   *
   * @inner
   * @param {baja.Component} comp
   * @returns {Boolean}
   */
  function isNavKid(comp) {
    //TODO: this should look for INavNode
    return isMounted(comp);
  }

  /**
   * Build the icon display editor for the given value.
   *
   * @inner
   * @param {JQuery} dom
   * @param {module:nmodule/webEditors/rc/fe/config/CompositeBuilder} builder
   * @param {String} key the key we need an icon for
   * @returns {Promise}
   */
  function buildValueIconEditor(dom, builder, key) {
    return Promise.resolve(builder.getIconFor(key)).then(function (icon) {
      if (icon) {
        var ed = dom.data('widget');
        if (ed) {
          return ed.load(icon);
        }
        return fe.buildFor({
          dom: dom,
          value: icon,
          type: IconEditor
        });
      }
    });
  }

  /**
   * @param {baja.Value} value
   * @returns {Promise.<Function|undefined>} a PropertySheet subclass that can
   * be loaded inline to edit the given value, if one exists
   */
  function resolvePropertySheetConstructor(value) {
    return Promise.resolve(baja.hasType(value) && StationRegistry.getInstance().resolveFirst(value.getType(), {
      hasAll: ['webEditors:IPropertySheet']
    }));
  }

  ////////////////////////////////////////////////////////////////
  // Support classes
  ////////////////////////////////////////////////////////////////

  /**
   * Display only editor that stays subscribed, so it is kept up to date with
   * changes to the component's display string. Will only be used on child
   * slots that are themselves mounted components.
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor
   */
  var LiveDisplayEditor = function LiveDisplayEditor() {
    DisplayOnlyEditor.apply(this, arguments);
    addAttachableSupport(this);
  };
  LiveDisplayEditor.prototype = Object.create(DisplayOnlyEditor.prototype);
  LiveDisplayEditor.prototype.constructor = LiveDisplayEditor;
  LiveDisplayEditor.prototype.attach = function (attachable) {
    var that = this;
    attachable.attach({
      'changed': baja.throttle(function () {
        that.updateDisplay()["catch"](logError);
      }, 250)
    });
  };

  /**
   * Display only editor that shows a string representation of a Slot. Used
   * for Actions and Topics.
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor
   */
  var SlotDisplayEditor = function SlotDisplayEditor() {
    DisplayOnlyEditor.apply(this, arguments);
  };
  SlotDisplayEditor.prototype = Object.create(DisplayOnlyEditor.prototype);
  SlotDisplayEditor.prototype.constructor = SlotDisplayEditor;

  /**
   * Shows the event type (for a topic) or parameter and return types (for an
   * action).
   *
   * @param {baja.Action|baja.Topic} value
   * @returns {String}
   */
  SlotDisplayEditor.prototype.valueToString = function (value) {
    return getTypeDisplay(value);
  };

  ////////////////////////////////////////////////////////////////
  // PropertySheetRow definition
  ////////////////////////////////////////////////////////////////

  /**
   * An editor for displaying/editing one row in a `PropertySheet`. Shows the
   * slot display name, a mini editor for the slot's current value, and an
   * optional "popout" button if the value also has a compact editor registered.
   *
   * This editor will only make sense if loaded into a `<tr>` element.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/wb/PropertySheetRow
   * @param {Object} params
   * @param {Object} params.data
   * @param {module:nmodule/webEditors/rc/fe/config/CompositeBuilder} params.data.builder
   * the `CompositeBuilder` being used to retrieve a value for this row
   * @param {String} params.data.key the key associated with this slot (may change
   * if slots are renamed)
   * @param {String|Function} [params.displayWidget] the widget to be used
   * for displaying/editing the current value. If omitted, will just use the
   * default mini editor for the loaded Type. In the future, think inline
   * gauges/charts/other cool stuff.
   */
  var PropertySheetRow = function PropertySheetRow(params) {
    params = params || {};
    var that = this,
      data = params.data || {},
      builder = data.builder,
      key = data.key,
      displayWidget = data.displayWidget,
      propertiesParam = params.properties;
    if (!builder || !key) {
      throw new Error('builder and key required');
    }
    BaseEditor.apply(this, arguments);
    switchboard(this, {
      '$setExpanded': {
        allow: 'oneAtATime',
        onRepeat: 'queue'
      },
      '$handleFacetsChanged': {
        notWhile: 'doLoad',
        onRepeat: 'queue'
      },
      'doLoad': {
        notWhile: '$handleFacetsChanged',
        onRepeat: 'queue'
      }
    });
    that.$builder = builder;
    that.$key = key;
    that.$displayWidget = displayWidget;
    that.$propertiesParam = propertiesParam;
    that.$selected = false;
    that.$inlineCommandGroup = new CommandGroup({
      displayName: 'inline',
      commands: [new PopOutCommand(that), new ActionsCommand(that)]
    });
    addAttachableSupport(this);
    TransferSupport(this);
  };
  PropertySheetRow.prototype = Object.create(BaseEditor.prototype);
  PropertySheetRow.prototype.constructor = PropertySheetRow;
  PropertySheetRow.SELECTED_EVENT = 'PropertySheetRow:selected';
  PropertySheetRow.DESELECTED_EVENT = 'PropertySheetRow:deselected';

  ////////////////////////////////////////////////////////////////
  // Private setters and getters
  ////////////////////////////////////////////////////////////////

  /**
   * Performs the initial HTML templating.
   *
   * @private
   * @param {Object} obj
   * @returns {String}
   */
  PropertySheetRow.prototype.$template = function (obj) {
    return tplPropertySheetRow(obj);
  };

  /**
   * Get the command group for externally-accessible commands (those that should
   * be displayed inline in the row itself).
   *
   * @private
   * @returns {module:bajaux/commands/CommandGroup}
   */
  PropertySheetRow.prototype.$getInlineCommandGroup = function () {
    return this.$inlineCommandGroup;
  };

  /**
   * Returns the (publicly accessible) popout command.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/commands/PopOutCommand}
   */
  PropertySheetRow.prototype.$getPopOutCommand = function () {
    // noinspection JSValidateTypes
    return this.$getInlineCommandGroup().get(0);
  };

  /**
   * Returns the (publicly accessible) actions command.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/commands/ActionsCommand}
   */
  PropertySheetRow.prototype.$getActionsCommand = function () {
    // noinspection JSValidateTypes
    return this.$getInlineCommandGroup().get(1);
  };

  /**
   * Returns the element containing the editor for the loaded value.
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getValueElement = function () {
    return this.$getColumn('value');
  };

  /**
   * Returns the editor currently used to edit the loaded value.
   *
   * @private
   * @returns {module:bajaux/Widget}
   */
  PropertySheetRow.prototype.$getValueEditor = function () {
    return this.$getValueElement().data('widget');
  };

  /**
   * Returns the DOM element in which to load the inline `CommandButtonGroup`.
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getCommandsElement = function () {
    return this.$getColumn('commands').children('.command-group');
  };

  /**
   * Returns the currently loaded `CommandButtonGroup` (commands visible to
   * the user).
   *
   * @private
   * @returns {module:bajaux/util/CommandButtonGroup}
   */
  PropertySheetRow.prototype.$getCommandButtonGroup = function () {
    return this.$getCommandsElement().data('widget');
  };

  /**
   * Get the column element with the given name.
   *
   * @private
   * @param {String} name display, name, flags, facets, type
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getColumn = function (name) {
    return this.jq().children('.col-' + name);
  };

  /**
   * Returns the element containing the row's display name, that will be shown
   * as a link if the loaded value contains a nav node.
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getLinkElement = function () {
    return this.$getColumn('display').find('.link');
  };

  /**
   * Return true if this row should allow hyperlinks.
   *
   * @private
   * @returns {boolean}
   */
  PropertySheetRow.prototype.$isAllowHyperlink = function () {
    return this.properties().getValue('allowHyperlink') !== false;
  };

  /**
   * Set the contents of the display name element, optionally making it
   * a hyperlink.
   *
   * @private
   * @param {String} displayName
   * @param {baja.Ord} [navOrd] pass an ORD in order to allow this row to
   * hyperlink to that ord
   */
  PropertySheetRow.prototype.$setDisplayName = function (displayName, navOrd) {
    var html = $(navOrd && this.$isAllowHyperlink() ? '<a href="' + navOrd.toUri() + '" data-ord="' + navOrd + '">' : '<span/>');
    html.text(displayName);
    this.$getLinkElement().html(html);
    this.$getDisplayNameElement().text(displayName);
  };

  /**
   * Update the display name text field/hyperlink.
   *
   * @private
   * @param {String|baja.Slot} [slot]
   */
  PropertySheetRow.prototype.$updateDisplayName = function (slot) {
    slot = slot || this.getSlot();
    var complex = this.getComplex(),
      displayName = complex.getDisplayName(slot),
      kid = complex.get(slot),
      navOrd = isNavKid(kid) && kid.getNavOrd();
    return this.$setDisplayName(displayName, navOrd);
  };

  /**
   * Returns the element containing the row's icon/icons to display the icon
   * for the loaded Type (user.png for a BUser, etc).
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getIconElement = function () {
    return this.$getColumn('display').find('.typeIcon');
  };

  /**
   * Returns the element containing the row's display name (for slot mode).
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getDisplayNameElement = function () {
    return this.$getColumn('display').find('.displayName');
  };

  /**
   * Get the row that holds the expanded inline sheet.
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getExpandRow = function () {
    var that = this,
      dom = that.jq(),
      row = dom.next('.PropertySheetRow-inline-expansion');
    if (!row.length) {
      row = $('<tr class="PropertySheetRow-inline-expansion" style="display: none;">' + '<td colspan="' + dom.children().length + '"></td></tr>');
      dom.after(row);
      row.on(MODIFY_EVENT, '.editor', function () {
        that.setModified(MODIFIED_FROM_EXPANSION);
        return false;
      });
    }
    return row;
  };

  /**
   * Get the button that toggles the expanded state.
   *
   * @private
   * @returns {jQuery}
   */
  PropertySheetRow.prototype.$getExpandButton = function () {
    return this.$getColumn('display').find('button.expand');
  };

  /**
   * Get the expanded property sheet.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/PropertySheet} the expanded
   * property sheet, or undefined if row is not expanded
   */
  PropertySheetRow.prototype.$getSubPropertySheet = function () {
    return this.$getExpandRow().children('.PropertySheet').data('widget');
  };

  /**
   * Get whichever editor should be read/validated: if the row is expanded,
   * read/validate the expanded property sheet; otherwise, read/validate the
   * inline value editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */
  PropertySheetRow.prototype.$getActiveEditor = function () {
    return this.$isExpanded() ? this.$getSubPropertySheet() : this.$getValueEditor();
  };

  /**
   * Returns whether the row is currently selected by the user.
   *
   * @private
   * @returns {Boolean}
   */
  PropertySheetRow.prototype.$isSelected = function () {
    return !!this.$selected;
  };

  /**
   * Sets the row's selected state. Adds/removes the `selected` CSS class, as
   * appropriate.
   *
   * @private
   * @param {Boolean} selected
   */
  PropertySheetRow.prototype.$setSelected = function (selected) {
    selected = !!selected;
    if (selected !== this.$selected) {
      this.$selected = selected;
      this.jq().toggleClass('selected', selected).trigger(selected ? PropertySheetRow.SELECTED_EVENT : PropertySheetRow.DESELECTED_EVENT);
    }
  };

  /**
   * Returns the row's expanded state.
   *
   * @private
   * @returns {boolean} true if the row is expanded
   */
  PropertySheetRow.prototype.$isExpanded = function () {
    return !!this.$expanded;
  };

  /**
   * Override this method to allow different subclasses of `PropertySheet`
   * to be expanded by default.
   *
   * @private
   * @returns {Function|String} `PropertySheet` subclass constructor - or
   * more likely a RequireJS ID (to avoid circular dependencies)
   */
  PropertySheetRow.prototype.$getDefaultSheetType = function () {
    return 'nmodule/webEditors/rc/wb/PropertySheet';
  };

  /**
   * Determine how to expand a particular row. By default, if the default
   * constructor for the value extends `PropertySheet`, that will be used;
   * otherwise delegates to `$getDefaultSheetType`.
   *
   * @private
   * @returns {Promise.<String>}
   */
  PropertySheetRow.prototype.$getSheetType = function (value) {
    var that = this;
    return resolvePropertySheetConstructor(value).then(function (ctor) {
      if (ctor) {
        return ctor;
      } else {
        var sheetType = that.$getDefaultSheetType();
        return typeof sheetType === 'string' ? doRequire(sheetType) : sheetType;
      }
    });
  };

  /**
   * Expands the row to show an inline PropertySheet. Will only build the
   * sub-sheet the first time it is expanded; collapsing the row will only
   * hide the sheet, not destroy it.
   *
   * @private
   * @param {Boolean} expanded
   * @returns {Promise}
   */
  PropertySheetRow.prototype.$setExpanded = function (expanded) {
    var that = this,
      props = that.properties(),
      value = that.value(),
      expandRow = that.$getExpandRow(),
      td = expandRow.children('td'),
      expandButton = that.$getExpandButton(),
      spinnerTicket,
      prom,
      pending = true;
    that.$expanded = expanded;

    //TODO: .toggle() does not work for a table-row in PhantomJS for some reason
    expandRow[expanded ? 'show' : 'hide']();
    expandButton.toggleClass('expanded', !!expanded).toggleClass('collapsed', !expanded);
    if (expanded && !td.data('widget')) {
      prom = Promise.all([that.$getSheetType(value), that.$builder.getDisplayNameFor(that.getKey()), that.getOrdBase()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 3),
          sheetType = _ref2[0],
          displayName = _ref2[1],
          ordBase = _ref2[2];
        expandRow.attr('title', displayName);
        return fe.buildFor({
          properties: _.extend(props.toObject(), {
            allowSelection: false,
            alt: {
              value: !props.getValue('alt'),
              hidden: true
            },
            nested: true,
            ordBase: ordBase,
            showControls: false,
            showHeader: false,
            showFooter: false
          }),
          dom: td.detach(),
          readonly: !!props.getValue('sheetReadonly'),
          type: sheetType,
          value: value
        });
      }).then(function (sheet) {
        expandRow.prepend(td);
        return sheet.layout();
      })["finally"](function () {
        pending = false;
        clearTimeout(spinnerTicket);
        expandButton.removeClass('loading');
      });
      spinnerTicket = setTimeout(function () {
        if (pending) {
          expandButton.addClass('loading');
        }
      }, EXPAND_SPINNER_DELAY);
      return prom;
    }
  };

  /**
   * When loading a Component value into a PropertySheet row, Baja event
   * handlers will be attached that keep the row up to date when the value
   * itself undergoes changes that would affect the row's display.
   *
   * If the row does not have a mounted Component loaded, no handlers will be
   * attached.
   *
   * @param {module:nmodule/webEditors/rc/fe/baja/util/Attachable} attachable
   */
  PropertySheetRow.prototype.attach = function (attachable) {
    var that = this;
    attachable.attach({
      'added removed': function added_removed(/*prop*/
      ) {
        //if component has no slots, disable the row's expand button.
        that.$getExpandButton().prop('disabled', !that.value().getSlots().next());
      }
    });
  };

  /**
   * When loading a Complex into a PropertySheet, Baja event handlers will be
   * attached at the row level that will keep the row's display elements up to
   * date when the Slot for that row is renamed, has its display name, flags
   * or facets changed, etc.
   *
   * No handlers will be attached if the parent is not a Component.
   *
   * @private
   */
  PropertySheetRow.prototype.$attachParent = function () {
    var that = this,
      complex = that.getComplex();
    if (!isComponent(complex)) {
      return;
    }
    var att = that.$parentAttachable = new Attachable(complex),
      slot = complex.getSlot(that.getSlot());
    att.attach({
      'added changed removed': function added_changed_removed(prop) {
        if (prop.getName() === 'displayNames' && prop.getType().is('baja:NameMap')) {
          that.$updateDisplayName();
        }
      },
      'renamed': function renamed(prop) {
        if (prop === slot) {
          that.$updateDisplayName(slot);
          that.$key = String(prop);
        }
      },
      'facetsChanged': function facetsChanged(prop) {
        if (prop === slot && slot.isProperty()) {
          that.$handleFacetsChanged(complex, slot)["catch"](logError);
        }
      }
    });
    return att;
  };

  /**
   * @private
   * @param {baja.Complex} complex
   * @param {baja.Slot|String} slot
   * @returns {Promise}
   */
  PropertySheetRow.prototype.$handleFacetsChanged = function (complex, slot) {
    this.setFacets(complex.getFacets(slot));
    return this.$buildValueEditor(complex.get(slot));
  };

  /**
   * Remove all the handlers added in `$attachParent`.
   *
   * @private
   */
  PropertySheetRow.prototype.$detachParent = function () {
    var att = this.$parentAttachable;
    if (att) {
      att.detach();
    }
  };
  PropertySheetRow.prototype.getSubject = function () {
    return [this.value()];
  };

  /**
   * Get the default parameters that would ordinarily be used to instantiate
   * the inline mini value editor for the given value.
   *
   * @private
   * @param value
   * @returns {Promise} promise to be resolved with a params object
   */
  PropertySheetRow.prototype.$getDefaultParams = function (value) {
    var that = this,
      valueElement = that.$getValueElement(),
      complex = that.getComplex(),
      slot = that.getSlot();
    return that.getOrdBase().then(function (ordBase) {
      var defaultParams = {
        dom: valueElement,
        properties: _.extend({
          ordBase: ordBase
        }, that.properties().toObject(), that.$propertiesParam),
        formFactor: 'mini'
      };
      if (complex && slot) {
        defaultParams.complex = complex;
        defaultParams.slot = slot;
      } else {
        defaultParams.value = value;
      }
      return fe.params(defaultParams)["catch"](function () {
        return $.extend(defaultParams, {
          getWidgetConstructor: _.noop
        });
      });
    });
  };

  /**
   * Builds the editor for this property sheet row (can be a field editor,
   * display only widget, etc).
   *
   * This function will resolve the default registered constructor for this
   * value as well as building the actual value editor. Knowledge of the
   * default constructor will be necessary to determine whether or not to
   * enable the row's expand button - see `doLoad`.
   *
   * @private
   * @param {baja.Value} value
   * @returns {Promise} promise to be resolved when the value editor
   * has finished building
   */
  PropertySheetRow.prototype.$buildValueEditor = function (value) {
    //instantiate new value editor and command group.
    var that = this,
      displayWidget = that.$displayWidget,
      valueElement = that.$getValueElement(),
      valueEd = valueElement.data('widget');
    return Promise.all([that.$getDefaultParams(value), valueEd && valueEd.destroy()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
        params = _ref4[0];
      var registeredConstructor = params.getWidgetConstructor();
      if (displayWidget) {
        params.type = displayWidget;
      } else if (value instanceof baja.Slot) {
        params.type = SlotDisplayEditor;
      } else if (!registeredConstructor && isComponent(value) && value.isMounted()) {
        params.type = LiveDisplayEditor;
      }
      if (!baja.hasType(value) && !params.type) {
        throw new Error(webEditorsLex.get('PropertySheetRow.unknownDisplayWidget'));
      }
      return that.buildChildFor(params).then(function () {
        return registeredConstructor;
      });
    });
  };
  PropertySheetRow.prototype.getKey = function () {
    return this.$key;
  };

  ////////////////////////////////////////////////////////////////
  // PropertySheetRow bajaux implementation
  ////////////////////////////////////////////////////////////////

  /**
   * Assembles the appropriate table cells.
   *
   * If this row is being used to edit a mounted Component, an event listener
   * will be added to pick up on changes to the `displayNames` slot and update
   * the display value accordingly.
   *
   * Adds `PropertySheetRow` class to the DOM.
   *
   * @param {JQuery} dom
   */
  PropertySheetRow.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(that.$template()).addClass('PropertySheetRow').toggleClass('alt', !!that.properties().getValue('alt'));
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.on('click', 'button.expand', function () {
      that.$setExpanded(!that.$isExpanded())["catch"](logError);
      return false;
    });
    dom.on('click', '.link > a', function () {
      var ord = $(this).data('ord');
      if (ord && typeof niagara !== 'undefined') {
        //TODO: to external utility
        niagara.env.hyperlink(ord);
      }
      return false;
    });
    contextMenuOnLongPress(dom, {
      selector: '.contextMenu'
    });
    dom.on([DESTROY_EVENT, DISABLE_EVENT, ENABLE_EVENT, LOAD_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor, .command-group, .CommandButton', false);
    return that.$attachParent();
  };
  PropertySheetRow.prototype.$updateCommandButtonGroup = function () {
    var that = this,
      cmdGroup = that.$getInlineCommandGroup(),
      kids = cmdGroup.getChildren(),
      cmdButtonGroup = that.$getCommandButtonGroup();
    return Promise.all(kids.map(function (kid) {
      return kid.$updateEnabled && kid.$updateEnabled(that.value());
    })).then(function () {
      //true if we have even one enabled command
      var enabled = _.find(kids, function (kid) {
        return kid.isEnabled();
      });
      if (enabled) {
        return cmdButtonGroup || fe.buildFor({
          dom: that.$getCommandsElement(),
          value: cmdGroup,
          type: CommandButtonGroup,
          properties: {
            toolbar: true,
            onDisabled: 'hide'
          }
        });
      } else {
        return cmdButtonGroup && cmdButtonGroup.destroy();
      }
    });
  };

  /**
   * Builds and loads a sub-field editor for the given value. If a
   * `displayWidget` parameter was given, the editor will be of the requested
   * type. If the value is a mounted component, a live, subscribable
   * display-only editor will be loaded. Otherwise, the default mini editor
   * for that type will be loaded.
   *
   * If the type being loaded has a compact editor registered, the 'pop-out'
   * button will be shown.
   *
   * Subsequent calls to `load()` will not destroy and recreate the value
   * editor, but just load in the new value. Calling `load()` a second time
   * with a value of a different Type than the first will likely cause
   * unexpected/erroneous behavior. (Since the only way to change a Slot's Type
   * is to destroy and recreate the slot, this should not be a problem in
   * practice.)
   *
   * @param {baja.Value} value
   * @returns {Promise} promise to be resolved after the existing editor
   * (if any) is destroyed, the new editor is loaded, and the pop-out button is
   * hidden or shown
   */
  PropertySheetRow.prototype.doLoad = function (value) {
    var that = this,
      jq = that.jq(),
      builder = that.$builder,
      key = that.getKey(),
      navOrd = isNavKid(value) && value.getNavOrd().relativizeToSession(),
      valueEd = that.$getValueEditor(),
      prom;
    if (valueEd) {
      //already instantiated everything, so just load new value.
      //NCCB-21429: Load the sub property sheet for the value if it's a Complex and expanded
      prom = valueEd.load(value).then(function () {
        if (that.$isExpanded() && value.getType().isComplex()) {
          var ed = that.$getSubPropertySheet();
          return ed && ed.load(value);
        }
      });
    } else {
      //instantiate new value editor and command group.
      prom = that.$buildValueEditor(value);
    }
    return Promise.all([builder && builder.getDisplayNameFor(key), that.$getSheetType(value), that.$getDefaultParams(value), prom, that.$updateCommandButtonGroup(), builder && buildValueIconEditor(that.$getIconElement(), builder, key)]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 3),
        displayName = _ref6[0],
        sheetType = _ref6[1],
        defaultParams = _ref6[2];
      //TODO: really need Switchboard to save the day here
      if (!that.isInitialized()) {
        throw new Error('destroyed');
      }
      var defaultMiniCtor = defaultParams.getWidgetConstructor(),
        expandButton = that.$getExpandButton(),
        expandable;
      jq.attr('title', displayName);
      that.$setDisplayName(displayName, navOrd);

      //TODO: exclude hidden slots
      //TODO: multisheet should behave differently/correctly wrt expand button, hidden slots vs. actions etc

      /*
        Decide whether or not this row is expandable. If loading a Simple,
        obviously not. If loading a Complex, we check the default editor for
        that Complex (as returned by $getDefaultParams). If the default
        editor is a PropertySheet, we want to enable the expand button.
        Otherwise (as with a StatusValue), we disable expansion.
         TODO: a mixin that lets us control *both* the inline value editor
        and the expanded sub-sheet.
       */
      if (!isComplex(value)) {
        expandable = false;
      } else {
        var hasSlots = value.getSlots().properties().toArray().length > 0;
        expandable = defaultMiniCtor ? false : hasSlots;
      }
      expandButton.prop('disabled', !expandable);
      return expandable && that.properties().getValue('alwaysExpand') && that.$setExpanded(true);
    });
  };

  /**
   * Reads the value currently loaded in the value editor.
   *
   * @returns {Promise} promise to be resolved with the currently
   * entered value
   */
  PropertySheetRow.prototype.doRead = function () {
    return this.$getActiveEditor().read();
  };
  PropertySheetRow.prototype.doChanged = function (name, value) {
    if (name === 'sheetReadonly') {
      var sheet = this.$getSubPropertySheet();
      return sheet && sheet.setReadonly(value);
    }
  };

  /**
   * Sets all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  PropertySheetRow.prototype.doReadonly = function (readonly) {
    var popOutCommand = this.$getPopOutCommand();
    if (readonly) {
      popOutCommand.setEnabled(false);
    } else {
      popOutCommand.$updateEnabled()["catch"](logError);
    }
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Sets all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  PropertySheetRow.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  //TODO: can we get a bajaux-modified class?
  /**
   * Adds/removes a "modified" CSS class.
   *
   * @param {Boolean} modified
   */
  PropertySheetRow.prototype.setModified = function (modified) {
    if (modified !== MODIFIED_FROM_EXPANSION) {
      this.jq().toggleClass('modified', !!modified);
    }
    return BaseEditor.prototype.setModified.call(this, modified);
  };

  /**
   * Validates the value editor.
   * @returns {Promise} promise to be resolved if the value editor is
   * valid, or rejected if not
   */
  PropertySheetRow.prototype.validate = function () {
    return this.$getActiveEditor().validate();
  };

  /**
   * Saves the expanded property sheet, or the value editor if the row is not
   * expanded.
   *
   * @param {*} readValue
   * @param {Object} params parameters to pass to the `save` method of the
   * property sheet or value editor
   * @returns {Promise}
   */
  PropertySheetRow.prototype.doSave = function (readValue, params) {
    return this.saveToComplex.apply(this, arguments);
  };

  /**
   * Delegate `saveToComplex` work to the expanded property sheet, or the
   * value editor if the row is not expanded.
   *
   * @param {baja.Value} readValue
   * @param {Object} [params]
   * @returns {Promise}
   */
  PropertySheetRow.prototype.saveToComplex = function (readValue, params) {
    var subSheet = this.$getSubPropertySheet(),
      valueEd = this.$getValueEditor();
    if (subSheet) {
      return subSheet.save(params);
    }

    //on a property sheet, the value editor is guaranteed to be a
    //ComplexSlotEditor, so its own save() method will write through to the
    //Complex.
    return valueEd.save(params).then(function () {
      // immediately load a Simple value back in to normalize fuzzy inputs (NCCB-23273).
      // c.f. BAtomicEntry#clearDirty()'s call back to loadEditor().
      return isSimple(readValue) && valueEd.load(readValue);
    });
  };

  /**
   * If listening for displayNames events, will remove that event listener
   * from the loaded component. Removes the `PropertySheetRow` class from the
   * DOM. Removes the expanded Property Sheet if present.
   */
  PropertySheetRow.prototype.doDestroy = function () {
    var that = this,
      valueEd = that.$getValueEditor(),
      iconEd = that.$getIconElement().data('widget'),
      subSheet = that.$getSubPropertySheet(),
      group = that.$getCommandButtonGroup();
    that.$detachParent();
    that.jq().removeClass('PropertySheetRow selected modified expanded collapsed alt');
    return Promise.all([valueEd && valueEd.destroy(), iconEd && iconEd.destroy(), subSheet && subSheet.destroy(), group && group.destroy()]).then(function () {
      that.$getExpandRow().remove();
    });
  };
  return PropertySheetRow;
});
