function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/export/rc/transformers/TableModelToJson
 */
define(['baja!', 'lex!webEditors', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/table/pagination/PaginationModel'], function (baja, lexs, Promise, _, typeUtils, PaginationModel) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0],
    isSimple = typeUtils.isSimple,
    range = _.range;

  /**
   * Converts a TableModel or PaginationModel to JSON format.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/transform/transformers/TableModelToJson
   * @implements module:nmodule/export/rc/Transformer
   */
  var TableModelToJson = /*#__PURE__*/function () {
    function TableModelToJson() {
      _classCallCheck(this, TableModelToJson);
    }
    return _createClass(TableModelToJson, [{
      key: "getDisplayName",
      value: /** @returns {string} */
      function getDisplayName() {
        return webEditorsLex.get('converters.TableModelToJson.displayName');
      }

      /** @returns {string} */
    }, {
      key: "getIcon",
      value: function getIcon() {
        return webEditorsLex.get('converters.TableModelToJson.icon');
      }

      /** @returns {string} */
    }, {
      key: "getMimeType",
      value: function getMimeType() {
        return 'application/json';
      }

      /** @returns {string} `json` */
    }, {
      key: "getFileExtension",
      value: function getFileExtension() {
        return 'json';
      }

      /** @returns {string} `table` */
    }, {
      key: "getFileName",
      value: function getFileName() {
        return 'table';
      }

      /**
       * @returns {baja.Component}
       */
    }, {
      key: "getDefaultConfig",
      value: function getDefaultConfig() {
        var comp = baja.$('baja:Component'),
          obj = {
            prettyPrint: true,
            encodeToString: false,
            showUnseen: true,
            maxRecords: baja.Integer.MAX_VALUE
          };
        Object.keys(obj).forEach(function (slot) {
          comp.add({
            slot: slot,
            value: obj[slot],
            cx: {
              displayName: webEditorsLex.get("export.".concat(slot))
            }
          });
        });
        return comp;
      }

      /**
       * @param {baja.Component} config
       * @returns {object}
       */
    }, {
      key: "getExportContextObject",
      value: function getExportContextObject(config) {
        return _.extend({
          rawJson: false
        }, config.getSlots().toValueMap());
      }

      /**
       * Converts a TableModel or PaginationModel to JSON format. string,
       * booleans, and numbers will be included as-is; other values will be
       * toString()ed.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel|module:nmodule/webEditors/rc/wb/table/pagination/PaginationModel} model
       * @param {object} [cx] context; also used for toString()ing any values that
       * are not JSON-compatible
       * @param {boolean} [cx.prettyPrint=false] set to true to pretty-print JSON
       * output (only works when rawJson=true)
       * @param {boolean} [cx.rawJson=true] set to false to resolve a JSON
       * string instead of a JSON object
       * @param {boolean} [cx.showUnseen=true] set to false to prevent unseen
       * columns from being included
       * @param {boolean} [cx.encodeToString=false] set to true to encode any
       * `baja.Simple` values using `encodeToString`; by default, use `.toString(cx)`
       * @returns {Promise.<{ columns: Array.<string>, rows: Array.<Array.<*>> }>}
       */
    }, {
      key: "transform",
      value: function transform(model) {
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (typeof model.getRows === 'function') {
          return this.$transformTableModel(model, cx);
        } else {
          return this.$transformPaginationModel(model, cx);
        }
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} tableModel
       * @param {object} cx
       * @returns {Promise.<{ columns: Array.<string>, rows: Array.<Array.<*>> }>}
       */
    }, {
      key: "$transformTableModel",
      value: function $transformTableModel(tableModel, cx) {
        var _this = this;
        var _cx$prettyPrint = cx.prettyPrint,
          prettyPrint = _cx$prettyPrint === void 0 ? false : _cx$prettyPrint,
          _cx$rawJson = cx.rawJson,
          rawJson = _cx$rawJson === void 0 ? true : _cx$rawJson,
          _cx$showUnseen = cx.showUnseen,
          showUnseen = _cx$showUnseen === void 0 ? true : _cx$showUnseen,
          _cx$maxRecords = cx.maxRecords,
          maxRecords = _cx$maxRecords === void 0 ? -1 : _cx$maxRecords;
        var columns = tableModel.getColumns();
        var rows = tableModel.getRows();
        if (maxRecords >= 0) {
          rows = rows.slice(0, maxRecords);
        }

        // prioritize the values in input context (selected by user) over the
        // column contexts (selected by developer).
        var columnContexts = columns.map(function (column) {
          return _.extend({}, column.data('context'), cx);
        });
        var columnIndices = range(0, columns.length).filter(function (i) {
          return columns[i].isExportable();
        });
        if (!showUnseen) {
          columnIndices = columnIndices.filter(function (i) {
            return !columns[i].isUnseen();
          });
        }
        var getColumnDisplayNames = Promise.all(columnIndices.map(function (i) {
          return columns[i].toDisplayName();
        }));
        var getRowJsonArrays = Promise.all(rows.map(function (row, rowIndex) {
          return Promise.all(columnIndices.map(function (i) {
            return tableModel.getValueAt(i, rowIndex).then(function (rowValue) {
              return _this.toJsonValue(rowValue, columnContexts[i]);
            });
          }));
        }));
        return Promise.all([getColumnDisplayNames, getRowJsonArrays]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            columns = _ref2[0],
            rows = _ref2[1];
          var json = {
            columns: columns,
            rows: rows
          };
          if (rawJson) {
            return withColumnContexts(json, columnContexts);
          }
          var indent = prettyPrint ? 2 : 0;
          return JSON.stringify(json, null, indent);
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/pagination/PaginationModel} model
       * @param {object} cx
       * @returns {Promise.<{ columns: Array.<string>, rows: Array.<Array.<*>> }>}
       */
    }, {
      key: "$transformPaginationModel",
      value: function $transformPaginationModel(model, cx) {
        var _this2 = this;
        return Promise.resolve(model.makeTableModel(0, getMaxRecords(cx), cx)).then(function (tableModel) {
          return _this2.$transformTableModel(tableModel, cx);
        });
      }

      /**
       * Given an arbitrary value retrieved from the `TableModel`, convert it to
       * a JSON-compatible value.
       *
       * @param {*} value
       * @param {*} cx
       * @returns {Promise|*} JSON value or a Promise that resolves to one
       */
    }, {
      key: "toJsonValue",
      value: function toJsonValue(value, cx) {
        if (value === null || typeof value === 'undefined') {
          return null;
        }
        if (!isSimple(value)) {
          return String(value);
        }
        if (cx.encodeToString) {
          return value.encodeToString();
        }
        var to = _typeof(value);
        if (to === 'string' || to === 'number' || to === 'boolean') {
          return value;
        } else {
          return value.toString(cx);
        }
      }
    }]);
  }();
  function getMaxRecords(cx) {
    var maxRecords = cx.maxRecords;
    if (typeof maxRecords === 'number' && maxRecords >= 0) {
      return maxRecords;
    }
    return PaginationModel.MAX_ROWS;
  }

  /**
   * The context objects used to toString individual columns can be useful to
   * other transformers based on TableModelToJson.
   * @param {object} obj
   * @param {Array.<object>} columnContexts
   * @returns {object} input object
   */
  function withColumnContexts(obj, columnContexts) {
    Object.defineProperty(obj, '$metadata', {
      value: {
        columnContexts: columnContexts
      },
      enumerable: false
    });
    return obj;
  }
  return TableModelToJson;
});
