function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/transformer/ExporterTransformer
 */
define(['baja!', 'underscore', 'Promise', 'jquery', 'nmodule/export/rc/Transformer', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, _, Promise, $, Transformer, compUtils, typeUtils) {
  'use strict';

  var getNavOrd = compUtils.getNavOrd,
    toObject = compUtils.toObject;
  var isSimple = typeUtils.isSimple;

  /**
   * A Transformer for a generic object.
   * This version does not care about the object, rather gets the contents of the view using $.get
   *
   * @extends module:nmodule/export/rc/Transformer
   * @class
   * @alias module:nmodule/webEditors/rc/transform/transformer/ExporterTransformer
   */
  var ExporterTransformer = /*#__PURE__*/function (_Transformer) {
    /**
     * @param {module:nmodule/webEditors/rc/transform/exportUtils~ExporterInfo} exporterInfo
     */
    function ExporterTransformer(exporterInfo) {
      var _this;
      _classCallCheck(this, ExporterTransformer);
      _this = _callSuper(this, ExporterTransformer);
      _this.$transformType = exporterInfo.typeSpec;
      _this.$id = exporterInfo.id;
      _this.$displayName = exporterInfo.displayName;
      _this.$icon = exporterInfo.icon;
      _this.$viewOrd = 'view:' + _this.$transformType;
      _this.$expProps = exporterInfo.props;
      return _this;
    }

    /**
     * @returns {Promise.<baja.Component>} resolves to an instance of the
     * `baja:Exporter` being used
     */
    _inherits(ExporterTransformer, _Transformer);
    return _createClass(ExporterTransformer, [{
      key: "getDefaultConfig",
      value: function getDefaultConfig() {
        var type = this.getExporterTypeSpec();
        return baja.importTypes([type]).then(function () {
          return baja.$(type);
        });
      }

      /**
       * @param {baja.Component} config the user-edited `baja:Exporter` instance
       * @returns {object} context object filtered to contain only `Simple`
       * properties (`Complex`es are not supported by `OrdServlet`)
       */
    }, {
      key: "getExportContextObject",
      value: function getExportContextObject(config) {
        return toObject(config, {
          filter: function filter(slot) {
            return isSimple(config.get(slot));
          }
        });
      }
    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }
    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }
    }, {
      key: "getMimeType",
      value: function getMimeType() {
        return this.$expProps && this.$expProps.mimeType;
      }

      /**
       * @returns {string} The response type of this Transformer
       */
    }, {
      key: "getResponseType",
      value: function getResponseType() {
        return this.$expProps && this.$expProps.responseType;
      }

      /**
       * @returns {string} The file extension of this Transformer
       */
    }, {
      key: "getFileExtension",
      value: function getFileExtension() {
        return this.$expProps && this.$expProps.fileExt;
      }

      /**
       * Generate a file name from the Id or return an empty string
       *
       * @returns {string} An empty string or export file name
       */
    }, {
      key: "getFileName",
      value: function getFileName() {
        if (this.$id !== this.$transformType) {
          return this.$id.split('/')[0];
        }
        return 'file';
      }

      /**
       * @returns {string} the type spec of the `baja:Exporter` to be used
       */
    }, {
      key: "getExporterTypeSpec",
      value: function getExporterTypeSpec() {
        return this.$transformType;
      }

      /**
       * Gets the contents of the view
       *
       * @param {baja.Value} object
       * @param {object} [cx]
       * @returns {Promise.<*>} Returns a Promise that resolves to the contents
       * of the view ord
       */
    }, {
      key: "transform",
      value: function transform(object, cx) {
        var _this2 = this;
        return this.getTransformOrd(object, cx).then(function (transformOrd) {
          var params = {
            url: transformOrd.toUri(),
            xhrFields: {
              responseType: _this2.$expProps.responseType
            }
          };
          if (_this2.$isTextResponse(_this2.$expProps.responseType)) {
            params.dataType = 'text';
          }
          return $.ajax(params);
        });
      }

      /**
       * Get a direct link to the exporter
       *
       * @param {baja.Value} object
       * @param {object} [cx] export context
       * @returns {Promise.<baja.Ord>} station-side exporter ORD
       */
    }, {
      key: "getTransformOrd",
      value: function getTransformOrd(object) {
        var _this3 = this;
        var cx = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        return getNavOrd(object).then(function (navOrd) {
          if (!navOrd) {
            throw new Error(object + ': Unsupported export object.');
          }
          return baja.Ord.make({
            base: _this3.$getBaseOrd(navOrd),
            child: _this3.$getChildOrd(cx)
          }).normalize();
        });
      }

      /**
       *
       * @private
       * @param {baja.Ord} navOrd
       */
    }, {
      key: "$getBaseOrd",
      value: function $getBaseOrd(navOrd) {
        var baseOrd = navOrd.toString();
        // Strip the trailing slash if the navOrd ends with / - true for station root and virtuals
        if (baseOrd.match('/$')) {
          baseOrd = baseOrd.substring(0, baseOrd.length - 1);
        }
        return baseOrd;
      }

      /**
       *
       * @private
       */
    }, {
      key: "$getChildOrd",
      value: function $getChildOrd(cx) {
        var childViewOrd = this.$viewOrd;
        if (this.$isPxView()) {
          childViewOrd = 'view:' + this.$id;
        }
        return childViewOrd + contextToUrlParameters(cx);
      }

      /**
       * A PxView agent on a component is distinguished from other
       * agents only via an ID which is of the form
       * pxViewName/subId where subId is typically the module name of the Exporter.
       * For example, Graphic/pdf is the agent ID of a PxView with slot name 'Graphic'
       * and 'pdf' is the module name of the pdf:PxViewToPdf Exporter
       *
       * @private
       */
    }, {
      key: "$isPxView",
      value: function $isPxView() {
        return this.$id !== this.$transformType;
      }

      /**
       *
       * @private
       * @param {String} responseType
       */
    }, {
      key: "$isTextResponse",
      value: function $isTextResponse(responseType) {
        return responseType !== 'blob';
      }
    }]);
  }(Transformer);
  function contextToUrlParameters(cx) {
    var urlParams = {};
    if (_typeof(cx) === "object") {
      _.extend(urlParams, cx);
    }
    var keys = Object.keys(urlParams),
      enc = encodeURIComponent;
    if (!keys.length) {
      return '';
    }
    var valueNeedsEncoding = false;
    keys.forEach(function (key) {
      urlParams[key] = urlParams[key].encodeToString();
      if (valueNeedsEscaping(urlParams[key])) {
        valueNeedsEncoding = true;
        urlParams[key] = baja.SlotPath.escape(urlParams[key]);
      }
    });
    if (valueNeedsEncoding) {
      urlParams['ve'] = true;
      keys = Object.keys(urlParams);
    }
    return '?' + keys.map(function (key) {
      return "".concat(enc(key), "=").concat(enc(urlParams[key]));
    }).join(';');
  }
  function valueNeedsEscaping(paramValue) {
    var reservedChars = ['%', '|', '='];
    return reservedChars.reduce(function (rc, value) {
      return rc || paramValue.indexOf(value) !== -1;
    }, false);
  }
  return ExporterTransformer;
});
