function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/transform/config/ExportDialog
 */
define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.transform.config.ExportDialog', 'bajaux/events', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/transform/exportUtils', 'nmodule/webEditors/rc/transform/destination/FileDownloadDestinationType', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/profile/ServletViewWidget'], function (baja, lexs, log, events, Widget, Promise, _, BaseWidget, fe, OrderedMapEditor, compUtils, userData, exportUtils, FileDownloadDestinationType, PropertySheet, ServletViewWidget) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
    flatten = _.flatten,
    isFunction = _.isFunction,
    getAvailableDestinations = exportUtils.getAvailableDestinations,
    _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0],
    logSevere = log.severe.bind(log);

  /**
   * @returns {Promise.<baja.OrderedMap>}
   */
  function makeDestinationMap() {
    return getAvailableDestinations().then(function (destinations) {
      var map = new baja.OrderedMap();
      destinations.forEach(function (dest) {
        return map.put(dest.getDisplayName(), dest);
      });
      return map;
    });
  }
  function findDefaultDestination(destinationMap) {
    var keys = destinationMap.getKeys();
    for (var i = 0; i < keys.length; i++) {
      var destination = destinationMap.get(keys[i]);
      //TODO: NCCB-36367
      if (destination instanceof FileDownloadDestinationType) {
        return destination;
      }
    }
    return destinationMap.getFromIndex(0);
  }

  /**
   * Find all available TransformOperations for the subject being exported.
   *
   * @param {module:nmodule/export/rc/TransformOperationProvider|*} subject
   * @returns {Promise.<baja.OrderedMap>}
   */
  function makeOperationMap(subject) {
    return getOperations(subject).then(function (ops) {
      var map = new baja.OrderedMap();
      ops.forEach(function (op) {
        return map.put(op.getTransformer().getDisplayName(), op);
      });
      return map;
    });
  }

  /**
   * @param {*} subject
   * @returns {Promise.<Array.<module:nmodule/export/rc/TransformOperation>>}
   */
  function getOperations(subject) {
    var transformsOfSubject = exportUtils.getAllTransformOperations(subject);
    if (subject instanceof Widget) {
      if (subject instanceof ServletViewWidget) {
        return transformsOfSubject;
      } else {
        return Promise.all([transformsOfSubject, exportUtils.getAllTransformOperations(subject.value())]).then(flatten);
      }
    }
    return transformsOfSubject;
  }
  var tpl = function tpl() {
    return "\n    <table class='ux-table no-stripe'> \n      <tr class='ux-table-row'>\n        <td>\n          <span>".concat(webEditorsLex.getSafe('export.selectExporter'), "</span>\n          <span class='export-dialog-select-exporter'></span>\n        </td>\n      </tr>\n      <tr class='ux-table-row'>\n        <td class='export-dialog-export-config'></td>\n      </tr>\n      <tr class='ux-table-row export-dialog-destination-row'>\n        <td>\n          <span>").concat(webEditorsLex.getSafe('export.selectDestination'), "</span>\n          <span class='export-dialog-select-destination'></span>\n        </td>\n      </tr>\n      <tr class='ux-table-row export-dialog-destination-config-row'>\n        <td class='export-dialog-destination-config'></td>\n      </tr>\n    </table>\n  ");
  };
  var transformerCache = {};
  function cacheTransformers(userConfiguration) {
    if (userConfiguration.transformers) {
      transformerCache = userConfiguration.transformers;
    }
  }

  /**
   * Dialog to show configuration for an export operation.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/webEditors/rc/transform/config/ExportDialog
   */
  var ExportDialog = /*#__PURE__*/function (_BaseWidget) {
    function ExportDialog() {
      _classCallCheck(this, ExportDialog);
      return _callSuper(this, ExportDialog, arguments);
    }
    _inherits(ExportDialog, _BaseWidget);
    return _createClass(ExportDialog, [{
      key: "doInitialize",
      value:
      /**
       * @param {JQuery} dom
       */
      function doInitialize(dom) {
        var _this = this;
        dom.html(tpl());
        dom.on(MODIFY_EVENT, '.export-dialog-select-exporter', function (e, ed) {
          var transformOp = ed.getSelectedValue();
          _this.$updateFromTransformOperation(transformOp).then(function () {
            return _this.$updateFromDestination(_this.$getDestinationSelector().getSelectedValue(), transformOp);
          })["catch"](logSevere);
          return false;
        });
        dom.on(MODIFY_EVENT, '.export-dialog-select-destination', function (e, ed) {
          var destination = ed.getSelectedValue();
          var transformOp = _this.$getExporterSelector().getSelectedValue();
          _this.$updateFromDestination(destination, transformOp)["catch"](logSevere);
          return false;
        });
      }

      /**
       * Get either the user specified preferred transform operation or the first
       * transform operation if no operation is specified.
       * @param {baja.OrderedMap} exporterMap
       * @param {module:nmodule/webEditors/rc/transform/exportUtils~UserConfigurationObject} userConfiguration
       * @returns {module:nmodule/export/rc/TransformOperation}
       */
    }, {
      key: "getDesiredTransformOperation",
      value: function getDesiredTransformOperation(exporterMap, userConfiguration) {
        return userConfiguration.transformOp && exporterMap.get(userConfiguration.transformOp) || exporterMap.getFromIndex(0);
      }

      /**
       * Get either the user specified preferred export destination or the default
       * destination if no destination is specified.
       * @param {baja.OrderedMap} destinationMap
       * @param {Object.<string, baja.Value>} userConfiguration
       * @returns {module:nmodule/export/rc/ExportDestinationType}
       */
    }, {
      key: "getDesiredDestination",
      value: function getDesiredDestination(destinationMap, userConfiguration) {
        var destination;
        if (userConfiguration.destination) {
          destination = destinationMap.get(userConfiguration.destination);
          if (destination) {
            return destination;
          }
        }
        return findDefaultDestination(destinationMap);
      }

      /**
       * Loads details about the available exporters and destinations for this
       * particular subject to be exported.
       *
       * @param {*} subject the subject to be exported
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(subject) {
        var _this2 = this;
        var dom = this.jq();
        return Promise.all([makeOperationMap(subject), makeDestinationMap(), exportUtils.getUserConfiguration()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 3),
            exporterMap = _ref2[0],
            destinationMap = _ref2[1],
            userConfiguration = _ref2[2];
          userConfiguration = userConfiguration || {};
          cacheTransformers(userConfiguration);
          var currentTransformerProperties;
          if (!exporterMap.getSize()) {
            throw new Error(webEditorsLex.get('export.noTransformOperationsError'));
          }
          var primaryTransformOperation = _this2.getDesiredTransformOperation(exporterMap, userConfiguration),
            primaryDestination = _this2.getDesiredDestination(destinationMap, userConfiguration),
            transformerProperties = userConfiguration.transformers && userConfiguration.transformers[primaryTransformOperation.getDisplayName()];
          currentTransformerProperties = transformerProperties || {};
          return Promise.all([fe.buildFor({
            value: exporterMap,
            type: OrderedMapEditor,
            loadParams: {
              selectedValue: primaryTransformOperation
            },
            dom: dom.find('.export-dialog-select-exporter')
          }), _this2.$updateFromTransformOperation(primaryTransformOperation, currentTransformerProperties), fe.buildFor({
            value: destinationMap,
            type: OrderedMapEditor,
            loadParams: {
              selectedValue: primaryDestination
            },
            dom: dom.find('.export-dialog-select-destination')
          }), _this2.$updateFromDestination(primaryDestination, primaryTransformOperation)]);
        });
      }

      /**
       * Reads the export and destination information. If the Transformer extends from a Command then
       * no destination or destContext will be returned.
       *
       * @typedef {object} module:nmodule/webEditors/rc/transform/config/ExportDialog~ExportConfig
       * @property {module:nmodule/export/rc/TransformOperation} transformOp the transform
       * operation to be executed
       * @property {object} exportContext export context object
       * @property {string} [destination] the RequireJS of the destination type
       * @property {object} [destContext] the destination context object
       * @returns {Promise.<module:nmodule/webEditors/rc/transform/config/ExportDialog~ExportConfig>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this3 = this;
        var exportContext, transformOp, destination;
        return this.$getExporterSelector().read().then(function (op) {
          transformOp = op;
          return _this3.$getExportContextObject(transformOp);
        }).then(function (context) {
          exportContext = context;
          return exportUtils.isTransformerSupplier(transformOp) ? _this3.$getDestinationSelector().read() : undefined;
        }).then(function (dest) {
          destination = dest;
          return destination ? _this3.$getDestinationContextObject(destination) : undefined;
        }).then(function (destContext) {
          return {
            transformOp: transformOp,
            destination: destination,
            exportContext: exportContext,
            destContext: destContext
          };
        });
      }

      /**
       * @private
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "$getExporterSelector",
      value: function $getExporterSelector() {
        return Widget["in"](this.jq().find('.export-dialog-select-exporter'));
      }
    }, {
      key: "$getExportConfigWidget",
      value: function $getExportConfigWidget() {
        return Widget["in"](this.jq().find('.export-dialog-export-config'));
      }
    }, {
      key: "$getDestinationSelector",
      value: function $getDestinationSelector() {
        return Widget["in"](this.jq().find('.export-dialog-select-destination'));
      }
    }, {
      key: "$getDestinationConfigWidget",
      value: function $getDestinationConfigWidget() {
        return Widget["in"](this.jq().find('.export-dialog-destination-config'));
      }

      /**
       * Determine the export context object from the given transformOp.
       * @private
       * @param {module:nmodule/export/rc/TransformOperation} transformOp
       * @returns {Promise.<object>} for the export context object
       */
    }, {
      key: "$getExportContextObject",
      value: function $getExportContextObject(transformOp) {
        return this.$readUserEnteredValues().then(function (value) {
          return transformOp.getTransformer().getExportContextObject(value);
        });
      }

      /**
       * Determine the destination context object from the destination type
       *
       * @private
       * @param {module:nmodule/export/rc/ExportDestinationType} destinationType - The destination type module
       * @returns {Promise.<object>} for the destination context object
       */
    }, {
      key: "$getDestinationContextObject",
      value: function $getDestinationContextObject(destinationType) {
        return this.$readDestinationUserEnteredValues().then(function (value) {
          return destinationType.getDestinationContextObject(value);
        });
      }

      /**
       * @private
       * @param {module:nmodule/export/rc/TransformOperation} operation
       * @returns {Object.<string, baja.Value>}
       */
    }, {
      key: "$getTransformerConfigurationCache",
      value: function $getTransformerConfigurationCache(operation) {
        if (transformerCache && transformerCache[operation.getDisplayName()]) {
          return transformerCache[operation.getDisplayName()];
        }
      }

      /**
       * When a new transform operation is selected, show the appropriate config
       * widget for it.
       * @private
       * @param {module:nmodule/export/rc/TransformOperation} transformOperation
       * @param {Object.<string, baja.Value>} userConfiguration user entered values
       * for this particular transform operation property sheet
       * @returns {Promise}
       */
    }, {
      key: "$updateFromTransformOperation",
      value: function $updateFromTransformOperation(transformOperation, userConfiguration) {
        var _this4 = this;
        if (!userConfiguration) {
          userConfiguration = this.$getTransformerConfigurationCache(transformOperation);
        }
        var existing = this.$getExportConfigWidget();
        return Promise.all([transformOperation.getTransformer().getDefaultConfig(transformOperation.getTransformedObject()), existing && existing.destroy()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 1),
            config = _ref4[0];
          var isTransformerSupplier = exportUtils.isTransformerSupplier(transformOperation);
          _this4.jq().find('.export-dialog-destination-row').toggle(isTransformerSupplier);
          _this4.jq().find('.export-dialog-destination-config-row').toggle(isTransformerSupplier);
          if (userConfiguration) {
            return userData.fromPersistenceObject(config, userConfiguration);
          } else {
            return config;
          }
        }).then(function (config) {
          return fe.buildFor({
            value: config || baja.$('baja:Component'),
            type: PropertySheet,
            properties: {
              showHeader: false
            },
            formFactor: 'max',
            dom: _this4.jq().find('.export-dialog-export-config')
          });
        });
      }

      /**
       *
       * @param {module:nmodule/export/rc/ExportDestinationType} destination destination type
       * @param {module:nmodule/export/rc/TransformOperation} transformOp The transform operation
       * @returns Promise
       */
    }, {
      key: "$updateFromDestination",
      value: function $updateFromDestination(destination, transformOp) {
        var _this5 = this;
        var existing = this.$getDestinationConfigWidget();
        return Promise.all([isFunction(destination.getDestinationConfig) && destination.getDestinationConfig(transformOp), existing && existing.destroy()]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 1),
            destConfig = _ref6[0];
          return fe.buildFor({
            value: destConfig || baja.$('baja:Component'),
            type: PropertySheet,
            properties: {
              showHeader: false
            },
            formFactor: 'max',
            dom: _this5.jq().find('.export-dialog-destination-config')
          });
        });
      }

      /**
       * Get the values the user entered into the currently loaded property sheet
       * widget for the currently selected transformer.
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$readUserEnteredValues",
      value: function $readUserEnteredValues() {
        var configWidget = this.$getExportConfigWidget();
        return configWidget.save() //TODO: This should be property sheet API
        .then(function () {
          return configWidget.value();
        });
      }

      /**
       * Read user entered values for the destination property sheet
       * @private
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$readDestinationUserEnteredValues",
      value: function $readDestinationUserEnteredValues() {
        var destWidget = this.$getDestinationConfigWidget();
        return destWidget.save().then(function () {
          return destWidget.value();
        });
      }

      /**
       * Returns the cache for all transformer property sheets with the currently
       * edited transformer updated to correspond with the user's inputs.
       * @param {module:nmodule/export/rc/TransformOperation} transformOperation
       * @returns {object.<string, object.<string, baja.Value>>}
       */
    }, {
      key: "$buildTransformerPersistence",
      value: function $buildTransformerPersistence(transformOperation) {
        return this.$readUserEnteredValues().then(function (value) {
          transformerCache[transformOperation.getDisplayName()] = compUtils.toObject(value, {
            deep: true,
            filter: function filter(slot) {
              return !(this.getFlags(slot) & baja.Flags.TRANSIENT);
            }
          });
          return transformerCache;
        });
      }

      /**
       * Saves the current user configuration to user data.
       *
       * @param {*} readResult
       * @returns {Promise.<*>}
       */
    }, {
      key: "doSave",
      value: function doSave(readResult) {
        return this.$buildTransformerPersistence(readResult.transformOp).then(function (transformerPersistenceObject) {
          return exportUtils.persistUserConfiguration(readResult.transformOp, readResult.destination, transformerPersistenceObject);
        });
      }
    }], [{
      key: "$clearCache",
      value: function $clearCache() {
        transformerCache = {};
      }
    }]);
  }(BaseWidget);
  return ExportDialog;
});
