function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint-env browser */ /*jshint browser: true */

define(['baja!', 'lex!webEditors', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, lexs, Promise, _, compUtils, spaceUtils, subscriberUtils, typeUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var HTTPS = /^https:$/i,
    RPC_TYPE_SPEC = 'web:ChangeUserPasswordRpc',
    getNavOrd = compUtils.getNavOrd,
    resolveService = spaceUtils.resolveService,
    leaseWhenNeeded = subscriberUtils.leaseWhenNeeded,
    isComplex = typeUtils.isComplex,
    getWebService = leaseWhenNeeded(_.partial(resolveService, 'web:WebService'), 1000);

  /** @param {String} err */
  function reject(err) {
    return Promise.reject(new Error(err));
  }
  function changeUserPasswords(usernames, passwords, params) {
    return baja.rpc({
      typeSpec: RPC_TYPE_SPEC,
      method: 'changeUserPasswords',
      args: [usernames, _.map(passwords, btoaUtf8)],
      batch: params && params.batch
    })["catch"](function (err) {
      baja.error(err);
      handleJSONParseableException(err);
    });
  }
  function validatePasswords(schemes, usernames, passwords, params) {
    return baja.rpc({
      typeSpec: RPC_TYPE_SPEC,
      method: 'validatePasswords',
      args: [usernames, _.map(passwords, btoaUtf8), schemes],
      batch: params && params.batch
    })["catch"](function (err) {
      baja.error(err);
      handleJSONParseableException(err, webEditorsLex.get('password.validateError'));
    });
  }
  function setPassword(pwd, pwdSlotName, baseOrd, params) {
    return baja.rpc({
      typeSpec: "web:PasswordRpc",
      method: 'setPassword',
      args: [pwd, pwdSlotName, baseOrd],
      batch: params && params.batch
    })["catch"](function (err) {
      baja.error(err);
      throw err;
    });
  }

  /**
   * Encode the string to base64 using the UTF-8 charset
   *
   * @inner
   * @param str the source string
   * @returns {string} the base64 encoded string
   */
  function btoaUtf8(str) {
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function toSolidBytes(match, p1) {
      return String.fromCharCode(parseInt(p1, 16));
    }));
  }
  function handleJSONParseableException(err, messageSummary) {
    var errs,
      msgs = [];
    try {
      errs = JSON.parse(err.message);
    } catch (err2) {
      //Error message is not JSON so no additional processing is required
      var message = err.message;
      if (messageSummary) {
        message = messageSummary + '\n' + message;
      }
      throw new Error(message);
    }
    if (messageSummary) {
      msgs.push(messageSummary + '\n');
    }
    var length = Object.keys(errs).length;
    _.each(errs, function (err, name) {
      if (err) {
        if (name && length > 1) {
          msgs.push(name + ': ' + err);
        } else {
          msgs.push(err);
        }
      }
    });
    throw new Error(msgs.join('\n'));
  }

  /**
   * Check to see if the user service has a property set to explicitly allow
   * doing a dangerous password reset over HTTP.
   *
   * TODO: should we mark the field editor in red or something if so?
   *
   * @inner
   * @returns {Promise} promise to be resolved with a boolean
   */
  function isInsecureAllowed() {
    return getWebService().then(function (webService) {
      return !webService.get('requireHttpsForPasswords');
    });
  }

  /**
   * API Status: **Private**
   *
   * Utilities relating to password changes. These include some client-side
   * security checks, but they should be treated as feel-good measures purely
   * for UI warnings and the like. Anything sent up from this module in a
   * non-HTTPS environment is subject to man in the middle attacks.
   *
   * This module communicates with the following servlets:
   *
   * - `com.tridium.web.servlets.ChangeUserPasswordServlet`
   *
   * @exports nmodule/webEditors/rc/servlets/password
   */
  var exports = {};

  /**
   * Check to see if we are running in a secured environment. Note that
   * this is a "feel-good" measure: if we're in an insecure environment no
   * amount of JS checks will make it secure for real.
   *
   * @private
   * @returns {Promise}
   */
  exports.$isSecure = function () {
    if (HTTPS.exec(location.protocol) || baja.isOffline()) {
      return Promise.resolve(true);
    }
    return isInsecureAllowed();
  };
  function requireSecure() {
    //noinspection JSAccessibilityCheck
    return exports.$isSecure().then(function (secure) {
      if (!secure) {
        return reject('insecure environment');
      }
    });
  }

  /**
   * Change the passwords for the given users.
   *
   * @param {Array.<String>} usernames array of usernames
   * @param {Array.<String>} passwords array of plaintext passwords
   * @param {baja.Complex} base a base Complex to use to resolve the
   * `WebService`
   * @param {Object} params
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise} promise to be resolved if the passwords are
   * successfully changed. Rejects if the passwords cannot be changed, or if
   * called from a non-SSL environment (no POST to the station will occur).
   */
  exports.changePasswords = function (usernames, passwords, base, params) {
    var reserve = baja.comm.Batch.reserve(params);
    return requireSecure().then(function () {
      if (!_.isArray(usernames) || !_.isArray(passwords)) {
        return reject('usernames and passwords required');
      }
      if (usernames.length !== passwords.length) {
        return reject('different numbers of usernames and passwords');
      }
      if (!isComplex(base)) {
        return reject('base required');
      }
      return reserve.commit(changeUserPasswords(usernames, passwords, {
        batch: reserve
      }));
    });
  };

  /**
   * Verify the given passwords against the specified authentication schemes.
   *
   * @param {Array.<String>} schemes array of authentication scheme names
   * @param {Array.<String>} usernames array of usernames
   * @param {Array.<String>} passwords array of plaintext passwords
   * @param {baja.Complex} base a base Complex to use to resolve the
   * `WebService`
   * @param {Object} params
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise} promise to be resolved if the passwords are valid for
   * their corresponding authentication schemes (meet strength requirements
   * etc.). Rejects if any passwords are invalid, or if called from a non-SSL
   * environment (no POST to the station will occur). The message of the
   * rejection Error can be JSON-parsed as a username -> reason map.
   */
  exports.validatePasswords = function (schemes, usernames, passwords, base, params) {
    var reserve = baja.comm.Batch.reserve(params);
    return requireSecure().then(function () {
      if (!(_.isArray(schemes) && _.isArray(passwords) && _.isArray(usernames))) {
        return reject('schemes, usernames and passwords required');
      }
      if (schemes.length !== passwords.length) {
        return reject('different numbers of schemes and passwords');
      }
      if (schemes.length !== usernames.length) {
        return reject('different numbers of schemes and usernames');
      }
      if (!isComplex(base)) {
        return reject('base required');
      }
      return reserve.commit(validatePasswords(schemes, usernames, passwords, {
        batch: reserve
      }));
    });
  };

  /**
   * Set the password property of component (resolved via baseOrd)
   * @param {String} pwd - The password to set
   * @param {baja.Slot|String} pwdSlot - The frozen slot to set the password on
   * @param {baja.Complex|baja.Ord} base - The base complex or ord
   * @param {Object} params
   * @param {baja.comm.Batch} [params.batch]
   * @returns {Promise} Promise to be resolved for successful password set
   * or reject if insecure
   */
  exports.setPassword = function (pwd, pwdSlot, base, params) {
    var reserve = baja.comm.Batch.reserve(params);
    return requireSecure().then(function () {
      if (isComplex(base)) {
        return getNavOrd(base);
      } else if (baja.hasType(base, 'baja:Ord')) {
        return base;
      } else {
        throw new Error('base required');
      }
    }).then(function (ord) {
      return reserve.commit(setPassword(pwd, String(pwdSlot), String(ord), {
        batch: reserve
      }));
    });
  };
  return exports;
});
