function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/registry/impl/AgentRegistry
 */
define(['Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'bajaux/registry/Registry', 'nmodule/webEditors/rc/fe/registry/servletViews'], function (Promise, _, typeUtils, Registry, servletViews) {
  'use strict';

  var getSuperTypeChain = typeUtils.getSuperTypeChain,
    importTypes = typeUtils.importTypes,
    FORM_FACTORS = ['web:IFormFactorMini', 'web:IFormFactorCompact', 'web:IFormFactorMax'];

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function isFormFactor(t) {
    return _.contains(FORM_FACTORS, t);
  }
  function containsFormFactor(tags) {
    return !!_.find(tags, isFormFactor);
  }

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A registry for retrieving, storing, and querying information about
   * RequireJS modules registered on baja TypeSpecs. This information will be
   * retrieved directly from the station registry as `web:IJavaScript` classes
   * registered as agents on other Types.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/registry/impl/AgentRegistry
   * @extends module:bajaux/registry/Registry
   */
  var AgentRegistry = /*#__PURE__*/function (_Registry) {
    function AgentRegistry() {
      var _this;
      _classCallCheck(this, AgentRegistry);
      _this = _callSuper(this, AgentRegistry, arguments);
      _this.$fetchedStatus = {};
      return _this;
    }
    _inherits(AgentRegistry, _Registry);
    return _createClass(AgentRegistry);
  }(Registry);
  /**
   * Sanitize registration parameters. In particular, if registering with a
   * form factor interface like `web:IFormFactorMini`, ensure that the
   * `web:IFormFactor` superinterface is included so that the entry will be
   * returned on future queries for `web:IFormFactor`. This is necessary
   * because the `RegAgentOnTypeServlet` et al do not include superinterfaces,
   * only those explicitly declared on the class.
   *
   * @private
   * @param {Object} params registration params
   * @returns {Object} sanitized params
   */
  AgentRegistry.$processParamsForRegistration = function (params) {
    var tags = params && params.tags;
    if (tags && containsFormFactor(tags) && !_.contains(tags, 'web:IFormFactor')) {
      params.tags = tags.concat(['web:IFormFactor']);
    }
    return params;
  };

  /**
   * Check to see if information about the given type spec has already been
   * queried from the station.
   *
   * @private
   * @param {Type|String} typeSpec
   * @returns {Boolean}
   */
  AgentRegistry.prototype.$isFetched = function (typeSpec) {
    return this.$fetchedStatus[typeSpec];
  };

  /**
   * Mark the given type spec as having been queried from the station: no more
   * calls to the registry servlet will be performed for this type spec. (Note
   * that since we added registry info to BajaScript, this no longer saves any
   * actual network traffic; but prevents types from double-registering.)
   *
   * @private
   * @param {Type|String} typeSpec
   */
  AgentRegistry.prototype.$markFetched = function (typeSpec) {
    //TODO: should i be able to un-mark a type so it gets re-fetched?
    this.$fetchedStatus[typeSpec] = true;
  };

  /**
   * Perform the work of fetching all `web:IJavaScript` data down from the
   * station and storing it. After this is complete, the data can be queried
   * and used without ever having to query the station about this type spec
   * again.
   *
   * @private
   * @param {Type} type
   * @returns {Promise} promise to be resolved after all data has been fetched
   * and stored. No data is returned from this function - query the type spec
   * afterwards using the usual `queryAll` etc. If the type has already been
   * fetched, this promise will be immediately resolved without doing any work.
   */
  AgentRegistry.prototype.$pullFromStation = function (type) {
    var that = this,
      stationReg = that.getLocal(),
      toFetch;
    if (that.$isFetched(type)) {
      return Promise.resolve();
    }
    toFetch = _.filter(getSuperTypeChain(type), function (superType) {
      return !that.$isFetched(superType);
    });
    return servletViews.getEntries(toFetch).then(function (arraysOfEntries) {
      _.each(arraysOfEntries, function (entries, i) {
        var typeSpec = toFetch[i];
        if (that.$isFetched(typeSpec)) {
          return;
        }
        _.each(entries.reverse(), function (entry) {
          stationReg.register(typeSpec, AgentRegistry.$processParamsForRegistration({
            deps: entry.getJsDependencies(),
            tags: entry.getTags(),
            rjs: entry.getJsId()
          }));
          that.$markFetched(typeSpec);
        });
      });
    }).then(function () {
      that.emit('changed');
    });
  };

  /**
   * Prepare for a registry query by ensuring that the type is imported and
   * that we've retrieved and preloaded all necessary agent registration info
   * from the station.
   *
   * @private
   * @param {String} typeSpec
   * @returns {Promise} promise to be resolved, with the imported type,
   * after all info is preloaded
   */
  AgentRegistry.prototype.$preQuery = function (typeSpec) {
    var that = this;
    return importTypes(typeSpec).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        t = _ref2[0];
      return that.$pullFromStation(t).then(function () {
        return t;
      });
    });
  };

  /**
   * Query all entries from the station that match the given type spec and
   * parameters. The results will be retrieved using the station's agent
   * registration information if needed. Note that results from supertypes
   * will not be included.
   *
   * @param {Type|String} typeSpec
   * @param {Object} params query parameters
   * @returns {Promise} promise to be resolved with an array of
   * `RegistryEntry` objects, or empty if none found; rejected if the station
   * could not be successfully queried for registry info
   */
  AgentRegistry.prototype.queryAll = function (typeSpec, params) {
    var that = this;
    return that.$preQuery(typeSpec).then(function () {
      return that.getLocal().queryAll(typeSpec, params);
    });
  };

  /**
   * Perform a query on the registry and return only the first matching
   * `RegistryEntry`. (This would be the default view, default menu agent, etc.)
   *
   * @param {Type|String} typeSpec
   * @param {Object} params query parameters
   * @returns {Promise} promise to be resolved with a `RegistryEntry`
   * object, or `undefined` if none found; rejected if the station could not
   * be successfully queried for registry info
   */
  AgentRegistry.prototype.queryFirst = function (typeSpec, params) {
    var that = this;
    return that.$preQuery(typeSpec).then(function () {
      return that.getLocal().queryFirst(typeSpec, params);
    });
  };
  return AgentRegistry;
});
