function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/registry/NiagaraWidgetManager
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.registry.NiagaraWidgetManager', 'bajaux/Properties', 'bajaux/lifecycle/WidgetManager', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feUtils', 'nmodule/webEditors/rc/fe/baja/ComplexSlotEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, log, Properties, WidgetManager, Promise, _, feUtils, ComplexSlotEditor, DisplayOnlyEditor, facetsUtils, typeUtils) {
  'use strict';

  var logWarning = log.warning.bind(log);
  var extend = _.extend;
  var toProperties = facetsUtils.toProperties;
  var deriveSpecifiedConstructor = feUtils.deriveSpecifiedConstructor,
    getFormFactors = feUtils.getFormFactors,
    toRegistryQuery = feUtils.toRegistryQuery;
  var importTypes = typeUtils.importTypes,
    isComplex = typeUtils.isComplex,
    isType = typeUtils.isType;

  /**
   * Performs widget lookups and lifecycle management that are specific to
   * Niagara; it will be aware of Niagara-specific functionality like looking
   * up widgets via agent registrations in the Niagara registry, and
   * instantiating widgets that operate on Slots on Complexes.
   *
   * @private
   * @class
   * @extends module:bajaux/lifecycle/WidgetManager
   * @alias module:nmodule/webEditors/rc/fe/registry/NiagaraWidgetManager
   */
  return /*#__PURE__*/function (_WidgetManager) {
    function NiagaraWidgetManager() {
      _classCallCheck(this, NiagaraWidgetManager);
      return _callSuper(this, NiagaraWidgetManager, arguments);
    }
    _inherits(NiagaraWidgetManager, _WidgetManager);
    return _createClass(NiagaraWidgetManager, [{
      key: "buildContext",
      value: function buildContext(params) {
        var _this = this;
        params = _.extend({}, params, {
          properties: Properties.extend({
            timeFormat: baja.getTimeFormatPattern(),
            unitConversion: baja.getUnitConversion()
          }, params.properties, toProperties(params.facets)).toObject()
        });
        return Promise.resolve(getValue(params)).then(function (value) {
          return _superPropGet(NiagaraWidgetManager, "buildContext", _this, 3)([params]).then(function (cx) {
            var constructorParams = cx.constructorParams;
            extend(constructorParams, params);
            if (typeof cx.value === 'undefined') {
              cx.value = value;
            }
            return cx;
          });
        });
      }

      /**
       * If the `complex` and `slot` params were passed in, we will instantiate a
       * `ComplexSlotEditor`. If no widget constructor is provided, default to a
       * `DisplayOnlyEditor`.
       *
       * @param buildContext
       * @returns {module:bajaux/Widget|Promise.<module:bajaux/Widget>}
       */
    }, {
      key: "instantiate",
      value: function instantiate(buildContext) {
        var constructorParams = buildContext.constructorParams,
          widgetConstructor = buildContext.widgetConstructor;
        var Ctor = widgetConstructor || DisplayOnlyEditor;
        var _ref = constructorParams || {},
          complex = _ref.complex,
          slot = _ref.slot;
        if (complex && slot) {
          //we're editing a slot on a component.
          return ComplexSlotEditor.make(Ctor, constructorParams);
        }
        return !widgetConstructor ? new Ctor(constructorParams) : _superPropGet(NiagaraWidgetManager, "instantiate", this, 3)([buildContext]);
      }

      /**
       * In Niagara world, in addition to the normal `WidgetManager` behavior,
       * the `type` parameter may be a TypeSpec, or the constructor may be defined
       * by a `uxFieldEditor` property.
       *
       * @param {object} params
       * @returns {Promise.<Function>|undefined} the configured constructor,
       * if present
       */
    }, {
      key: "deriveConfiguredConstructor",
      value: function deriveConfiguredConstructor(params) {
        if (isType(params.type)) {
          //if it's a Niagara type, we know the constructor must be resolved from the registry
          return this.resolveFromRegistry(params);
        }
        return Promise.resolve(_superPropGet(NiagaraWidgetManager, "deriveConfiguredConstructor", this, 3)([params])).then(function (ctor) {
          return ctor || deriveSpecifiedConstructor(params);
        });
      }

      /**
       * Looks up the widget constructor by checking the loaded value for a
       * Niagara type, and checking the associated agent registrations in the
       * Niagara registry.
       *
       * @param {object} params
       * @returns {Promise<Function>}
       */
    }, {
      key: "resolveFromRegistry",
      value: function resolveFromRegistry(params) {
        var _this2 = this;
        //if we get here, there's no type and no uxFieldEditor facet.
        //at this point, the editor resolved from the registry is basically
        //unpredictable, and without a formFactor, it might not fit in your
        //DOM element.
        if (getFormFactors(params).length === 0) {
          logWarning(new Error('without formFactor(s) parameter, constructed ' + 'editor will be of undetermined form factor'));
        }
        return getValue(params).then(function (value) {
          if (baja.hasType(value)) {
            return _this2.$registry.resolveFirst(value.getType(), toRegistryQuery(params));
          }
        });
      }
    }]);
  }(WidgetManager);

  /**
   * @private
   * @param {Object} params
   * @returns {Promise} promise to be resolved with an array containing the
   * value and type to use
   */
  function getValue(params) {
    var type = params.type,
      complex = params.complex,
      slot = params.slot,
      value = params.value;

    //if type is given as a type spec string, or as an actual Type object
    if (isType(type)) {
      return importTypes(type).then(function () {
        return baja.$(type);
      });
    } else {
      if (complex && slot) {
        if (!isComplex(complex)) {
          return reject('complex was not actually baja:Complex');
        } else if (!complex.has(slot)) {
          return reject('slot ' + slot + ' does not exist on given Complex');
        } else {
          slot = complex.getSlot(slot);
          if (slot.isProperty()) {
            if (typeof value === 'undefined') {
              value = complex.get(slot);
            }
            if (!baja.hasType(value) || !value.getType().is(slot.getType())) {
              return reject('given value does not match slot type');
            }
            return resolve(value);
          } else {
            return resolve(slot);
          }
        }
      } else {
        return resolve(value);
      }
    }
  }

  /**
   * @returns {Promise.<*>}
   */
  function resolve(obj) {
    return Promise.resolve(obj);
  }

  /**
   * @param {String} err
   * @returns {Promise.<Error>}
   */
  function reject(err) {
    return Promise.reject(new Error(err));
  }
});
