function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara */

define(['baja!', 'bajaux/Properties', 'bajaux/Widget', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry'], function (baja, Properties, Widget, Promise, asyncUtils, facetsUtils, typeUtils, StationRegistry) {
  'use strict';

  var doRequire = asyncUtils.doRequire,
    toFacets = facetsUtils.toFacets,
    importTypes = typeUtils.importTypes,
    isType = typeUtils.isType;

  /**
   * API Status: **Private**
   *
   * @exports nmodule/webEditors/rc/fe/feUtils
   */
  var exports = {};

  /**
   * Check for the presence of a `uxFieldEditor` facet and resolve the specified
   * editor if present. `uxFieldEditor` may be either a type spec resolving to
   * a `BIJavaScript` instance or a RequireJS module ID.
   *
   * @param {module:nmodule/webEditors/rc/fe/fe~FeParams} params
   * @returns {Promise.<Function|undefined>} promise to be resolved with the
   * field editor constructor specified by the `uxFieldEditor` facet,
   * `undefined` if the facet is not present (or not a `BIJavaScript`), or
   * rejected if the facet is present but invalid.
   */
  exports.deriveSpecifiedConstructor = function (params) {
    //TODO: merge facets and properties, and chuck all this
    return exports.$getUxFieldEditor(params).then(function (uxFieldEditor) {
      if (uxFieldEditor) {
        return resolveUxFieldEditor(uxFieldEditor, params);
      }
    });
  };

  /**
   * @param {string} formFactor the name of a Widget form factor (member of
   * {@link module:bajaux/Widget.formfactor Widget.formfactor}, or `any` to
   * indicate any form factor
   * @returns {string} the type spec of `web:IFormFactor` or its appropriate
   * subinterface
   */
  exports.formFactorToInterface = function (formFactor) {
    var wff = Widget.formfactor;
    switch (wff[formFactor] || formFactor) {
      case wff.mini:
        return 'web:IFormFactorMini';
      case wff.compact:
        return 'web:IFormFactorCompact';
      case wff.max:
        return 'web:IFormFactorMax';
      case 'any':
        return 'web:IFormFactor';
      default:
        throw new Error('unrecognized form factor ' + formFactor);
    }
  };

  /**
   * @param {module:nmodule/webEditors/rc/fe/fe~FeParams} params
   * @returns {Array.<string>} the configured form factors
   */
  exports.getFormFactors = function (params) {
    var formFactors = params && params.formFactors,
      formFactor = params && params.formFactor;
    // noinspection JSValidateTypes
    return formFactors ? formFactors.slice() : formFactor ? [formFactor] : [];
  };

  /**
   * @private
   * @param {module:nmodule/webEditors/rc/fe/fe~FeParams} params
   * @returns {Promise.<string|undefined>} the explicitly configured
   * `uxFieldEditor` to use, or `undefined` if none was configured
   */
  exports.$getUxFieldEditor = function (params) {
    if (!params) {
      return Promise.resolve(undefined);
    }

    //TODO: merge facets and properties, and chuck all this
    var facets = toFacets(params.facets),
      complex = params.complex,
      slot = params.slot;
    if (complex && slot) {
      facets = baja.Facets.make(complex.getFacets(slot), facets);
    }
    var uxFieldEditor = facets.get('uxFieldEditor') || new Properties(params.properties).getValue('uxFieldEditor'),
      result;
    if (exports.isRequireJsModule(uxFieldEditor)) {
      result = uxFieldEditor;
    } else if (isType(uxFieldEditor)) {
      result = importTypes(uxFieldEditor).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
          type = _ref2[0];
        if (type.is('web:IJavaScript')) {
          return getReg().queryFirst(uxFieldEditor, exports.toRegistryQuery(params)).then(function (record) {
            return record && String(type);
          });
        }
      });
    }
    return Promise.resolve(result);
  };

  /**
   * Checks to see if a constructor could be found using the specified type and
   * params. This is an existence check only; the associated RequireJS modules
   * will not be downloaded if they haven't already. One exception: if there is
   * a `uxFieldEditor` property present and it references a Baja Type, that Type
   * (and its Type Extension if present) will be loaded in order to perform an
   * instanceof `web:IJavaScript` check.
   *
   * @param {string} type
   * @param {module:nmodule/webEditors/rc/fe/fe~FeParams} params
   * @returns {Promise.<boolean>} resolves true if a matching constructor was
   * found
   */
  exports.hasMatchingConstructor = function (type, params) {
    return exports.$getUxFieldEditor(params).then(function (uxFieldEditor) {
      if (uxFieldEditor) {
        return true;
      }
      return getReg().queryFirst(type, exports.toRegistryQuery(params)).then(function (record) {
        return !!record;
      });
    });
  };

  /**
   * @param {string} str
   * @returns {boolean} true if could be required by RequireJS
   */
  exports.isRequireJsModule = function (str) {
    return typeof str === 'string' && !isType(str);
  };

  /**
   * @param {module:nmodule/webEditors/rc/fe/fe~FeParams} params
   * @returns {object} an object literal that can be used to query the
   * {@link module:nmodule/webEditors/rc/fe/registry/StationRegistry StationRegistry}
   * for entries matching the specified `FeParams`
   */
  exports.toRegistryQuery = function (params) {
    var formFactors = exports.getFormFactors(params);
    if (!formFactors.length) {
      formFactors = ['any'];
    }
    return {
      hasAny: formFactors.map(exports.formFactorToInterface),
      hasAll: baja.isOffline() ? ['web:IOffline'] : [],
      hasNone: typeof niagara !== 'undefined' && niagara.env && niagara.env.type === "wb" ? ['web:IWebOnly'] : []
    };
  };
  function resolveUxFieldEditor(uxFieldEditor, params) {
    if (exports.isRequireJsModule(uxFieldEditor)) {
      return doRequire(uxFieldEditor);
    } else {
      return getReg().resolveFirst(uxFieldEditor, exports.toRegistryQuery(params));
    }
  }
  function getReg() {
    return StationRegistry.getInstance();
  }
  return exports;
});
