function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.fe.feDialogs', 'dialogs', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, lexs, log, dialogs, $, Promise, _, events, Widget, Command, CommandButton, fe, BaseWidget, typeUtils) {
  'use strict';

  var LOAD_EVENT = events.LOAD_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT;
  var VALUE_READY_EVENT = BaseWidget.VALUE_READY_EVENT;
  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var isComplex = typeUtils.isComplex;
  var logError = log.severe.bind(log);
  var DEFAULT_DELAY = 200;
  var ENTER_KEY = 13;
  var errorDetailsHtml = '<div class="errorMessage"/>' + '<pre class="errorDetails" style="display: none;"/>' + '<div class="detailsButton" style="display: none;">' + '<button class="ux-btn"/>' + '</div>';

  /**
   * Functions for showing field editors in modal dialogs. Useful for prompting
   * the user to enter values, edit individual slots, and fire actions.
   *
   * @exports nmodule/webEditors/rc/fe/feDialogs
   */
  var feDialogs = {};

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  //TODO: check for operator flag

  /**
   * Ensures that a mounted `component` and Action `slot` param are present.
   * If an actionArgument is provided ensure its at least a BValue.
   *
   * @private
   * @inner
   * @param {Object} params
   */
  function validateActionParams(params) {
    params = params || {};
    var component = params.component;
    if (!baja.hasType(component, 'baja:Component')) {
      throw new Error('component required');
    }
    if (!component.isMounted()) {
      throw new Error('component must be mounted');
    }
    var slot = component.getSlot(params.slot);
    if (!slot || !slot.isAction()) {
      throw new Error('Action slot required');
    }
    var actionArgument = params.actionArgument;
    if (actionArgument !== undefined && (!baja.hasType(actionArgument) || !actionArgument.getType().isValue())) {
      throw new Error('Action Arguments must be a Value');
    }
  }

  /**
   * Checks for `CONFIRM_REQUIRED` flag and shows confirmation dialog if
   * needed.
   *
   * @private
   * @inner
   * @param {baja.Complex} comp
   * @param {baja.Slot|String} slot
   * @returns {Promise} promise to be resolved if no confirmation was
   * needed or the user did confirm that the action should be invoked. Rejected
   * if the user did not confirm invocation.
   */
  function confirmInvoke(comp, slot) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      if (!(comp.getFlags(slot) & baja.Flags.CONFIRM_REQUIRED)) {
        return resolve();
      }
      var display = comp.getDisplayName(slot);
      dialogs.showOkCancel({
        title: webEditorsLex.get('dialogs.confirmInvoke.title', display),
        content: webEditorsLex.getSafe('dialogs.confirmInvoke.content', display)
      }).ok(resolve).cancel(reject);
    });
  }

  /**
   * Build the editor in the given dialog.
   *
   * As the editor is created, initialized and loaded, progress events with
   * those same names will be passed to the given progress handler. This way,
   * someone using `feDialogs.showFor` can get callbacks for the actual editor
   * instance as it is created, and add event handlers on it, for instance.
   *
   * @inner
   * @param {Object} params fe params
   * @param {JQuery} contentDiv
   * @param {Function} progress
   * @param {Dialog} dlg The Dialog instance.
   * @returns {*}
   */
  function buildEditor(params, contentDiv, progress, dlg) {
    var parent = contentDiv.parent();
    contentDiv.detach();
    return Promise.all([fe.params(params), fe.makeFor(params)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        feParams = _ref2[0],
        ed = _ref2[1];
      progress('created', ed);
      return ed.initialize(contentDiv).then(function () {
        ed.$dlg = dlg;
        progress('initialized', ed);
        return ed.load(feParams.getValueToLoad());
      }).then(function () {
        progress('loaded', ed);
        contentDiv.prependTo(parent);
        return ed;
      });
    });
  }
  function readAndDestroy(ed, shouldSave) {
    var modified = ed.isModified();
    return Promise.resolve(shouldSave && ed.save())["catch"](function (err) {
      feDialogs.error(err)["catch"](logError);
      throw err; //failed to validate - keep dialog open
    }).then(function () {
      return ed.read();
    }).then(function (value) {
      return Promise.resolve(modified && emitValueReady(ed, value)).then(function () {
        return ed.destroy()["catch"](logError);
      }).then(function () {
        return value;
      });
    });
  }

  /**
   * @param {module:bajaux/Widget} ed
   * @param {*} value
   * @returns {Promise}
   */
  function emitValueReady(ed, value) {
    return Promise.all(ed.emit(VALUE_READY_EVENT, value));
  }
  function getErrorTitle(err) {
    return err && err.javaClass || webEditorsLex.get('dialogs.error');
  }
  function getErrorStack(err) {
    if (err instanceof baja.comm.BoxError) {
      return err.javaStackTrace;
    } else if (err && err.stack) {
      return String(err.stack);
    }
  }

  ////////////////////////////////////////////////////////////////
  // ErrorDetailsWidget
  ////////////////////////////////////////////////////////////////

  /**
   * Widget for showing error details.
   *
   * @private
   * @class
   * @extends module:bajaux/Widget
   */
  var ErrorDetailsWidget = /*#__PURE__*/function (_Widget) {
    function ErrorDetailsWidget() {
      _classCallCheck(this, ErrorDetailsWidget);
      return _callSuper(this, ErrorDetailsWidget, arguments);
    }
    _inherits(ErrorDetailsWidget, _Widget);
    return _createClass(ErrorDetailsWidget, [{
      key: "$getDetailsElement",
      value: function $getDetailsElement() {
        return this.jq().children('.errorDetails');
      }
    }, {
      key: "$getMessageElement",
      value: function $getMessageElement() {
        return this.jq().children('.errorMessage');
      }
    }, {
      key: "$getDetailsButtonElement",
      value: function $getDetailsButtonElement() {
        return this.jq().children('.detailsButton');
      }
    }, {
      key: "$getDetailsButton",
      value: function $getDetailsButton() {
        return Widget["in"](this.$getDetailsButtonElement().children('button'));
      }

      /**
       * Build HTML and add `ErrorDetailsWidget` class.
       * @param {JQuery} dom
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.addClass('ErrorDetailsWidget ux-fg');
        dom.html(errorDetailsHtml);
      }

      /**
       * Load details about the error. If the error has additional detail to show,
       * create a "details" button that will show the detail when clicked.
       *
       * @param {Error} err
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(err) {
        var _this = this;
        var msg = err instanceof Error ? err.message : String(err);
        var stack = getErrorStack(err);
        this.$getMessageElement().text(msg);
        if (stack) {
          var buttonDom = this.$getDetailsButtonElement();
          this.$getDetailsElement().text(stack);
          return fe.buildFor({
            dom: buttonDom.children('button'),
            type: CommandButton,
            value: new Command({
              displayName: '%lexicon(webEditors:dialogs.details)%',
              func: function func() {
                _this.$getDetailsElement().show();
                buttonDom.hide();
              }
            })
          }).then(function () {
            return buttonDom.show();
          });
        }
      }

      /**
       * Remove `ErrorDetailsWidget` class and destroy the details button.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ErrorDetailsWidget ux-fg');
        var btn = this.$getDetailsButton();
        return btn && btn.destroy();
      }
    }]);
  }(Widget); ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////
  /**
   * Widget used by `error()` for showing error details.
   * @private
   * @type {module:bajaux/Widget}
   */
  feDialogs.ErrorDetailsWidget = ErrorDetailsWidget;

  /**
   * Shows a field editor in a dialog.
   *
   * When the user clicks OK, the editor will be saved, committing any changes.
   * The value that the user entered will be read from the editor and used to
   * resolve the promise.
   *
   * @param {Object} params params to be passed to `fe.buildFor()`.
   * @param {jQuery} [params.dom] if your widget type should be instantiated
   * into a specific kind of DOM element, it can be passed in as a parameter.
   * Note that the given element will be appended to the dialog element itself,
   * so do not pass in an element that is already parented. If omitted, a `div`
   * will be created and used.
   * @param {String} [params.title] title for the dialog
   * @param {Number} [params.delay=200] delay in ms to wait before showing a
   * loading spinner. The spinner will disappear when the field editor has
   * finished initializing and loading.
   * @param {boolean} [params.save] set to false to specify that the dialog
   * should *not* be saved on clicking OK - only the current value will be read
   * from the editor and used to resolve the promise.
   * @param {Function} [params.progressCallback] pass a progress callback to
   * receive notifications as the editor being shown goes through the stages
   * of its life cycle (`created`, `initialized`, `loaded`), as well as whenever
   * the editor is validated (`invalid`, `valid`).
   * @returns {Promise} promise to be resolved when the user has entered
   * a value into the field editor and clicked OK, or rejected if the field
   * could not be read. The promise will be resolved with the value that the
   * user entered (or `null` if Cancel was clicked).
   *
   * @example
   *   feDialogs.showFor({
   *     value: 'enter a string here (max 50 chars)',
   *     properties: { max: 50 },
   *     progressCallback: function (msg, arg) {
   *       switch(msg) {
   *       case 'created':     return console.log('editor created', arg);
   *       case 'initialized': return console.log('editor initialized', arg.jq());
   *       case 'loaded':      return console.log('editor loaded', arg.value());
   *       case 'invalid':     return console.log('validation error', arg);
   *       case 'valid':       return console.log('value is valid', arg);
   *       }
   *     }
   *   })
   *   .then(function (str) {
   *     if (str === null) {
   *       console.log('you clicked cancel');
   *     } else {
   *       console.log('you entered: ' + str);
   *     }
   *   });
   */
  feDialogs.showFor = function showFor(params) {
    params = baja.objectify(params, 'value');
    var shouldSave = params.save !== false,
      contentDiv = params.dom || $('<div/>');
    if (contentDiv.parent().length) {
      return Promise.reject(new Error('element already parented'));
    }

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      var editor;
      var progress = function progress(event, ed) {
        if (event === 'created') {
          editor = ed;
        }
        params.progressCallback && params.progressCallback(event, ed);
      };
      var firstShown = _.once(function () {
        /* wait until the content is visible then toggle its visibility
        off and on to work around iOS -webkit-touch-scrolling issue */
        contentDiv.toggle(0);
        contentDiv.toggle(0);
        return editor && editor.requestFocus && editor.requestFocus();
      });
      dialogs.showOkCancel({
        delay: params.delay || DEFAULT_DELAY,
        title: params.title,
        layout: function layout() {
          //layout the editor when the dialog lays out
          firstShown();
          return editor && editor.layout();
        },
        content: function content(dlg, _content) {
          contentDiv.appendTo(_content);
          contentDiv.on(LOAD_EVENT + ' ' + MODIFY_EVENT, function (e, ed) {
            if (ed === editor) {
              editor.validate().then(function (value) {
                dlg.buttonJq('ok').attr('title', '');
                dlg.enableButton("ok");
                progress('valid', value);
              }, function (err) {
                dlg.buttonJq('ok').attr('title', String(err));
                dlg.disableButton("ok");
                progress('invalid', err);
              });
            }
          });
          contentDiv.on('keyup', function (e) {
            if (e.which === ENTER_KEY) {
              Widget["in"](contentDiv).validate().then(function () {
                return dlg.click('ok');
              })["catch"](_.noop);
            }
          });
          return buildEditor(params, contentDiv, progress, dlg).then(function (ed) {
            contentDiv.on(VALUE_READY_EVENT, function (e, value) {
              emitValueReady(ed, value).then(function () {
                return ed.destroy()["catch"](logError);
              }).then(function () {
                dlg.close();
                resolve(value);
              })["catch"](logError);
            });
            dlg.ok(function () {
              return readAndDestroy(ed, shouldSave).then(resolve);
            }).cancel(function () {
              return ed.destroy()["catch"](logError).then(function () {
                return resolve(null);
              });
            });
          })["catch"](function (err) {
            _content.text(String(err));
            reject(err);
          });
        }
      });
    });
  };

  /**
   * Show an editor in a dialog, similar to `showFor`, but with the added
   * expectation that the editor represents a one-time interaction, like a
   * button click, after which the dialog can be immediately closed. In other
   * words, the "click ok to close" functionality is embedded in the editor
   * itself. Only a Cancel button will be shown in the dialog itself.
   *
   * In order for the dialog to close, the shown editor must trigger a
   * `feDialogs.VALUE_READY_EVENT`, optionally with a read value. When this
   * event is triggered, the dialog will be closed and the promise resolved
   * with the value passed to the event trigger.
   *
   * @param {Object} params params to be passed to `fe.buildFor`
   * @param {String} [params.title] title for the dialog
   * @param {Number} [params.delay=200] delay in ms to wait before showing a
   * loading spinner. The spinner will disappear when the field editor has
   * finished initializing and loading.
   * @param {Function} [params.progressCallback] pass a progress callback to
   * receive notifications as the editor being shown goes through the stages
   * of its life cycle (created, initialized, loaded).
   * @returns {Promise} promise to be resolved when the editor has
   * triggered its own value event. It will be resolved with any value passed
   * to the event trigger, or with `null` if Cancel was clicked.
   *
   * @example
   *   <caption>Trigger a VALUE_READY_EVENT to cause the dialog to be closed.
   *   </caption>
   *
   * // ...
   * MyEditor.prototype.doInitialize = function (dom) {
   *   dom.on('click', 'button', function () {
   *     dom.trigger(feDialogs.VALUE_READY_EVENT, [ 'my value' ]);
   *   });
   * };
   * //...
   *
   * feDialogs.selfClosing({
   *   type: MyEditor
   * }}
   *   .then(function (value) {
   *     if (value === 'my value') {
   *       //success!
   *     }
   *   });
   */
  feDialogs.selfClosing = function (params) {
    params = baja.objectify(params, 'value');
    var progress = params.progressCallback || $.noop;
    var delay = params.delay;
    if (typeof delay === 'undefined') {
      delay = DEFAULT_DELAY;
    }

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      dialogs.showCancel({
        delay: delay,
        title: params.title,
        content: function content(dlg, _content2) {
          var contentDiv = $('<div/>').appendTo(_content2);
          dlg.cancel(function () {
            return resolve(null);
          });
          buildEditor(params, contentDiv, progress).then(function (ed) {
            contentDiv.on(VALUE_READY_EVENT, function (e, value) {
              ed.destroy()["finally"](function () {
                dlg.close();
                resolve(value);
              });
            });
          })["catch"](reject);
        }
      });
    });
  };

  /**
   * Invoke an action on a mounted component. If the action requires a
   * parameter, a field editor dialog will be shown to retrieve that argument
   * from the user.
   *
   * @param {Object} params
   * @param {baja.Component} params.component the component on which to invoke
   * the action. Must be mounted.
   * @param {String|baja.Slot} params.slot the action slot to invoke. Must be
   * a valid Action slot.
   * @param {baja.Value} [params.actionArgument] Starting in Niagara 4.10, this
   * action argument can be used instead of showing a dialog to obtain
   * the argument.
   * @returns {Promise} promise to be resolved with the action return
   * value if the action was successfully invoked, resolved with `null` if
   * the user clicked Cancel, or rejected if the parameters were invalid or the
   * action could not be invoked.
   */
  feDialogs.action = function action(params) {
    try {
      validateActionParams(params);
    } catch (e) {
      return Promise.reject(e);
    }
    function performInvocation(comp, slot, actionArgument) {
      var actionArgumentProvided = actionArgument !== undefined;
      var param;
      return Promise.resolve(actionArgumentProvided || comp.getActionParameterDefault({
        slot: slot
      })).then(function (p) {
        if (actionArgumentProvided) {
          return actionArgument;
        }
        param = p;
        //if param is called for, read it from a field editor.
        if (param !== null) {
          return feDialogs.showFor({
            title: comp.getDisplayName(slot),
            value: param,
            formFactor: 'any',
            properties: _.extend(comp.getFacets(slot).toObject(), {
              ordBase: comp
            })
          });
        }
      }).then(function (readValue) {
        //TODO: mobile does decodeFromString here. still necessary?
        if (readValue === null) {
          // user clicked cancel to parameter dialog
          return null;
        }
        return comp.invoke({
          //complexes are always edit by ref.
          value: isComplex(param) ? param : readValue,
          slot: slot
        });

        //TODO: mobile forces a sync here. still necessary?
      });
    }
    var comp = params.component;
    var slot = params.slot;
    var actionArgument = params.actionArgument;
    return confirmInvoke(comp, slot).then(function () {
      return performInvocation(comp, slot, actionArgument);
    }, function () {
      return /* invocation canceled */null;
    })["catch"](function (err) {
      return feDialogs.error(err).then(function () {
        throw err;
      });
    });
  };

  /**
   * Show details about an error.
   *
   * @param {Error|*} err
   * @returns {Promise}
   */
  feDialogs.error = function (err) {
    logError(err);
    return feDialogs.showFor({
      title: getErrorTitle(err),
      type: feDialogs.ErrorDetailsWidget,
      value: err
    });
  };
  return feDialogs;
});
