/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, _, spaceUtils, subscriberUtils, typeUtils) {
  'use strict';

  var partial = _.partial;
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var isComplex = typeUtils.isComplex;

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/fe/baja/util/userUtils
   */
  var exports = {};
  exports.$getUserService = leaseWhenNeeded(partial(resolveService, 'baja:UserService'));

  /**
   * Resolve the `baja:User` currently logged in.
   *
   * @param {object|baja.Component} [params] resolution params, or can be the
   * `base` object directly
   * @param {baja.Component} [params.base] a base object to resolve the
   * `UserService` against
   * @param {boolean} [params.lease=true] if true, the `User` will be leased
   * before being resolved
   * @param {number} [params.leaseTime] time in millis to lease the user,
   * otherwise the default lease time will be used
   * @returns {Promise.<baja.Component>} to be resolved with the `baja:User`
   * currently logged in
   */
  exports.resolveCurrentUser = function () {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (isComplex(params)) {
      params = {
        base: params
      };
    }
    var _params = params,
      base = _params.base,
      _params$lease = _params.lease,
      lease = _params$lease === void 0 ? true : _params$lease,
      leaseTime = _params.leaseTime;
    return exports.$getUserService(base).then(function (userService) {
      var user = userService.get(baja.SlotPath.escape(baja.getUserName()));
      if (lease) {
        return user.lease({
          time: leaseTime
        }).then(function () {
          return user;
        });
      } else {
        return user;
      }
    });
  };
  return exports;
});
