/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
/*jshint devel: true */
/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor
 */
define(['jquery', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/js/rc/jquery/Relevant-Dropdowns/js/jquery.relevant-dropdown'], function ($, StringEditor) {
  'use strict';

  /**
   * Extension of StringEditor to shim in `datalist` support via the
   * Relevant Dropdowns jQuery plugin:
   *
   * http://css-tricks.com/relevant-dropdowns-polyfill-for-datalist/
   *
   * This editor will probably never be removed - it allows for custom rendering
   * of `datalist`s that we'll sometimes need but will probably never be
   * supported in browsers. Use the following Properties:
   *
   * - `relevant-force`: force the usage of Relevant even if the browser does
   *   have native `datalist` support
   * - `relevant-filter`: the usual `datalist` behavior is to filter down the
   *   displayed options to only those that match the currently entered string.
   *   Set this to `false` to show *all* options no matter what string is
   *   currently entered. Useful for matching `DynamicEnum` behavior in WB.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/StringEditor
   * @see module:nmodule/js/rc/jquery/Relevant-Dropdowns/js/jquery.relevant-dropdown
   */
  var RelevantStringEditor = function RelevantStringEditor() {
    StringEditor.apply(this, arguments);
  };
  RelevantStringEditor.prototype = Object.create(StringEditor.prototype);
  RelevantStringEditor.prototype.constructor = RelevantStringEditor;
  RelevantStringEditor.prototype.$getDatalistElement = function () {
    return this.jq().children('datalist, .datalist');
  };
  RelevantStringEditor.prototype.$isDatalistShowing = function () {
    var dl = $('#' + this.$getTextElement().attr('list'));
    return dl.length && dl.css('display') !== 'none' && parseFloat(dl.css('opacity')) > 0;
  };

  /**
   * Set up Relevant dropdown on input if a datalist is present.
   */
  RelevantStringEditor.prototype.$rebuildHtml = function () {
    var that = this,
      dom = that.jq();

    //clean up handlers from previous Relevant call
    that.$destroyDatalist();
    dom.children('input, ul').off();
    StringEditor.prototype.$rebuildHtml.apply(this, arguments);
    var datalist = dom.children('datalist'),
      input = dom.children('input');
    if (datalist.length) {
      //if the user is pressing enter to select a value from the dropdown,
      //swallow it once so it doesn't cause a form submission.
      input.on('keyup keydown keypress', function (e) {
        if (e.keyCode === 13) {
          //enter
          if (that.$isDatalistShowing()) {
            return false;
          }
        }
      });
      input.relevantDropdown({
        force: that.properties().getValue('relevant-force'),
        showAll: that.properties().getValue('relevant-filter') === false,
        fadeOutSpeed: 100,
        change: function change() {
          var textElement = that.$getTextElement();
          //ensure we get modify events when selecting from datalist w/ enter key
          textElement.trigger('input');
          if (that.properties().getValue('hideText')) {
            textElement.blur();
          }
        },
        datalist: datalist
      });
    }
  };
  RelevantStringEditor.prototype.$getDatalistElement = function () {
    return $('#' + this.$getTextElement().attr('list'));
  };
  RelevantStringEditor.prototype.$destroyDatalist = function () {
    var list = $('#' + this.$getTextElement().attr('list'));
    list.off().remove();
  };
  RelevantStringEditor.prototype.doDestroy = function () {
    this.$destroyDatalist();
    this.jq().children('input, ul').off();
    return StringEditor.prototype.doDestroy.apply(this, arguments);
  };
  return RelevantStringEditor;
});
