/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/OverrideEditor
 */
define(['baja!', 'lex!control', 'bajaux/Properties', 'underscore', 'nmodule/webEditors/rc/fe/baja/OverrideRelTimeEditor', 'nmodule/webEditors/rc/wb/PropertySheet'], function (baja, lexs, Properties, _, OverrideRelTimeEditor, PropertySheet) {
  'use strict';

  var controlLex = lexs[0];

  /**
   * A field editor for working with subclasses of `control:Override`. Loads
   * a special `RelTime` editor that allows for selection of predetermined
   * durations, and an editor for whatever Type is in the `value` slot.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   * @alias module:nmodule/webEditors/rc/fe/baja/OverrideEditor
   * @see module:nmodule/webEditors/rc/fe/baja/OverrideRelTimeEditor
   */
  var OverrideEditor = function OverrideEditor(params) {
    PropertySheet.call(this, _.extend({}, params, {
      keyName: 'OverrideEditor',
      properties: _.extend({
        showFooter: false,
        showHeader: false
      }, params && params.properties)
    }));
  };
  OverrideEditor.prototype = Object.create(PropertySheet.prototype);
  OverrideEditor.prototype.constructor = OverrideEditor;
  OverrideEditor.prototype.makeBuilder = function () {
    var builder = PropertySheet.prototype.makeBuilder.apply(this, arguments);
    builder.getDisplayNameFor = function (key) {
      return controlLex.get('override.' + key);
    };
    return builder;
  };

  /**
   * Edit the `duration` slot with an `OverrideRelTimeEditor`, and the `value`
   * slot (if present) using the default editor.
   * @returns {Function}
   */
  OverrideEditor.prototype.getSlotFilter = function () {
    var that = this;
    return function (slot) {
      switch (slot.getName()) {
        case 'value':
          return {
            properties: that.properties().toObject()
          };
        case 'duration':
          var maxOverride = this.get('maxOverrideDuration'),
            properties;
          if (maxOverride.getMillis() > 0) {
            properties = {
              min: baja.RelTime.make(1),
              max: maxOverride
            };
          }
          return {
            properties: properties,
            type: OverrideRelTimeEditor
          };
      }
    };
  };
  return OverrideEditor;
});
