function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/EnumRangeRowEditor
 */
define(['baja!', 'lex!', 'log!nmodule.webEditors.rc.fe.baja.EnumRangeRowEditor', 'Promise', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'hbs!nmodule/webEditors/rc/fe/baja/template/EnumRangeEditor-row'], function (baja, lex, log, Promise, events, BaseEditor, DisplayOnlyEditor, tplEnumRangeEditorRow) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
    logError = log.severe.bind(log);

  /**
   * Given an `EnumRange` tag value, look up the display value from the
   * given lexicon.
   *
   * @private
   * @inner
   * @param {String} tag tag value (raw input to tag editor)
   * @param {String} [lexicon] lexicon module name
   * @returns {Promise} promise to be resolved with the value looked
   * up from the specified lexicon, or the SlotPath-unescaped raw tag value
   * if it could not be found
   */
  function getTagDisplayFromLexicon(tag, lexicon) {
    var unescaped = baja.SlotPath.unescape(tag);
    if (!lexicon) {
      return Promise.resolve(unescaped);
    }
    return lex.module(lexicon).then(function (lex) {
      return lex.get({
        //TODO: why not support things like monday.short? that's dumb
        key: baja.SlotPath.escape(tag),
        def: unescaped
      });
    }, function err() {
      return unescaped;
    });
  }

  /**
   * An editor for working with a single row in an `EnumRangeEditor`. No
   * reason to load it anywhere else but inside that editor.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/EnumRangeRowEditor
   */
  var EnumRangeRowEditor = function EnumRangeRowEditor() {
    BaseEditor.apply(this, arguments);
  };
  EnumRangeRowEditor.prototype = Object.create(BaseEditor.prototype);
  EnumRangeRowEditor.prototype.constructor = EnumRangeRowEditor;

  /**
   * Returns the `IntegerEditor` for the ordinal.
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/IntegerEditor}
   */
  EnumRangeRowEditor.prototype.$getOrdinalEditor = function () {
    return this.jq().children('.ordinal').data('widget');
  };

  /**
   * Returns the `StringEditor` for the tag.
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  EnumRangeRowEditor.prototype.$getTagEditor = function () {
    return this.jq().children('.tag').data('widget');
  };

  /**
   * Returns the `DisplayOnlyEditor` for the tag's display value (pulled from
   * lexicon).
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor}
   */
  EnumRangeRowEditor.prototype.$getDisplayEditor = function () {
    return this.jq().children('.display').data('widget');
  };

  /**
   * The lexicon module used by this row.
   * @returns {String}
   */
  EnumRangeRowEditor.prototype.$getLexicon = function () {
    return this.$lexicon;
  };

  /**
   * Sets the lexicon currently used, and triggers an update of the row's
   * display value to reflect the new lexicon.
   * @param {String} lexicon the lexicon module to use
   */
  EnumRangeRowEditor.prototype.$setLexicon = function (lexicon) {
    this.$lexicon = lexicon;
    return this.$updateDisplay();
  };

  /**
   * Gets the currently entered tag, looks it up against the lexicon, and
   * updates the display value accordingly.
   *
   * @private
   * @returns {Promise} promise to be resolved after the display value
   * has been updated
   */
  EnumRangeRowEditor.prototype.$updateDisplay = function () {
    var that = this;
    return that.$getTagEditor().read().then(function (tag) {
      return getTagDisplayFromLexicon(tag, that.$getLexicon());
    }).then(function (display) {
      return that.$getDisplayEditor().load(display);
    });
  };

  /**
   * Loads editors into a `<tr>` element to edit one ordinal/tag pair
   * in an `EnumRange`. Arms event handler to dynamically resolve the display
   * value of the currently entered tag, using the range's `lexicon` option.
   *
   * Includes a delete button that when clicked will destroy this editor and
   * remove it from the dom.
   *
   * @param {JQuery} tr
   */
  EnumRangeRowEditor.prototype.doInitialize = function (tr) {
    var that = this;
    tr.html(tplEnumRangeEditorRow({
      disabled: !this.isEnabled()
    }));
    tr.on('click', 'button.delete', function () {
      //self destruct!
      that.destroy()["catch"](logError);
    });
    tr.on(MODIFY_EVENT, '.tag', function () {
      that.$updateDisplay()["catch"](logError);
      return false;
    });
    tr.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([that.buildChildFor({
      value: baja.Integer.DEFAULT,
      dom: tr.children('.ordinal'),
      formFactor: 'mini'
    }), that.buildChildFor({
      value: '',
      dom: tr.children('.tag'),
      formFactor: 'mini'
    }), that.buildChildFor({
      type: DisplayOnlyEditor,
      value: '',
      dom: tr.children('.display')
    })]);
  };
  EnumRangeRowEditor.prototype.isFromFrozen = function () {
    return !!this.$fromFrozen;
  };

  /**
   * Loads data for one ordinal/tag pair into the editor.
   *
   * @param {Object} obj
   * @param {Number|baja.Integer} obj.ordinal
   * @param {String} obj.tag
   * @param {Boolean} obj.fromFrozen marks this row as being from a frozen enum
   * and therefore does not need to be read/saved back to the range
   * @param {String} [obj.lexicon] lexicon module name to use for tag lookups
   * @returns {Promise} promise to be resolved when ordinal and tag
   * editors and display value are all loaded
   */
  EnumRangeRowEditor.prototype.doLoad = function (obj) {
    var that = this;
    this.$fromFrozen = obj.fromFrozen;
    return Promise.all([that.$getOrdinalEditor().load(baja.Integer.make(obj.ordinal)), that.$getTagEditor().load(baja.SlotPath.unescape(obj.tag))]).then(function () {
      return that.$setLexicon(obj.lexicon);
    });
  };

  /**
   * Reads currently entered ordinal and tag and returns an object with
   * `ordinal` (`baja.Integer`) and `tag` (`String`) properties.
   *
   * @returns {Promise} promise to be resolved with ordinal/tag object
   * (note returned tag will be `SlotPath`-escaped).
   */
  EnumRangeRowEditor.prototype.doRead = function () {
    return Promise.all([this.$getOrdinalEditor().read(), this.$getTagEditor().read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        ordinal = _ref2[0],
        tag = _ref2[1];
      return {
        ordinal: ordinal,
        tag: baja.SlotPath.escape(tag)
      };
    });
  };

  /**
   * Enables/disables ordinal and tag editors and the remove button.
   * @param {Boolean} enabled
   */
  EnumRangeRowEditor.prototype.doEnabled = function (enabled) {
    this.jq().find('button').prop('disabled', this.isReadonly() || !enabled);
    return this.getChildWidgets().setAllEnabled(enabled);
  };

  /**
   * Sets ordinal and tag editors readonly and enables/disables the remove
   * button.
   * @param {Boolean} readonly
   */
  EnumRangeRowEditor.prototype.doReadonly = function (readonly) {
    this.jq().find('button').prop('disabled', !this.isEnabled() || readonly);
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * Destroy all child editors in this row.
   *
   * @returns {Promise}
   */
  EnumRangeRowEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  return EnumRangeRowEditor;
});
