function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/EnumRangeEditor
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.baja.EnumRangeEditor', 'bajaux/Widget', 'lex!webEditors', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/EnumRangeRowEditor', 'hbs!nmodule/webEditors/rc/fe/baja/template/EnumRangeEditor'], function (baja, log, Widget, lexs, $, Promise, _, events, BaseEditor, DisplayOnlyEditor, EnumRangeRowEditor, tplEnumRangeEditor) {
  'use strict';

  var webEditorsLex = lexs[0],
    logError = log.severe.bind(log),
    MODIFY_EVENT = events.MODIFY_EVENT,
    DESTROY_EVENT = events.DESTROY_EVENT,
    ENTER_KEY = 13;

  ////////////////////////////////////////////////////////////////
  // Private inner utility functions. Scroll down for actual editor definition.
  ////////////////////////////////////////////////////////////////

  /**
   * Get the next available ordinal that can be added to the `EnumRange`.
   *
   * @private
   * @inner
   * @param {baja.EnumRange} range
   * @returns {Number}
   */
  function nextAvailableOrdinal(range) {
    var ordinals = range.getOrdinals();
    if (!ordinals.length) {
      //empty range, start w/ 0
      return 0;
    }
    return _.max(ordinals) + 1;
  }

  /**
   * Give the element focus and select all text.
   *
   * @private
   * @inner
   * @param {jQuery} elem
   */
  function focusAndSelect(elem) {
    elem.focus().select();
  }

  /**
   * Event handler to be fired when a key is pressed in an input field.
   *
   * - When Enter is pressed on an ordinal editor, moves focus to the tag
   *   editor.
   * - When Enter is pressed on a tag editor, moves focus to the ordinal editor
   *   in the next row.
   * - When Enter is pressed on the very last tag editor, creates a new row.
   *
   * @private
   * @inner
   * @param {jQuery} input the input field firing the event
   * @param {Number} keyCode which key was pressed
   * @param {module:nmodule/webEditors/rc/fe/baja/EnumRangeEditor} ed the editor
   * instance
   */
  function inputKeyPressed(input, keyCode, ed) {
    //move input to the next editor
    function focusNext(td) {
      var tr = td.closest('tr');
      if (td.is('.ordinal')) {
        focusAndSelect(tr.find('.tag input'));
      } else {
        focusAndSelect(tr.next().find('.ordinal input'));
      }
    }

    //am i the very last tag field in the EnumRange editor?
    function isLastTagEditor(td) {
      return td.is('.tag') && td.closest('tr').is(':last-of-type');
    }
    if (keyCode === ENTER_KEY) {
      var td = input.closest('td');
      if (isLastTagEditor(td)) {
        ed.$addNewRow();
      } else {
        focusNext(td);
      }
    }
  }
  function toOrdinal(row) {
    return row.ordinal.valueOf();
  }
  function toTag(row) {
    return row.tag;
  }

  /**
   * Assembles the read ordinals, tags, and options into an `EnumRange`
   * (sorting by ordinal).
   *
   * @private
   * @inner
   * @param {Array.<Object>} rows read from `EnumRangeRowEditor`s
   * @param {baja.Facets} [options]
   * @param {String|Type} [frozen]
   * @returns {baja.EnumRange}
   */
  function makeRange(rows, options, frozen) {
    //TODO: should EnumRange itself sort by ordinal?
    rows.sort(function (a, b) {
      return a.ordinal - b.ordinal;
    });

    //TODO: baja.EnumRange throws up if ordinals are not Number/baja.Double. should accept Integers
    //convert back to arrays of ordinals and tags
    return baja.EnumRange.make({
      frozen: frozen,
      ordinals: _.map(rows, toOrdinal),
      tags: _.map(rows, toTag),
      options: options
    });
  }

  ////////////////////////////////////////////////////////////////
  // EnumRangeEditor definition.
  ////////////////////////////////////////////////////////////////

  /**
   * A field editor for working with `EnumRange`s.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/EnumRangeEditor
   */
  var EnumRangeEditor = function EnumRangeEditor(params) {
    BaseEditor.call(this, $.extend({
      keyName: 'EnumRangeEditor'
    }, params));
    if (this.getFormFactor() === Widget.formfactor.mini) {
      DisplayOnlyEditor.$mixin(this);
    }
  };
  EnumRangeEditor.prototype = Object.create(BaseEditor.prototype);
  EnumRangeEditor.prototype.constructor = EnumRangeEditor;

  /**
   * Get the table element containing details and controls for the range.
   *
   * @private
   * @returns {jQuery}
   */
  EnumRangeEditor.prototype.$getTable = function () {
    return this.jq().children('.rows-table').children('table');
  };

  /**
   * Get the table body, which contains the rows for each ordinal/tag pair.
   *
   * @private
   * @returns {jQuery}
   */
  EnumRangeEditor.prototype.$getTableBody = function () {
    return this.$getTable().children('tbody');
  };

  /**
   * Get the button for adding a new row.
   *
   * @private
   * @returns {jQuery}
   */
  EnumRangeEditor.prototype.$getAddButton = function () {
    return this.$getTable().children('tfoot').find('button.add');
  };

  /**
   * Get the element where the "use frozen" checkbox lives.
   *
   * @private
   * @returns {jQuery}
   */
  EnumRangeEditor.prototype.$getUseFrozenElement = function () {
    return this.jq().children('.frozen').children('.useFrozen');
  };

  /**
   * Get the "use frozen" boolean editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanEditor}
   */
  EnumRangeEditor.prototype.$getUseFrozenEditor = function () {
    return this.$getUseFrozenElement().data('widget');
  };

  /**
   * Get the element where the frozen type spec editor lives.
   *
   * @private
   * @returns {jQuery}
   */
  EnumRangeEditor.prototype.$getFrozenTypeSpecElement = function () {
    return this.jq().children('.frozen').children('.typeSpec');
  };

  /**
   * Get the frozen type spec editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/TypeSpecEditor}
   */
  EnumRangeEditor.prototype.$getFrozenTypeSpecEditor = function () {
    return this.$getFrozenTypeSpecElement().data('widget');
  };

  /**
   * Returns the string editor used to edit the lexicon used for
   * the `EnumRange`.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  EnumRangeEditor.prototype.$getLexiconEditor = function () {
    return this.getChildEditors(this.jq().children('.lexicon'))[0];
  };

  /**
   * Returns the editors for each ordinal/tag row in this `EnumRange`.
   * @private
   * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/EnumRangeRowEditor>}
   */
  EnumRangeEditor.prototype.$getRowEditors = function () {
    return this.getChildEditors(this.$getTableBody());
  };

  /**
   * Add and initialize a new row of ordinal/tag editors.
   *
   * @private
   * @returns {Promise} promise to be resolved with the newly added
   * `EnumRangeRowEditor`
   */
  EnumRangeEditor.prototype.$addNewRow = function addNewRow() {
    var that = this,
      tbody = that.$getTableBody(),
      row = $('<tr class="ux-table-row"/>');
    return that.read().then(function (range) {
      var ordinal = nextAvailableOrdinal(range);
      return that.buildChildFor({
        type: EnumRangeRowEditor,
        value: {
          ordinal: ordinal,
          tag: String(ordinal),
          lexicon: range.getOptions().get('lexicon')
        },
        dom: row
      });
    }).then(function (rowEditor) {
      tbody.append(row);
      focusAndSelect(row.find('.tag input'));
      that.setModified(true);
      return rowEditor;
    });
  };

  /**
   * Called whenever the currently entered lexicon is changed. Updates each
   * row's display value to reflect any values pulled from the new lexicon.
   *
   * @private
   * @returns {Promise}
   */
  EnumRangeEditor.prototype.$lexiconChanged = function () {
    var that = this;
    return that.$getLexiconEditor().read().then(function (lexicon) {
      _.each(that.$getRowEditors(), function (ed) {
        ed.$setLexicon(lexicon);
      });
    });
  };

  /**
   * When a change is made to the frozen type (either the "use frozen" checkbox
   * clicked or a new type spec selected), update the table rows accordingly.
   *
   * @private
   * @returns {Promise}
   */
  EnumRangeEditor.prototype.$frozenTypeChanged = function () {
    var that = this,
      useFrozenEd = that.$getUseFrozenEditor(),
      frozenTypeEd = that.$getFrozenTypeSpecEditor(),
      lexiconEd = that.$getLexiconEditor();
    return Promise.all([useFrozenEd.read(), frozenTypeEd.read(), lexiconEd.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        useFrozen = _ref2[0],
        typeSpec = _ref2[1],
        lexicon = _ref2[2];
      var hasTypeSpec = typeSpec && String(typeSpec) !== 'null',
        options = lexicon ? baja.Facets.make({
          lexicon: lexicon
        }) : undefined,
        rangeToLoad = useFrozen && hasTypeSpec ? baja.EnumRange.make({
          frozen: String(typeSpec),
          options: options
        }) : baja.EnumRange.DEFAULT;
      return Promise.all([frozenTypeEd.setEnabled(useFrozen), that.$loadTableRows(rangeToLoad)]);
    });
  };

  /**
   * Loads the contents of an EnumRange into the table, one row per ordinal/tag
   * pair.
   *
   * @private
   * @param {baja.EnumRange} range
   * @returns {Promise}
   */
  EnumRangeEditor.prototype.$loadTableRows = function (range) {
    var that = this,
      ordinals = range.getOrdinals(),
      frozenType = range.getFrozenType(),
      hasFrozen = !!frozenType,
      frozenOrdinals = hasFrozen && baja.$(frozenType).getRange().getOrdinals(),
      lexicon = range.getOptions().get('lexicon') || '';
    function toRowEditor(ordinal) {
      var tag = range.getTag(ordinal),
        isFromFrozen = hasFrozen && frozenOrdinals.indexOf(ordinal) >= 0;
      return that.buildChildFor({
        type: EnumRangeRowEditor,
        value: {
          ordinal: ordinal,
          tag: tag,
          lexicon: lexicon,
          fromFrozen: isFromFrozen
        },
        readonly: isFromFrozen,
        dom: $('<tr class="ux-table-row"/>')
      });
    }
    return Promise.all(ordinals.map(toRowEditor)).then(function (eds) {
      var elems = _.map(eds, function (ed) {
        return ed.jq();
      });
      that.$getTableBody().html(elems);
    });
  };

  /**
   * Creates an HTML table to hold field editors for the ordinals and tags
   * of an `EnumRange`.
   *
   * Each row has a button for deleting that row.
   *
   * @param {JQuery} dom
   */
  EnumRangeEditor.prototype.doInitialize = function (dom) {
    var that = this,
      lexiconId = that.generateId(),
      useFrozenText = webEditorsLex.get('EnumRangeEditor.useFrozen');

    //TODO: MRU

    dom.html(tplEnumRangeEditor({
      headers: {
        ordinal: webEditorsLex.get('EnumRangeEditor.ordinal'),
        tag: webEditorsLex.get('EnumRangeEditor.tag'),
        display: webEditorsLex.get('EnumRangeEditor.display')
      },
      lexiconLabel: webEditorsLex.get('EnumRangeEditor.lexicon')
    }));
    dom.on('click', 'button.add', function () {
      var button = $(this);
      button.prop('disabled', true);
      that.$addNewRow()["catch"](logError)["finally"](function () {
        button.prop('disabled', false);
      });
    });
    dom.on('keyup', 'input', function (e) {
      inputKeyPressed($(this), e.which, that);
    });

    //if a row is modified, set myself modified
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.frozen .editor', function () {
      that.$frozenTypeChanged()["catch"](logError);
      return false;
    });

    //if a row is destroyed, remove it from my DOM and set myself modified
    dom.on(DESTROY_EVENT, '.editor', function (e) {
      $(e.target).remove();
      that.setModified(true);
      return false;
    });
    dom.on('change', '.lexicon', function () {
      that.$lexiconChanged()["catch"](logError);
    });

    //TODO: should this go into StringEditor?
    $('label', dom.children('.lexicon')).attr('for', lexiconId);
    return Promise.all([
    //lexicon editor
    that.buildChildFor({
      value: '',
      dom: $('span', dom.children('.lexicon')),
      formFactor: 'mini'
    }),
    //"use frozen" checkbox
    that.buildChildFor({
      value: false,
      dom: $('.useFrozen', dom.children('.frozen')),
      properties: {
        trueText: useFrozenText,
        falseText: useFrozenText
      },
      formFactor: 'mini'
    }),
    //frozen type selector
    that.buildChildFor({
      value: baja.$('baja:TypeSpec'),
      dom: $('.typeSpec', dom.children('.frozen')),
      properties: {
        targetType: 'baja:FrozenEnum'
      },
      formFactor: 'mini'
    })]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
        lexiconEditor = _ref4[0];
      lexiconEditor.jq().find('input').attr('id', lexiconId);
    });
  };

  /**
   * Creates one row in the table for each ordinal by initializing and
   * loading a new `EnumRangeRowEditor`.
   *
   * @param {baja.EnumRange} value
   * @returns {Promise} promise to be resolved when all row editors have
   * finished loading
   * @see module:nmodule/webEditors/rc/fe/baja/EnumRangeRowEditor
   */
  EnumRangeEditor.prototype.doLoad = function (value) {
    var that = this,
      frozenType = value.getFrozenType(),
      hasFrozen = !!frozenType,
      lexicon = value.getOptions().get('lexicon') || '',
      frozenTypeEd = that.$getFrozenTypeSpecEditor();
    return Promise.all([that.$loadTableRows(value), that.$getLexiconEditor().load(lexicon), that.$getUseFrozenEditor().load(hasFrozen), hasFrozen && frozenTypeEd.load(baja.$('baja:TypeSpec', frozenType.getTypeSpec())), frozenTypeEd.setEnabled(hasFrozen)]);
  };

  /**
   * Reads current values of all ordinal and tag editors, the lexicon and
   * selected frozen type (if any), and assembles them into an `EnumRange`
   * instance.
   *
   * @returns {Promise} promise to be resolved with a `baja.EnumRange`,
   * or rejected if the editors contained values that were invalid for an
   * `EnumRange`
   */
  EnumRangeEditor.prototype.doRead = function () {
    var that = this,
      useFrozenEd = that.$getUseFrozenEditor(),
      frozenTypeEd = that.$getFrozenTypeSpecEditor(),
      lexiconEd = that.$getLexiconEditor(),
      rowEds = that.$getRowEditors(),
      readUserRows = Promise.all(_.compact(_.map(rowEds, function (ed) {
        return !ed.isFromFrozen() && ed.read();
      })));
    return Promise.all([useFrozenEd.read(), frozenTypeEd.read(), lexiconEd.read(), readUserRows]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 4),
        useFrozen = _ref6[0],
        frozenType = _ref6[1],
        lexicon = _ref6[2],
        rows = _ref6[3];
      var options = lexicon ? baja.Facets.make({
          lexicon: lexicon
        }) : undefined,
        frozen = useFrozen && frozenType ? String(frozenType) : undefined;
      return makeRange(rows, options, frozen);
    });
  };

  /**
   * Enables/disables all sub-field editors and add/remove buttons.
   *
   * @param {Boolean} enabled
   */
  EnumRangeEditor.prototype.doEnabled = function (enabled) {
    this.jq().find('button').prop('disabled', this.isReadonly() || !enabled);
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Sets all sub-field editors readonly/writable and enables/disables
   * add/remove button.
   *
   * @param {Boolean} readonly
   */
  EnumRangeEditor.prototype.doReadonly = function (readonly) {
    this.jq().find('button').prop('disabled', !this.isEnabled() || readonly);
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all child rows in the editor.
   *
   * @returns {Promise}
   */
  EnumRangeEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return EnumRangeEditor;
});
