function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/DynamicEnumEditor
 */
define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, $, Promise, _, CompositeEditor, rangeUtils, CompositeBuilder) {
  'use strict';

  var getEnumRangeDisplay = rangeUtils.getEnumRangeDisplay;

  /**
   * A field editor for working with `DynamicEnum`s.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/DynamicEnumEditor
   */
  var DynamicEnumEditor = function DynamicEnumEditor(params) {
    CompositeEditor.call(this, $.extend({
      keyName: 'DynamicEnumEditor'
    }, params));
  };
  DynamicEnumEditor.prototype = Object.create(CompositeEditor.prototype);
  DynamicEnumEditor.prototype.constructor = DynamicEnumEditor;

  /**
   * Use a single-key CompositeBuilder so I don't have to manage all those
   * events by hand.
   * TODO: a ProxyEditor or similar because this is such a common use case -
   * i have a value of one data type, but i want to translate it into this
   * other type for the editor
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  DynamicEnumEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['string'];
    };
    builder.getDomFor = function () {
      return $('<div/>').appendTo(that.jq());
    };
    builder.getValueFor = function () {
      var dynEnum = this.getDataSource();
      return String(dynEnum.getOrdinal());
    };
    builder.getConfigFor = function () {
      var range = that.$getRangeFor(this.getDataSource()),
        ordinals = range.getOrdinals(),
        datalist = {};
      return Promise.all(_.map(ordinals, function (ordinal) {
        return getEnumRangeDisplay(ordinal, range);
      })).then(function (displays) {
        _.each(ordinals, function (ordinal, i) {
          datalist[ordinal] = displays[i];
        });
        return {
          properties: {
            //always force the Relevant dropdown and show all entries
            'relevant-force': true,
            'relevant-filter': false,
            datalist: datalist
          },
          formFactor: 'mini'
        };
      });
    };
    return builder;
  };

  /**
   * Returns the `range` facet set on the editor, only if it is present and
   * is of type `baja:EnumRange`.
   *
   * @private
   * @returns {baja.EnumRange|undefined} range facet set, or undefined if not present
   * or not `EnumRange`
   */
  DynamicEnumEditor.prototype.$getRangeFacet = function () {
    var range = this.properties().getValue('range');
    if (baja.hasType(range, 'baja:EnumRange')) {
      return range;
    }
  };

  /**
   * Get the appropriate range to use for the loaded `DynamicEnum` (may be
   * overridden by a property).
   * @private
   * @param {baja.DynamicEnum} dynamicEnum
   * @returns {baja.EnumRange|undefined}
   */
  DynamicEnumEditor.prototype.$getRangeFor = function (dynamicEnum) {
    return this.$getRangeFacet() || dynamicEnum.getRange();
  };

  /**
   * Reads the currently selected `<option>` value and returns a new
   * `DynamicEnum` using that value as the ordinal.
   *
   * @returns {Promise.<baja.DynamicEnum>} a `DynamicEnum` instance
   * with the selected ordinal
   */
  DynamicEnumEditor.prototype.doRead = function () {
    var that = this,
      en = that.value();
    return that.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        str = _ref2[0];
      if (!str) {
        return baja.DynamicEnum.DEFAULT;
      }
      var ordinal = parseInt(str, 10);
      if (isNaN(ordinal)) {
        throw new Error('invalid ordinal: ' + str);
      } else {
        return baja.DynamicEnum.make({
          range: that.$getRangeFacet() || en.getRange(),
          ordinal: ordinal
        });
      }
    });
  };
  return DynamicEnumEditor;
});
