function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor
 */
define(['baja!', 'lex!webEditors', 'jquery', 'nmodule/webEditors/rc/fe/baja/PasswordEditor', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, lexs, $, PasswordEditor, CompositeEditor, CompositeBuilder) {
  'use strict';

  var webEditorsLex = lexs[0],
    CONFIRM = webEditorsLex.get('UserPasswordEditor.confirm'),
    PASSWORD = webEditorsLex.get('UserPasswordEditor.password'),
    PASSWORD_MISMATCH = webEditorsLex.get('UserPasswordEditor.passwordMismatch'),
    KEY_PASSWORD = 'p',
    KEY_CONFIRM = 'c',
    keys = [KEY_PASSWORD, KEY_CONFIRM];

  /**
   * Editor for handling `baja:Password` values that need a confirmation.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor
   */
  var ConfirmPasswordEditor = function ConfirmPasswordEditor(params) {
    var that = this;
    CompositeEditor.apply(this, arguments);
    that.validators().add(function (val) {
      return that.$getConfirmEditor().read().then(function (confirm) {
        if (val.encodeToString() !== confirm.encodeToString()) {
          throw new Error(PASSWORD_MISMATCH);
        }
      });
    });
  };
  ConfirmPasswordEditor.prototype = Object.create(CompositeEditor.prototype);
  ConfirmPasswordEditor.prototype.constructor = ConfirmPasswordEditor;
  ConfirmPasswordEditor.prototype.doInitialize = function (dom) {
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  /**
   * @overrides module:nmodule/webEditors/rc/fe/CompositeEditor
   * @returns {*}
   */
  ConfirmPasswordEditor.prototype.makeBuilder = function () {
    var that = this;
    var builder = new CompositeBuilder();
    builder.getDomFor = function (i) {
      return $('<div data-key="' + i + '"></div>').appendTo(that.jq());
    };
    builder.getKeys = function () {
      return keys;
    };
    builder.getValueFor = function () {
      return baja.$("baja:Password");
    };
    builder.getConfigFor = function (i) {
      var label = "";
      switch (i) {
        case KEY_PASSWORD:
          label = PASSWORD;
          break;
        case KEY_CONFIRM:
          label = CONFIRM;
          break;
        default:
          label = "";
      }
      return {
        type: PasswordEditor,
        complex: that.getComplex(),
        slot: that.getSlot(),
        properties: {
          prelabel: label
        }
      };
    };
    return builder;
  };

  /**
   * Get the second/confirmation string editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/PasswordEditor}
   */
  ConfirmPasswordEditor.prototype.$getConfirmEditor = function () {
    // noinspection JSValidateTypes
    return this.getBuilder().getEditorFor(KEY_CONFIRM);
  };
  ConfirmPasswordEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        pwd = _ref2[0];
      return pwd;
    });
  };

  /**
   * Save the password
   *
   * @see module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @see module:nmodule/webEditors/rc/servlets/password
   * @returns {Promise}
   */
  ConfirmPasswordEditor.prototype.saveToComplex = function (pw, params) {
    return PasswordEditor.prototype.saveToComplex.call(this, pw, params);
  };

  /**
   * Destroys "password" and "confirm" editors.
   *
   * @returns {Promise}
   */
  ConfirmPasswordEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };

  /**
   * Set password/confirm editors readonly. Will not make them writable if
   * editor is not working in a secure environment.
   *
   * @see module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  ConfirmPasswordEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set password/confirm editors enabled. Will not enable them if editor is
   * not working in a secure environment.
   *
   * @see module:nmodule/webEditors/rc/fe/baja/PasswordEditor
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  ConfirmPasswordEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  return ConfirmPasswordEditor;
});
