function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/AbsTimeRangeEditor
 */
define(['lex!webEditors', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor'], function (lexs, $, Promise, ComplexCompositeEditor) {
  'use strict';

  var webEditorsLex = lexs[0];
  function startBeforeEnd(startTime, endTime) {
    if (startTime.getJsDate().getTime() >= endTime.getJsDate().getTime()) {
      throw new Error(webEditorsLex.get('AbsTimeRangeEditor.startAfterEnd'));
    }
  }

  /**
   * Editor for an `AbsTimeRange`.
   *
   * An `AbsTimeRangeEditor` supports the following `bajaux` `Properties`:
   *
   * - `validateRange`: set to `true` to add a validate step that ensures the
   *   `startTime` slot is before, or equal to, the `endTime` slot.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/AbsTimeRangeEditor
   */
  var AbsTimeRangeEditor = function AbsTimeRangeEditor(params) {
    var that = this;
    ComplexCompositeEditor.call(that, $.extend({
      keyName: 'AbsTimeRangeEditor'
    }, params));
    if (that.properties().getValue('validateRange') === true) {
      that.validators().add(function (diff) {
        var value = that.value();
        return Promise.all([diff.getValue(value, 'startTime'), diff.getValue(value, 'endTime')]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            startTime = _ref2[0],
            endTime = _ref2[1];
          return startBeforeEnd(startTime, endTime);
        });
      });
    }
  };
  AbsTimeRangeEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  AbsTimeRangeEditor.prototype.constructor = AbsTimeRangeEditor;

  /**
   * Use slots `startTime` and `endTime`.
   *
   * @returns {Array}
   */
  AbsTimeRangeEditor.prototype.getSlotFilter = function () {
    return ['startTime', 'endTime'];
  };
  return AbsTimeRangeEditor;
});
