function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/AbsTimeEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DateEditor', 'nmodule/webEditors/rc/fe/baja/TimeEditor'], function (baja, $, Promise, events, BaseEditor, DateEditor, TimeEditor) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * A field editor for working with AbsTimes.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/AbsTimeEditor
   */
  var AbsTimeEditor = function AbsTimeEditor(params) {
    BaseEditor.apply(this, arguments);
    this.$dateEditor = new DateEditor(params);
    this.$timeEditor = new TimeEditor(params);
  };
  AbsTimeEditor.prototype = Object.create(BaseEditor.prototype);
  AbsTimeEditor.prototype.constructor = AbsTimeEditor;

  /**
   * Initializes `DateEditor` and `TimeEditor` for the date and time parts of
   * the `AbsTime`. Depending on the state of the `showDate` and `showTime`
   * facets, these editors may be hidden in the DOM.
   *
   * @param {JQuery} dom
   * @returns {Promise} promise to be resolved when both date and time
   * editors have finished initializing
   */
  AbsTimeEditor.prototype.doInitialize = function (dom) {
    //TODO: time zones :(

    var that = this,
      props = that.properties(),
      showDate = props.getValue('showDate') !== false,
      showTime = props.getValue('showTime') !== false,
      dateDiv = $('<div class="date"/>').appendTo(dom),
      timeDiv = $('<div class="time"/>').appendTo(dom);
    if (!showDate) {
      dateDiv.hide();
    }
    if (!showTime) {
      timeDiv.hide();
    }
    if (!showDate && !showTime) {
      throw new Error('both showDate and showTime facets set to false');
    }
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([that.$dateEditor.initialize(dateDiv), that.$timeEditor.initialize(timeDiv)]);
  };

  /**
   * Loads the date and time parts of the `AbsTime` into the date and time
   * editors.
   *
   * @param {baja.AbsTime} value
   * @returns {Promise} promise to be resolved once the date and time
   * editors have finished loading
   */
  AbsTimeEditor.prototype.doLoad = function (value) {
    return Promise.all([this.$dateEditor.load(value.getDate()), this.$timeEditor.load(value.getTime())]);
  };

  /**
   * Reads the values from the date and time editors and uses them to construct
   * a new `AbsTime` instance.
   *
   * @returns {Promise} promise to be resolved with a `baja.AbsTime`
   * constructed from the currently entered date and time, or rejected if the
   * date/time editors cannot be read
   */
  AbsTimeEditor.prototype.doRead = function () {
    //TODO: AbsTime offset
    return Promise.all([this.$dateEditor.read(), this.$timeEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        date = _ref2[0],
        time = _ref2[1];
      return baja.AbsTime.make({
        date: date,
        time: time
      });
    });
  };

  /**
   * Enables/disables both the date and time editors.
   *
   * @param {Boolean} enabled
   */
  AbsTimeEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Readonly/writable both the date and time editors.
   *
   * @param {Boolean} readonly
   */
  AbsTimeEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroys the date and time editors.
   */
  AbsTimeEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return AbsTimeEditor;
});
