function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
 */
define(['lex!webEditors', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor'], function (lexs, spandrel, Widget, Command, Promise, _, fe, feDialogs, DisplayOnlyEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var extend = _.extend,
    isNumber = _.isNumber;
  var FOCUS_CLASS = 'ux-bg';

  ////////////////////////////////////////////////////////////////
  // ArrayCompositeEditor
  ////////////////////////////////////////////////////////////////

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ArrayCompositeEditor'
      }
    };
  };
  function arrayToConfig(array, _ref) {
    var _this = this;
    var properties = _ref.properties;
    var _properties$getConfig = properties.getConfig,
      getConfig = _properties$getConfig === void 0 ? function () {
        return {};
      } : _properties$getConfig,
      _properties$numbers = properties.numbers,
      numbers = _properties$numbers === void 0 ? {} : _properties$numbers;
    var _numbers$show = numbers.show,
      show = _numbers$show === void 0 ? true : _numbers$show,
      _numbers$countFromZer = numbers.countFromZero,
      countFromZero = _numbers$countFromZer === void 0 ? false : _numbers$countFromZer;
    var focusedIndex = this.$focusedEditorIndex;
    return {
      rows: {
        dom: '<div class="editors"></div>',
        on: [['focusin', '*/editor', function (e, ed) {
          return _this.$setFocusedEditor(ed);
        }]],
        kids: array.map(function (value, i) {
          return {
            dom: "<div class=\"editor-row ".concat(focusedIndex === i ? FOCUS_CLASS : '', "\"></div>"),
            kids: {
              number: show && "<div class=\"number\">".concat(countFromZero ? i : i + 1, ".</div>"),
              editor: extend(getConfig(value, i, properties), {
                dom: '<div></div>',
                value: value
              })
            }
          };
        })
      }
    };
  }

  /**
   * An abstract editor intended to manage the instantiation, initialization,
   * and loading of multiple sub-editors contained in an array.
   *
   * This class also contains default implementations of four commands
   * that can be used as buttons with this editor: add, remove, move up,
   * and move down.
   *
   * It accepts an object literal Property called `numbers` which contains two
   * sub properties:
   * - `show`: (Boolean) if true display the number for each editor starting
   * from 1.
   * - `countFromZero`: (Boolean) if true start the editor numbers from 0
   * instead of 1.
   *
   * It accepts an optional `getConfig` Property, which is a function to receive
   * the value and index for each member of the array, and return `fe.buildFor`
   * parameters such as `properties` and `type` used to build the editor for
   * that member.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   */
  var ArrayCompositeEditor = /*#__PURE__*/function (_spandrel) {
    function ArrayCompositeEditor() {
      var _this2;
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, ArrayCompositeEditor);
      _this2 = _callSuper(this, ArrayCompositeEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      if (_this2.getFormFactor() === Widget.formfactor.mini) {
        DisplayOnlyEditor.$mixin(_this2);
      }
      return _this2;
    }

    /**
     * Read a new value for the currently entered value.
     *
     * @returns {Promise.<Array>}
     */
    _inherits(ArrayCompositeEditor, _spandrel);
    return _createClass(ArrayCompositeEditor, [{
      key: "doRead",
      value: function doRead() {
        return Promise.all(this.$getValueEditors().map(function (w) {
          return w.read();
        }));
      }

      /**
       * Gets the currently focused editor index.
       *
       * @returns {Number|undefined}
       */
    }, {
      key: "getFocusedEditorIndex",
      value: function getFocusedEditorIndex() {
        return this.$focusedEditorIndex;
      }
    }, {
      key: "$getValueEditors",
      value: function $getValueEditors() {
        return this.queryWidgets('rows/*/editor');
      }

      /**
       * Sets the currently focused editor index.
       *
       * @private
       * @param {Number} index
       * @param {Boolean} requestFocus
       */
    }, {
      key: "$setFocusedEditorIndex",
      value: function $setFocusedEditorIndex(index, requestFocus) {
        var rows = this.queryWidgets('rows/*');
        this.$focusedEditorIndex = index;
        rows.forEach(function (row, i) {
          return row.jq().toggleClass(FOCUS_CLASS, i === index);
        });
        if (index !== undefined && requestFocus) {
          var focusedEd = rows[index].queryWidget('editor');
          focusedEd.requestFocus();
        }
      }

      /**
       * @private
       * @param {module:module:bajaux/Widget} ed the widget that received focus
       */
    }, {
      key: "$setFocusedEditor",
      value: function $setFocusedEditor(ed) {
        this.$setFocusedEditorIndex(+this.getPathToKid(ed)[1]);
      }

      /**
       * Un-focuses any current focused editor.
       * @private
       */
    }, {
      key: "$removeFocus",
      value: function $removeFocus() {
        this.$setFocusedEditorIndex(undefined);
      }

      /**
       * When in mini/display-only mode, just display the number of items.
       *
       * @returns {String}
       */
    }, {
      key: "valueToString",
      value: function valueToString(array) {
        return webEditorsLex.get('ArrayCompositeEditor.items', array.length);
      }

      ////////////////////////////////////////////////////////////////
      // Command helper functions
      ////////////////////////////////////////////////////////////////

      /**
       * Add an item to the backing array.
       *
       * @param {*} item
       * @returns {Promise}
       */
    }, {
      key: "addItem",
      value: function addItem(item) {
        return this.doLoad(this.value().concat(item));
      }

      /**
       * Remove an item from the backing array.
       *
       * @param {Number} indexToRemove
       * @returns {Promise}
       */
    }, {
      key: "removeItem",
      value: function removeItem(indexToRemove) {
        var _this3 = this;
        return this.$verifyIndexInBounds(indexToRemove).then(function (array) {
          var focusedIndex = _this3.getFocusedEditorIndex();
          if (indexToRemove === focusedIndex) {
            if (indexToRemove === _this3.$getValueEditors().length - 1) {
              _this3.$removeFocus();
            }
          } else if (focusedIndex > indexToRemove) {
            _this3.$setFocusedEditorIndex(focusedIndex - 1, true);
          }
          array.splice(indexToRemove, 1);
          return _this3.doLoad(array);
        });
      }

      /**
       * Move an item one slot up in the backing array.
       *
       * @param {Number} indexToMoveUp
       * @returns {Promise}
       */
    }, {
      key: "moveUpItem",
      value: function moveUpItem(indexToMoveUp) {
        var _this4 = this;
        return this.$verifyIndexInBounds(indexToMoveUp).then(function (array) {
          if (indexToMoveUp === 0) {
            return;
          }
          if (indexToMoveUp === _this4.getFocusedEditorIndex()) {
            _this4.$setFocusedEditorIndex(indexToMoveUp - 1, true);
          }
          return _this4.doLoad(swap(array, indexToMoveUp, indexToMoveUp - 1));
        });
      }

      /**
       * Move an item one slot down in the backing array.
       *
       * @param {Number} indexToMoveDown
       * @returns {Promise}
       */
    }, {
      key: "moveDownItem",
      value: function moveDownItem(indexToMoveDown) {
        var _this5 = this;
        return this.$verifyIndexInBounds(indexToMoveDown).then(function (array) {
          if (indexToMoveDown === array.length - 1) {
            return;
          }
          if (indexToMoveDown === _this5.getFocusedEditorIndex()) {
            _this5.$setFocusedEditorIndex(indexToMoveDown + 1, true);
          }
          return _this5.doLoad(swap(array, indexToMoveDown, indexToMoveDown + 1));
        });
      }

      /**
       * @private
       * @param {number} index
       * @returns {Promise.<Array>}
       */
    }, {
      key: "$verifyIndexInBounds",
      value: function $verifyIndexInBounds(index) {
        return this.read().then(function (array) {
          if (index < 0 || index >= array.length) {
            throw new Error('Index out of array bounds');
          }
          return array;
        });
      }
    }]);
  }(spandrel(arrayToConfig, {
    manager: fe.getWidgetManager()
  })); ////////////////////////////////////////////////////////////////
  // Commands
  ////////////////////////////////////////////////////////////////
  /**
   * Command to add a new value.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   * @param {*} [defaultValue=''] the default value to prompt the user with.
   */
  var AddCommand = /*#__PURE__*/function (_Command) {
    function AddCommand(getEd) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      _classCallCheck(this, AddCommand);
      return _callSuper(this, AddCommand, [{
        module: 'webEditors',
        lex: 'commands.addItem',
        func: function func() {
          return Promise.all([feDialogs.showFor({
            value: defaultValue
          }), getEd()]).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 2),
              item = _ref3[0],
              ed = _ref3[1];
            return item !== null && ed.addItem(item);
          });
        }
      }]);
    }
    _inherits(AddCommand, _Command);
    return _createClass(AddCommand);
  }(Command);
  ArrayCompositeEditor.AddCommand = AddCommand;

  /**
   * Command to remove the selected item.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   */
  var RemoveCommand = /*#__PURE__*/function (_Command2) {
    function RemoveCommand(getEd) {
      _classCallCheck(this, RemoveCommand);
      return _callSuper(this, RemoveCommand, [{
        module: 'webEditors',
        lex: 'commands.removeItem',
        func: function func() {
          return Promise.resolve(getEd()).then(function (ed) {
            var focusedIndex = ed.getFocusedEditorIndex();
            if (isNumber(focusedIndex)) {
              return ed.removeItem(focusedIndex);
            }
          });
        }
      }]);
    }
    _inherits(RemoveCommand, _Command2);
    return _createClass(RemoveCommand);
  }(Command);
  ArrayCompositeEditor.RemoveCommand = RemoveCommand;

  /**
   * Command to move the selected item up in the list.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   */
  var MoveUpCommand = /*#__PURE__*/function (_Command3) {
    function MoveUpCommand(getEd) {
      _classCallCheck(this, MoveUpCommand);
      return _callSuper(this, MoveUpCommand, [{
        module: 'webEditors',
        lex: 'commands.moveUp',
        func: function func() {
          return Promise.resolve(getEd()).then(function (ed) {
            var focusedIndex = ed.getFocusedEditorIndex();
            if (isNumber(focusedIndex)) {
              return ed.moveUpItem(focusedIndex);
            }
          });
        }
      }]);
    }
    _inherits(MoveUpCommand, _Command3);
    return _createClass(MoveUpCommand);
  }(Command);
  ArrayCompositeEditor.MoveUpCommand = MoveUpCommand;

  /**
   * Command to move the selected item down in the list.
   *
   * @private
   * @class
   * @extends module:bajaux/commands/Command
   * @memberOf module:nmodule/webEditors/rc/fe/array/ArrayCompositeEditor
   * @param {Function} getEd a function that returns either an
   * `ArrayCompositeEditor` or a `Promise` that resolves with an
   * `ArrayCompositeEditor`.
   */
  var MoveDownCommand = /*#__PURE__*/function (_Command4) {
    function MoveDownCommand(getEd) {
      _classCallCheck(this, MoveDownCommand);
      return _callSuper(this, MoveDownCommand, [{
        module: 'webEditors',
        lex: 'commands.moveDown',
        func: function func() {
          return Promise.resolve(getEd()).then(function (ed) {
            var focusedIndex = ed.getFocusedEditorIndex();
            if (isNumber(focusedIndex)) {
              return ed.moveDownItem(focusedIndex);
            }
          });
        }
      }]);
    }
    _inherits(MoveDownCommand, _Command4);
    return _createClass(MoveDownCommand);
  }(Command);
  ArrayCompositeEditor.MoveDownCommand = MoveDownCommand;

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function swap(arr, i, j) {
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
    return arr;
  }
  return ArrayCompositeEditor;
});
