/*
  This widget demonstrates how to use the responsive layout mixin.

  The responsive layout can be used to add and remove CSS classes to a
  widget's DOM element based upon the size of the widget.
*/

define(['bajaux/Widget',
        'bajaux/mixin/responsiveMixIn',
        'hbs!nmodule/docDeveloper/rc/bajaux/examples/ResponsiveWidgetTemplate',
        'css!nmodule/docDeveloper/rc/bajaux/examples/ResponsiveWidgetStyle'], function (
        Widget,
        responsiveMixIn,
        template) {

  'use strict';

  var ResponsiveWidget = function () {
    Widget.apply(this, arguments);

    // Applying this mix in adds responsive layout capabilities to a
    // Widget.
    responsiveMixIn(this, {
      // The 'example-medium' and 'example-small' classes are toggled on the 
      // widget depending on the widget's width.
      'example-medium': { maxWidth: 600, minWidth: 301 },
      'example-small':  { maxWidth: 300 }
    });
  };

  ResponsiveWidget.prototype = Object.create(Widget.prototype);
  ResponsiveWidget.prototype.constructor = ResponsiveWidget;

  ResponsiveWidget.prototype.doInitialize = function (jq) {
    jq.html(template());
  };

  return ResponsiveWidget;
});