/*
  This is the first example as discussed in...

  module://docDeveloper/doc/jsdoc/bajaux-ux/tutorials-gettingStarted.html
  
  Please note, this is a playground learning environment for creating widgets. 
  If you want to create a view or something that can be used in a production
  environment, you'll need to embed your widget into a niagara module. This is
  described in the getting started guide. 

  Hit the play button to try this Widget out. When playing the Widget, remember 
  to select the Ramp from /BajauxExamples/Components/Ramp.
*/

// This 'define' part of RequireJS and defines a usable module of JavaScript. 
// For more information, please see http://requirejs.org/.
define(['bajaux/Widget',
        'bajaux/mixin/subscriberMixIn'], function (
        Widget,
        subscriberMixIn) {

  'use strict';

  // This is how we define our Widget 'class'.
  var MyFirstWidget = function () {
    // This calls the super constructor.
    Widget.apply(this, arguments);

    // Applying a Subscriber MixIn adds subscription capabilities to a
    // Widget. Once added, the value passed into 'doLoad' is fully subscribed
    // and 'live'.
    subscriberMixIn(this);
  };

  MyFirstWidget.prototype = Object.create(Widget.prototype);
  MyFirstWidget.prototype.constructor = MyFirstWidget;

  MyFirstWidget.prototype.doInitialize = function (jq) {
    // Widget initialization is where the HTML for the widget gets injected
    // into the browser's DOM. The 'jq' object has a jQuery wrapper around it
    // to make manipulating the DOM easier.
    jq.html('<input type="text" value="value goes here" />');
  };

  MyFirstWidget.prototype.doLoad = function (ramp) {
    // When the ramp changes, update the widget's DOM...
    var jq = this.jq().find('input');

    function update() {
      jq.val(ramp.getOut().getValueDisplay());
    }

    // Call update whenever a Property changes
    this.getSubscriber().attach("changed", update);

    // Call update for the first time.
    update();
  };

  // Return the Widget's constructor so it can be created.
  return MyFirstWidget;
});