/*jshint browser:true*/

/*
  This widget demonstrates how to hyperlink between different pages within in bajaux. 

  Instead of using the standard 'window.location.assign' method, a 'niagara' namespace
  is available to use for hyperlinking instead.
*/
define(['bajaux/Widget',
        'hbs!nmodule/docDeveloper/rc/bajaux/examples/HyperlinkWidgetTemplate',
        'css!nmodule/docDeveloper/rc/bajaux/examples/HyperlinkWidgetStyle'], function (
        Widget,
        template) {

  'use strict';

  var HyperlinkWidget = function () {
    Widget.apply(this, arguments);
  };

  HyperlinkWidget.prototype = Object.create(Widget.prototype);
  HyperlinkWidget.prototype.constructor = HyperlinkWidget;

  function hyperlink(href) {
    // Hyperlink using the niagara environment namespace...
    window.niagara.env.hyperlink(href);
    return false;
  }

  HyperlinkWidget.prototype.doInitialize = function (jq) {
    jq.html(template());

    jq.on("click", ".example-hyperlink-widget-help", function () {
      // Hyperlink with an ORD...
      return hyperlink("module://docDeveloper/doc/jsdoc/bajaux-ux/index.html");
    });

    jq.on("click", ".example-hyperlink-widget-firstwidget", function () {
      return hyperlink("station:|slot:/BajauxExamples/MyFirstWidget");
    });

    jq.on("click", ".example-hyperlink-widget-niagaracentral", function () {
      // Or even hyperlink with a URI...
      return hyperlink("https://www.niagara-central.com");
    });
  };

  return HyperlinkWidget;
});