/*
  This code snippet is taken from from the 'gettingStarted' BajaScript tutorial.
  More information can be found by navigating to this ORD...

  module://docDeveloper/doc/jsdoc/bajaux-ux/tutorial-gettingStarted.html
*/

// Subscribe to a Ramp. When it changes, print out the results.
require(['baja!', 'dialogs'], function (baja, dialogs) {
  "use strict";

  // A Subscriber is used to listen to Component events in Niagara.
  var sub = new baja.Subscriber();

  // This shows a dialog. The function passed into 'showOk' is used to generate the dialog
  // box's content.
  dialogs.showOk(function (dlg, jq) {
    jq.text("Loading...");
    
    // The 'update' method is called whenever the text needs to be updated.
    function update(ramp) {
      jq.text(ramp.getOutDisplay());
    }
    
    // Called whenever the Ramp changes.
    sub.attach('changed', function (prop) {
      if (prop.getName() === 'out') { update(this); }
    });
          
    // Resolve the ORD to the Ramp and update the text.
    baja.Ord.make('station:|slot:/BajaScriptExamples/Components/Ramp').get({subscriber: sub})
      .then(update);
  })
  // A Promise is an amazing way to handle asynchronous events in JavaScript. For 
  // more information on the Promise library we use, please visit https://github.com/petkaantonov/bluebird.
  .promise()
  .finally(function () {
    // Called when the dialog is closed.
    
    // Unsubscribe the Component so we're no longer listening to live
    // events.
    sub.unsubscribeAll();

    // Detach all subscription handlers to ensure we don't unnecessarily 
    // create memory leaks.
    sub.detach();
  });
});
