/*
  Now let's see how we can reorder a number of dynamic Properties on a Component...
*/

require(["baja!", 
         "dialogs"], function (
         baja, 
         dialogs) {    
  "use strict";

  baja.Ord.make("station:|slot:/BajaScriptExamples/Components/Reorder")
    .get()
    .then(function (folder) {
      // Note how we're using BajaScript's powerful cursors to find the Slots 
      // we're interested in.
      var dynProps = folder.getSlots().dynamic().properties().toArray(),
          before = dynProps.join(", ");

      // Perform reorder on Server (this will make a network call)...
      folder.reorder(dynProps.reverse())
        .then(function () {
          dialogs.showOk("<div>Before reorder: " + 
            before + 
            "</div><div>After reorder: " + 
            folder.getSlots().dynamic().properties().toArray().join(", ") + 
            "</div>");
        });
    });
});
