/*
  As well as a powerful Component architecture, BajaScript also has a rich Object architecture...

  - The core JavaScript types have been augmented into BajaScript Types.
  - There are LOTS of different objects in BajaScript that match Niagara Types. Please see the JsDocs for more information!
*/

require(["baja!", 
         "baja!baja:Weekday",
         "dialogs"], function (
         baja, 
         types,
         dialogs) {
  "use strict";

  var buf = "";
  function update(str) {
    buf += str + "\n";
  }

  // How about a String!
  update("So what's the Type for a String?".getType());

  // How about a number?
  update((12.2).getType());
  update(baja.Double.make(12.3).getType());
  update(baja.Integer.make(12).getType());
  update(baja.Long.make(14).getType());
  update(baja.Float.make(12.4).getType());

  // How about a boolean?
  update(true.getType());

  // Simples that don't exist
  update("What about unsupported Simples?");
  update("BajaScript hasn't got an implementation for all Simples.");
  update("For now, any unknown Simple falls back to a baja.DefaultSimple");
  update("For example, here's a BOrdList: " + baja.$("baja:OrdList").make("slot:/"));

  // How about Facets?
  var facets = baja.Facets.make(["trueText", "falseText"], ["some true text", "some false text"]);

  // Encode to String and print out
  var encodedFacetsStr = facets.encodeToString();
  update("Some encoded Facets: " + encodedFacetsStr);

  // Decode from String and print out
  facets = baja.Facets.DEFAULT.decodeFromString(encodedFacetsStr);

  update("Let's print out the Facets...");
  var keys = facets.getKeys();
  for (var i = 0; i < keys.length; ++i) {
    update(" key: " + keys[i] + ", value: " + facets.get(keys[i]));
  }

  // Relative Time
  update("Milliseconds: " + baja.RelTime.make({
    hours: 1,
    minutes: 2,
    seconds: 20
  }));

  // Absolute time
  update("Time now: " + baja.AbsTime.now());

  // Enums
  update(baja.$("baja:Weekday").get("monday"));

  // Status
  var status = baja.Status.make(baja.Status.DOWN | baja.Status.FAULT);
  update("Status down: " + status.isDown());
  update("Status fault: " + status.isFault());

  dialogs.showOk("<pre>" + buf + "</pre>");
});
