/*
  Requests can be batched together into one network call. This
  makes for efficient network programming...
*/

require(["baja!", 
         "baja!control:NumericWritable",
         "dialogs",
         "jquery"], function (
         baja, 
         types,
         dialogs,
         $) {
  "use strict";

  // First ask the user to enter a number...
  dialogs.showOk("<div>Enter a number...</div><input type='text' value='1'></input>")
    .promise()
    .spread(function (dlg) {
      var val = dlg.content().find("input").val(),
          sub = new baja.Subscriber();

      // Validate the number.
      if (!$.isNumeric(val)) {
        dialogs.showOk("Value isn't a number. Try again!");
        return;
      }

      val = parseFloat(val);
      
      // Now invoke a whole bunch of actions on some points in batch and
      // listen for any changes.
      dialogs.showOk(function (dlg, jq) {
        // Listen for any changes.
        sub.attach("changed", function() {
          var entry = $("<div></div>");
          entry.text(this.toPathString() + " -> " + this.getOutDisplay());
          jq.append(entry); 
        });

        baja.Ord.make("station:|slot:/BajaScriptExamples/Components/Batch")
          .get()
          .then(function (folder) {
            var batch = new baja.comm.Batch();

            // For each point, invoke the 'set' Action and subscribe the point so we can
            // listen for changes.
            folder.getSlots().is("control:NumericWritable").eachValue(function (point) {
              sub.subscribe({
                comps: point,
                batch: batch // Pass the batch in. Doing this won't make the network call yet.
              });

              // The auto-generated action method name is called 'set1' instead of 'set'.
              // This is because there's already a method called 'set' used in 'baja.Complex'.
              point.set1({
                value: val, 
                batch: batch // Pass the batch in. Doing this won't make the network call yet.
              });
            }); 

            // Committing the batch will now make the network call.
            batch.commit();
          });
      })
      .promise()
      .finally(function () {
        sub.unsubscribeAll();
        sub.detach();
      });
    });

});
