/*
  A BajaScript Chat Application.
  Chat to anyone else using this App at the same time!
  Hit the run button to start listening. Enter any message
  below to and hit run to send.

  Please note, this will only work with users who are logged onto the same Station.
*/

require(["baja!",
         "dialogs"], function (
         baja,
         dialogs) {
  "use strict";
  
  var sub = new baja.Subscriber(),
      name;
  
  // Ask the user for their name.
  dialogs.showOk({
      title: "Enter Name",
      content: "<input type='text' value='John'></input>"
    })
    .promise()
    .spread(function (dlg) {
      name = dlg.content().find("input").val();
      name = name || "Unknown";

      // Resolve the chat Component.
      return baja.Ord.make("station:|slot:/BajaScriptExamples/Components/BajaScriptTestComp")
        .get({ subscriber: sub });
    })
    .then(function (comp) {
      // Show the chat window.
      return dialogs.show({
        title: "BajaScript Chat - " + name,
        content: function (dlg, jq) {
          jq.html("Say: <input type='text' size='60' value=''></input>" + 
            "<pre style='border: 1px solid grey'>Welcome to BajaScript Chat...\n</pre>");

          var input = jq.find("input"),
              chat = jq.find("pre");

          // Whenever the Topic fires, update the chat window.
          sub.attach("topicFired", function (topic, event, cx) {
            chat.text(chat.text() + "\n" + event);
          });

          // When the user hits the enter key, fire the Topic on the Station Component.
          input.keyup(function (e) {
            if (e.keyCode === 13) {
              comp.fireMessage(name + " says " + input.val());
              input.val("");
            }
          });    
        },
        buttons: [{
          name: "close",
          displayName: "Close",
          esc: true
        }]
      }).promise();
    })
    .finally(function () {
      sub.unsubscribeAll();
      sub.detach();
    });
});
