function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/SplitPane
 */
define(['baja!', 'baja!bajaui:Orientation,bajaui:NullWidget', 'bajaux/spandrel', 'nmodule/js/rc/jquery/split-pane/split-pane', 'css!nmodule/bajaui/rc/bajaui', 'css!nmodule/js/rc/jquery/split-pane/split-pane'], function (baja, types, spandrel) {
  'use strict';

  var NULL_WIDGET = baja.$("bajaui:NullWidget");
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-SplitPane',
        widget1: NULL_WIDGET,
        widget2: NULL_WIDGET,
        dividerWidth: 6,
        moveableDivider: true,
        dividerPosition: 50,
        orientation: baja.$("bajaui:Orientation", "horizontal"),
        continuousLayout: true
      }
    };
  };
  var getDividerStyle = function getDividerStyle(isHorizontal, dividerPosition, dividerWidth) {
    var dividerWidthStyle = "".concat(dividerWidth, "px"),
      dividerStyle = {};
    if (isHorizontal) {
      dividerStyle.width = dividerWidthStyle;
    } else {
      dividerStyle.height = dividerWidthStyle;
    }
    return dividerStyle;
  };
  /**
   * Gets the current position of the divider from the DOM and does a calculation
   * to translate it to the opposite orientation.
   *
   * @inner
   * @param {boolean} fromHorizontalToVertical determines which way to translate
   * @param {number} dividerWidth width of divider in pixels
   * @param {JQuery} splitPaneJq
   * @param {JQuery} splitPaneDividerJq
   * @returns {number} divider position in pixels
   */
  var translateDividerPosition = function translateDividerPosition(fromHorizontalToVertical, dividerWidth, splitPaneJq, splitPaneDividerJq) {
    var halfWidth = dividerWidth / 2;
    if (fromHorizontalToVertical) {
      var _dividerPosition = parseFloat(splitPaneDividerJq.css("left")) + halfWidth;
      return _dividerPosition / splitPaneJq.width() * splitPaneJq.height() - halfWidth;
    }
    var dividerPosition = parseFloat(splitPaneDividerJq.css("top")) + halfWidth;
    return dividerPosition / splitPaneJq.height() * splitPaneJq.width() - halfWidth;
  };

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/SplitPane
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function SplitPane(params) {
      _classCallCheck(this, SplitPane);
      return _callSuper(this, SplitPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(SplitPane, _spandrel);
    return _createClass(SplitPane, [{
      key: "doLayout",
      value: function doLayout() {
        if (!this.$isSplitPaneInstalled) {
          this.$installSplitPane();
        }
      }
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        var _this = this;
        var currentDividerPosition;
        var properties = this.properties(),
          isHorizontal = properties.getValue("orientation").getTag() === "horizontal",
          splitPaneJq = this.$getSplitPaneJq(),
          dividerWidth = properties.getValue("dividerWidth"),
          splitPaneDividerJq = splitPaneJq.find(".-t-SplitPane-divider").first();
        if (name === "orientation") {
          currentDividerPosition = translateDividerPosition(!isHorizontal, dividerWidth, splitPaneJq, splitPaneDividerJq);
        } else {
          currentDividerPosition = isHorizontal ? parseFloat(splitPaneDividerJq.css("left")) : parseFloat(splitPaneDividerJq.css("top"));
        }
        return _superPropGet(SplitPane, "doChanged", this, 3)([name, value]).then(function () {
          if (name === "dividerPosition") {
            _this.$setupSplitPaneComponents();
          } else {
            _this.$setFirstComponentSize(currentDividerPosition);
          }
        });
      }
    }, {
      key: "$setupSplitPaneComponents",
      value: function $setupSplitPaneComponents() {
        var properties = this.properties(),
          splitPaneJq = this.$getSplitPaneJq(),
          isHorizontal = properties.getValue("orientation").getTag() === "horizontal",
          size = isHorizontal ? splitPaneJq.width() : splitPaneJq.height(),
          dividerPosition = properties.getValue("dividerPosition"),
          dividerWidth = properties.getValue("dividerWidth"),
          dividerPositionPixels = size * dividerPosition / 100 - dividerWidth / 2,
          firstComponentSize = dividerPositionPixels,
          secondComponentSize = size - firstComponentSize - dividerWidth;
        if (isHorizontal) {
          splitPaneJq.children(".split-pane-component:first").css("right", size - firstComponentSize + "px");
          splitPaneJq.children(".split-pane-divider:first").css("right", secondComponentSize + "px");
          splitPaneJq.children(".split-pane-component:last").css("width", secondComponentSize + "px");
        } else {
          splitPaneJq.children(".split-pane-component:first").css("bottom", size - firstComponentSize + "px");
          splitPaneJq.children(".split-pane-divider:first").css("bottom", secondComponentSize + "px");
          splitPaneJq.children(".split-pane-component:last").css("height", secondComponentSize + "px");
        }
      }
    }, {
      key: "$setFirstComponentSize",
      value: function $setFirstComponentSize(size) {
        this.$getSplitPaneJq().splitPane('firstComponentSize', size);
      }
    }, {
      key: "$getSplitPaneJq",
      value: function $getSplitPaneJq() {
        return this.jq().children(".-t-SplitPane-inner");
      }
    }, {
      key: "$installSplitPane",
      value: function $installSplitPane() {
        this.$setupSplitPaneComponents();
        this.$getSplitPaneJq().splitPane();
        this.$isSplitPaneInstalled = true;
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var orientation = properties.orientation,
      dividerPosition = properties.dividerPosition,
      dividerWidth = properties.dividerWidth,
      moveableDivider = properties.moveableDivider,
      isHorizontal = orientation.getTag() === "horizontal",
      orientationClass = isHorizontal ? "vertical-percent" : "horizontal-percent",
      splitPaneClasses = "-t-SplitPane-inner split-pane ".concat(orientationClass),
      dividerStyle = getDividerStyle(isHorizontal, dividerPosition, dividerWidth),
      widget1 = model.get('widget1'),
      widget2 = model.get('widget2'),
      moveableDividerClass = moveableDivider ? "" : "-t-SplitPane-divider-not-moveable";
    return spandrel.jsx("div", {
      className: splitPaneClasses
    }, spandrel.jsx("div", {
      className: "split-pane-component"
    }, widget1 && widget1.toSpandrel('<div class="-t-SplitPane-kid"></div>')), spandrel.jsx("div", {
      className: "split-pane-divider -t-SplitPane-divider ".concat(moveableDividerClass),
      style: dividerStyle
    }), spandrel.jsx("div", {
      className: "split-pane-component"
    }, widget2 && widget2.toSpandrel('<div class="-t-SplitPane-kid"></div>')));
  }));
});
