function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/GridPane
 */
define(['baja!', 'baja!bajaui:Halign,bajaui:Valign,gx:Brush', 'bajaux/spandrel', 'underscore', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, spandrel, _) {
  'use strict';

  var range = _.range;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-GridPane',
        columnCount: 2,
        valign: baja.$('bajaui:Valign', 'center'),
        halign: baja.$('bajaui:Halign', 'center'),
        rowAlign: baja.$('bajaui:Valign', 'center'),
        columnAlign: baja.$('bajaui:Halign', 'left'),
        rowGap: 3,
        columnGap: 3,
        uniformRowHeight: false,
        uniformColumnWidth: false,
        stretchRow: -1,
        stretchColumn: -1,
        colorRows: false,
        bandBrush: baja.$('gx:Brush', 'null')
      }
    };
  };

  /**
   * bajaux implementation of `bajaui:GridPane`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/GridPane
   * @extends {module:bajaux/Widget}
   */
  return /*#__PURE__*/function (_spandrel) {
    function GridPane(params) {
      _classCallCheck(this, GridPane);
      return _callSuper(this, GridPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(GridPane, _spandrel);
    return _createClass(GridPane);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var halign = properties.halign,
      stretchRow = properties.stretchRow,
      valign = properties.valign;
    var style = rootElement.style;
    style.alignItems = stretchRow >= 0 ? 'stretch' : toGridAlign(valign);
    style.justifyContent = toGridAlign(halign);
    var visibleKidCount = getVisibleKidCount(model);
    return spandrel.jsx("div", {
      spandrelKey: "grid",
      className: "-t-GridPane-inner ux-preferred-size-support",
      style: createGridStyle(properties, visibleKidCount)
    }, model.getKids().map(function (kid) {
      return createCell(kid, properties);
    }));
  }));

  /**
   * @param {module:nmodule/bajaui/rc/model/UxModel} model
   * @return {Number}
   */
  function getVisibleKidCount(model) {
    return _.filter(model.getKids(), function (kid) {
      var _kid$getProperties = kid.getProperties(),
        visible = _kid$getProperties.visible;
      return visible !== false;
    }).length;
  }

  /**
   * @param {object} properties
   * @param {Number} visibleKidCount
   * @returns {object} style object for grid wrapper
   */
  function createGridStyle(properties, visibleKidCount) {
    var columnCount = properties.columnCount;
    var columnGap = properties.columnGap,
      rowGap = properties.rowGap,
      stretchColumn = properties.stretchColumn,
      stretchRow = properties.stretchRow,
      uniformColumnWidth = properties.uniformColumnWidth,
      uniformRowHeight = properties.uniformRowHeight;
    if (visibleKidCount < columnCount) {
      columnCount = visibleKidCount;
    }
    var style = {
      display: 'grid',
      gridColumnGap: columnGap + 'px',
      columnGap: columnGap + 'px',
      gridRowGap: rowGap + 'px',
      rowGap: rowGap + 'px',
      gridAutoRows: uniformRowHeight && '1fr'
    };
    if (stretchColumn >= 0 && stretchColumn < columnCount) {
      style.flex = '0 0 100%';
      style.gridTemplateColumns = repeat(0, stretchColumn, 'auto').concat('1fr').concat(repeat(stretchColumn + 1, Math.trunc(columnCount), 'auto')).join(' ');
    } else {
      style.gridTemplateColumns = "repeat(".concat(Math.trunc(columnCount), ", ").concat(uniformColumnWidth ? '1fr' : 'auto', ")");
    }
    if (stretchRow >= 0) {
      var _repeat = stretchRow > 0 ? "repeat(".concat(stretchRow, ", auto) ") : '';
      style.gridTemplateRows = "".concat(_repeat, "1fr");
    }
    return style;
  }

  /**
   * @param {module:nmodule/bajaui/rc/model/UxModel} kid
   * @param {object} gridPaneProperties
   * @returns {object} spandrel config for one cell in the grid
   */
  function createCell(kid, gridPaneProperties) {
    var columnAlign = gridPaneProperties.columnAlign,
      rowAlign = gridPaneProperties.rowAlign;
    var _kid$getProperties2 = kid.getProperties(),
      visible = _kid$getProperties2.visible;

    //place the actual widget in a child element of the grid cell. this is
    //because place-self does not work in Edge so rowAlign/columnAlign aren't
    //respected otherwise.
    return spandrel.jsx("div", {
      className: "-t-GridPane-cell",
      style: {
        width: !visible && '0',
        height: !visible && '0',
        alignItems: toFlexAlign(rowAlign),
        justifyContent: toFlexAlign(columnAlign)
      }
    }, spandrel.jsx("div", {
      className: "-t-GridPane-cell-content ux-use-preferred-size ux-use-preferred-min-size ux-use-preferred-max-size"
    }, spandrel.jsx("div", {
      spandrelSrc: kid,
      style: {
        flexBasis: columnAlign.getTag() === 'fill' && '100%'
      }
    })));
  }

  /**
   * @param {number} start
   * @param {number} end
   * @param {string} value
   * @returns {string[]}
   */
  function repeat(start, end, value) {
    if (start < end) {
      return range(start, end).map(function () {
        return value;
      });
    }
    return [];
  }

  /**
   * @param {baja.FrozenEnum} en
   * @returns {string} value for alignItems/justifyContent for the outer grid
   */
  function toGridAlign(en) {
    if (en.getTag() === 'fill') {
      return 'flex-start';
    }
    return toFlexAlign(en);
  }

  /**
   * @param {baja.FrozenEnum} en
   * @returns {string} value for alignItems/justifyContent
   */
  function toFlexAlign(en) {
    switch (en.getTag()) {
      case 'top':
      case 'left':
        return 'flex-start';
      case 'center':
        return 'center';
      case 'bottom':
      case 'right':
        return 'flex-end';
      case 'fill':
        return 'stretch';
    }
  }
});
