function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/CanvasPane
 */
define(['baja!', 'baja!bajaui:Halign,bajaui:ScaleMode,bajaui:Valign,gx:Size', 'bajaux/events', 'bajaux/spandrel', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/bajaui/rc/mixin/LayoutHintsSupport', 'nmodule/bajaui/rc/util/ScaledLayout'], function (baja, types, events, spandrel, Layout, LayoutHintsSupport, ScaledLayout) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-CanvasPane',
        viewSize: baja.$('gx:Size', 100, 100),
        scale: baja.$('bajaui:ScaleMode', 'none'),
        minScaleFactor: 0,
        maxScaleFactor: 0,
        halign: baja.$('bajaui:Halign', 'center'),
        valign: baja.$('bajaui:Valign', 'center'),
        background: baja.$('gx:Brush', 'null')
      }
    };
  };
  var PROPERTY_CHANGED = events.PROPERTY_CHANGED;

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/CanvasPane
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function CanvasPane(params) {
      var _this;
      _classCallCheck(this, CanvasPane);
      _this = _callSuper(this, CanvasPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      LayoutHintsSupport(_this);
      return _this;
    }
    _inherits(CanvasPane, _spandrel);
    return _createClass(CanvasPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.on(PROPERTY_CHANGED, function (e, ed, propName) {
          if (propName === 'layout') {
            applyLayoutToWidget(ed);
          }
        });
        return _superPropGet(CanvasPane, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var jq = this.jq();
        var wrapper = jq.children('.-t-CanvasPane-viewPane-wrapper');
        var viewPane = wrapper.children('.-t-CanvasPane-viewPane');
        var _this$properties$toVa = this.properties().toValueMap(),
          viewSize = _this$properties$toVa.viewSize,
          halign = _this$properties$toVa.halign,
          valign = _this$properties$toVa.valign,
          scale = _this$properties$toVa.scale,
          minScaleFactor = _this$properties$toVa.minScaleFactor,
          maxScaleFactor = _this$properties$toVa.maxScaleFactor;
        var halignTag = halign.getTag();
        var innerWidth = viewSize.getWidth() || 1;
        var innerHeight = viewSize.getHeight() || 1;
        var scaledLayout = ScaledLayout.scale(wrapper, jq, {
          innerWidth: innerWidth,
          innerHeight: innerHeight,
          halign: halignTag,
          valign: valign.getTag(),
          scale: scale.getTag(),
          minScaleFactor: minScaleFactor,
          maxScaleFactor: maxScaleFactor
        });
        wrapper.css({
          width: scaledLayout.getScaledWidth() + 'px',
          height: scaledLayout.getScaledHeight() + 'px'
        });
        var transformCss = scaledLayout.getTransformCss();
        viewPane.css({
          transform: transformCss.transform,
          // CanvasPane is flex-flow: column, so transform-origin Y should always be 50%
          transformOrigin: toOriginPercent(halignTag) + ' 50%'
        });
      }
    }, {
      key: "applyLayoutHints",
      value: function applyLayoutHints() {
        return false;
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var viewSize = properties.viewSize,
      background = properties.background,
      halign = properties.halign,
      valign = properties.valign;
    var style = rootElement.style;
    var justifyContent = toFlexAlign(halign.getTag());
    style.alignItems = toFlexAlign(valign.getTag());
    style.justifyContent = justifyContent;
    background.applyBackgroundToElement(rootElement);
    var width = viewSize.getWidth() + 'px';
    var height = viewSize.getHeight() + 'px';
    return spandrel.jsx("div", {
      spandrelKey: "wrapper",
      className: "-t-CanvasPane-viewPane-wrapper",
      style: {
        width: width,
        height: height,
        justifyContent: justifyContent
      }
    }, spandrel.jsx("div", {
      spandrelKey: "viewPane",
      className: "-t-CanvasPane-viewPane",
      style: {
        width: width,
        height: height
      }
    }, model.getKids().map(function (kid) {
      var _kid$getProperties = kid.getProperties(),
        layout = _kid$getProperties.layout;
      var kidStyle = layout.toCss();
      // NCCB-60629 Added the 'ux-scaled-layout-support' class to this div
      return spandrel.jsx("div", {
        className: "-t-CanvasPane-child bajaux-widget-container ux-preferred-size-ignore ux-scaled-layout-support",
        style: kidStyle,
        spandrelSrc: kid
      });
    })));
  }));
  function applyLayoutToWidget(widget) {
    var layout = widget.properties().getValue('layout');
    widget.jq().css(layout.toCss());
  }
  function toFlexAlign(tag) {
    switch (tag) {
      case 'top':
      case 'left':
        return 'flex-start';
      case 'center':
        return 'center';
      case 'bottom':
      case 'right':
      case 'fill':
        return 'flex-end';
    }
  }
  function toOriginPercent(tag) {
    switch (tag) {
      case 'left':
        return '0';
      case 'center':
      case 'fill':
        return '50%';
      case 'right':
        return '100%';
    }
  }
});
