function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Button
 */
define(['baja!', 'baja!bajaui:ButtonStyle', 'log!nmodule.bajaui.rc.ux.Button', 'bajaux/spandrel', 'underscore', 'nmodule/bajaui/rc/ux/bajauiEvents', 'nmodule/bajaui/rc/ux/Label'], function (baja, types, log, spandrel, _, bajauiEvents, Label) {
  'use strict';

  var omit = _.omit,
    SPACE_BAR = 32,
    logSevere = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Button',
        buttonStyle: baja.$('bajaui:ButtonStyle', 'normal'),
        focusTraversable: true
      }
    };
  };

  /**
   * Button represents the javascript implementation of `bajaui:Button`. When the button is activated
   * by a user, an `ACTION_PERFORMED_EVENT` event will be emitted from this widget.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Button
   * @extends module:nmodule/bajaui/rc/ux/Label
   */
  return /*#__PURE__*/function (_spandrel) {
    function Button(params) {
      _classCallCheck(this, Button);
      return _callSuper(this, Button, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @returns {module:bajaux/Widget}
     */
    _inherits(Button, _spandrel);
    return _createClass(Button, [{
      key: "$getLabel",
      value: function $getLabel() {
        return this.queryWidget('0/0/label');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getButtonElement",
      value: function $getButtonElement() {
        return this.jq().find('button');
      }

      /**
       * Applies the background to the <button/> element of the Button widget.
       * @private
       */
    }, {
      key: "$applyBackground",
      value: function $applyBackground() {
        var button = this.$getButtonElement();
        var props = this.properties();
        var buttonTag = props.getValue('buttonStyle').getTag();
        if (button.length > 0 && buttonTag !== 'hyperlink' && buttonTag !== 'none') {
          var buttonEl = button[0];
          var background = props.getValue('background');
          background.applyBackgroundToElement(buttonEl);
        }
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyBackground();
        var label = this.$getLabel();
        return label && label.layout();
      }

      /**
       * This method will be called when the user activates the button.
       * If overriding this method, make sure to call super to ensure the `ACTION_PERFORMED_EVENT` is emitted.
       * @returns {Promise}
       * @param {JQuery.Event} [e]
       */
    }, {
      key: "doInvokeAction",
      value: function doInvokeAction(e) {
        this.emit(bajauiEvents.ACTION_PERFORMED_EVENT, e && e.type);
        return Promise.resolve();
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.on('click keyup', function (event) {
          //note that `click` is also the event callback for the enter button so that is handled here too

          var enabled = _this.isEnabled();
          if (!enabled || event.type === "keyup" && event.keyCode !== SPACE_BAR) {
            return;
          }
          dom.find(_this.$getFocusType()).focus();
          _this.doInvokeAction(event)["catch"](logSevere);
        });
        return _superPropGet(Button, "doInitialize", this, 3)(arguments);
      }

      /**
       * @private
       * @returns {String}
       */
    }, {
      key: "$getFocusType",
      value: function $getFocusType() {
        return 'button';
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;
        //TODO: NCCB-45981 - Possibly remove this workaround after we fix this problem for all inputs in spandrel?
        var jq = this.jq();
        var focus = jq.find(this.$getFocusType()).is(":focus");
        return _superPropGet(Button, "render", this, 3)(arguments).then(function (result) {
          if (focus) {
            jq.find(_this2.$getFocusType()).focus();
          }
          return result;
        });
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var _properties = properties,
      buttonStyle = _properties.buttonStyle,
      enabled = _properties.enabled,
      focusTraversable = _properties.focusTraversable;
    var buttonTag = buttonStyle.getTag();
    var outline = document.createElement('span');
    outline.classList.add('ux-Button-outline');
    outline.classList.add('ux-Button-buttonStyle-' + buttonTag);
    var button = document.createElement('button');
    button.type = 'button';
    if (!focusTraversable) {
      button.tabIndex = -1;
    }
    if (!enabled) {
      button.disabled = true;
    }
    properties = omit(properties, 'background');
    return [{
      dom: outline,
      kids: [{
        dom: button,
        kids: {
          label: {
            dom: '<span/>',
            type: Label,
            properties: properties,
            value: model
          }
        }
      }]
    }];
  }, {
    "extends": Label
  }));
});
