function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/BorderPane
 */
define(['bajaux/spandrel', 'nmodule/bajaui/rc/baja/Border', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/baja/Insets'], function (spandrel, Border, Brush, Insets) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-BorderPane',
        margin: Insets.make(0),
        padding: Insets.make(10),
        border: Border.make('0 none black'),
        fill: Brush.NULL
      }
    };
  };

  /**
   * bajaux implementation of BorderPane.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/BorderPane
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function BorderPane(params) {
      _classCallCheck(this, BorderPane);
      return _callSuper(this, BorderPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(BorderPane, _spandrel);
    return _createClass(BorderPane, [{
      key: "doLayout",
      value: function doLayout() {
        var margin = this.properties().getValue('margin'),
          labelElement = this.$getLabelElement(),
          innerElement = this.$getInnerElement(),
          fill = this.properties().getValue('fill');
        if (innerElement.length > 0 && fill) {
          fill.applyBackgroundToElement(innerElement[0]);
        }
        var labelMidpoint = (labelElement.outerHeight() || 0) / 2;
        innerElement.css('marginTop', margin.getTop() - labelMidpoint + 'px');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLabelElement",
      value: function $getLabelElement() {
        return this.jq().children('.-t-BorderPane-label');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getInnerElement",
      value: function $getInnerElement() {
        return this.jq().children('.-t-BorderPane-inner');
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var margin = properties.margin,
      padding = properties.padding,
      border = properties.border,
      fill = properties.fill;
    var labelDiv = document.createElement('div');
    labelDiv.classList.add('-t-BorderPane-label');
    labelDiv.style.top = margin.getTop() + 'px';
    labelDiv.style.left = margin.getLeft() + 5 + 'px';
    var containerDiv = document.createElement('div');
    containerDiv.classList.add('-t-BorderPane-inner');
    margin.applyMarginToElement(containerDiv);
    padding.applyPaddingToElement(containerDiv);
    border.applyToElement(containerDiv);
    fill.applyBackgroundToElement(containerDiv);
    var contentDiv = document.createElement('div');
    contentDiv.classList.add('-t-BorderPane-content');
    var label = model.get('label');
    var content = model.get('content');
    return [{
      dom: containerDiv,
      kids: [content ? content.toSpandrel(contentDiv) : contentDiv]
    }, label ? label.toSpandrel(labelDiv) : labelDiv];
  }));
});
