/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/mixin/SpecialPropertySupport
 */
define(['jquery', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function ($, mixinUtils) {
  'use strict';

  var MIXIN_NAME = 'specialPropertySupport';
  var applyMixin = mixinUtils.applyMixin;
  var SpecialPropertySupport = function SpecialPropertySupport() {};
  function applySpecialPropertySupport(target) {
    if (!applyMixin(target, MIXIN_NAME, SpecialPropertySupport.prototype)) {
      return;
    }
    var initialize = target.initialize;
    var doChanged = target.doChanged;
    target.initialize = function (dom) {
      if (this.properties().getValue("visible") === false) {
        dom.toggleClass("bajaux-invisible", true);
      }
      if (this.properties().getValue("enabled") === false) {
        this.setEnabled(false);
      }
      return initialize.apply(this, arguments);
    };
    target.doChanged = function (name, value) {
      if (name === "visible") {
        this.jq().toggleClass("bajaux-invisible", value === false);
      }
      return doChanged.apply(this, arguments);
    };
  }
  return applySpecialPropertySupport;
});
