function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/binding/impl/widgetEvents
 */
define(['log!nmodule.bajaui.rc.binding.impl.widgetEvents', 'bajaux/Widget', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/bajaui/rc/ux/bajauiEvents'], function (log, Widget, $, Promise, _, htmlUtils, bajauiEvents) {
  'use strict';

  var contextMenuOnLongPress = htmlUtils.contextMenuOnLongPress;
  var logWarning = log.warning.bind(log);
  var WIDGET_EVENTS = ['initialized', 'loaded', 'destroyed'].concat(_toConsumableArray(Object.values(bajauiEvents)));
  var MOUSE_DOWN_EVENT = 'mousedown touchstart';
  var MOUSE_UP_EVENT = 'mouseup touchend touchcancel';
  var LONG_PRESS_EVENT_KEY = 'contextmenu_longpress';
  var EVENT_OBJECTS = Symbol('widgetEvents');
  var REGISTERED_EVENTS = Symbol('registeredEvents');

  /**
   * This is an API for handling user events from widgets that are the target of
   * bindings. Individual `Binding`s will use this API to define how they
   * respond to widget events, similar to how the Java versions may override
   * `firedOnWidget` or `invokedOnWidget`.
   *
   * The motivation behind creating a specific API for this, rather than just
   * relying on vanilla DOM events, is that breaking the event handler chain is
   * an important part of how the Java bindings work and we must retain that
   * behavior in the browser. But vanilla DOM events always fire synchronously,
   * and some asynchronous work such as network calls may be required before a
   * binding can determine whether it can handle the widget event or whether it
   * should let it propagate to other bindings.
   *
   * To break the event handler chain, `return false` (synchronously or
   * asynchronously) from the event handler to stop handlers later in the chain
   * from firing.
   *
   * @param {module:bajaux/Widget} widget
   * @param {object} events
   * @alias module:nmodule/bajaui/rc/binding/impl/widgetEvents
   *
   * @example
   * <caption>Provide listeners to resolve asynchronously when widget events
   * are fired.</caption>
   * widgetEvents(widget, {
   *   click: () => {
   *     return this.fetchDataAsync()
   *       .then((data) => {
   *         if (isValid(data)) {
   *           showPopup(data);
   *           return false; //stop other click handlers from executing
   *         }
   *       });
   *   }
   * });
   * @returns {Object} an object literal with a `disarm` closure to remove all
   * events added to the provided widget via widgetEvents.
   */
  function widgetEvents(widget, events) {
    if (!(widget instanceof Widget)) {
      throw new Error('Widget required');
    }
    var eventObject = events;
    function arm() {
      var eventObjects = getEventObjects(widget);
      var registeredEvents = getRegisteredEvents(widget);
      var armMouseup = _.once(function () {
        return handleMouseup(widget, registeredEvents);
      });
      for (var _i = 0, _Object$keys = Object.keys(events); _i < _Object$keys.length; _i++) {
        var eventName = _Object$keys[_i];
        if (!isEventRegisteredOnWidget(registeredEvents, eventName)) {
          if (WIDGET_EVENTS.indexOf(eventName) >= 0) {
            registerTinyEvent(widget, registeredEvents, eventName);
          } else {
            //the `isMacOs` check here ensures only one contextMenu callback is called on Android that already supports oncontextmenu
            if (eventName === 'contextmenu' && widgetEvents.$isMacOs()) {
              registeredEvents[LONG_PRESS_EVENT_KEY] = contextMenuOnLongPress(widget.jq()).release;
            }
            switch (eventName) {
              case 'mouseup':
              case 'mousedown':
                armMouseup();
                break;
              default:
                registerJQueryEvent(widget, registeredEvents, eventName);
            }
          }
        }
      }
      eventObjects.push(eventObject);
      var initialized = eventObject.initialized;
      if (initialized && widget.isInitialized()) {
        initialized();
      }
    }
    function disarm() {
      var registeredEvents = getRegisteredEvents(widget);
      // Remove this event object.
      var eventObjects = getEventObjects(widget).filter(function (obj) {
        return obj !== eventObject;
      });
      widget[EVENT_OBJECTS] = eventObjects;

      // Turn off event listeners on the widget if no longer needed.
      for (var _i2 = 0, _Object$keys2 = Object.keys(events); _i2 < _Object$keys2.length; _i2++) {
        var eventName = _Object$keys2[_i2];
        if (!isInEventObjects(eventObjects, eventName)) {
          if (WIDGET_EVENTS.indexOf(eventName) >= 0) {
            deregisterTinyEvent(widget, registeredEvents, eventName);
          } else {
            if (eventName === 'contextmenu' && widgetEvents.$isMacOs()) {
              var handler = registeredEvents[LONG_PRESS_EVENT_KEY];
              if (handler) {
                handler();
              }
            }
            switch (eventName) {
              case 'mouseup':
              case 'mousedown':
                deregisterJQueryEvent(widget, registeredEvents, MOUSE_UP_EVENT);
                deregisterJQueryEvent(widget, registeredEvents, MOUSE_DOWN_EVENT);
                break;
              default:
                deregisterJQueryEvent(widget, registeredEvents, eventName);
            }
          }
        }
      }
    }
    if (widget.isInitialized()) {
      arm();
    } else {
      widget.on('initialized', arm);
    }
    return {
      disarm: disarm
    };
  }

  /**
   * Manually trigger event handlers.
   * @private
   * @param {module:bajaux/Widget} widget
   * @param {string} name the event name to trigger
   * @param {...*} args remaining arguments; if triggering a DOM event the
   * first of these must be the event itself
   * @returns {Promise}
   */
  widgetEvents.trigger = function trigger(widget, name) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }
    if (!widget.isInitialized() && name !== 'destroyed') {
      return Promise.reject(new Error('not initialized'));
    }
    if (isInDisabledWidget(widget)) {
      return Promise.resolve();
    }
    if (name === 'destroyed') {
      //must trigger these synchronously so the widget dom can still be accessed
      return Promise.all(getEventObjects(widget).map(function (eventObject) {
        var handler = eventObject[name];
        return handler && handler.apply(void 0, args);
      }));
    }
    return getEventObjects(widget).reduce(function (promise, eventObject) {
      var handler = eventObject[name];
      return promise.then(function (result) {
        return result !== false && handler && handler.apply(void 0, args);
      });
    }, Promise.resolve());
  };

  /**
   * @param {module:bajaux/Widget} widget
   * @returns {object[]}
   */
  function getEventObjects(widget) {
    return widget[EVENT_OBJECTS] || (widget[EVENT_OBJECTS] = []);
  }

  /**
   * Determines if provided eventName is on one of the events in the provided
   * eventObjects.
   *
   * @param {object[]} eventObjects
   * @param {string} eventName
   * @returns {boolean} true if there, false if not
   */
  function isInEventObjects(eventObjects, eventName) {
    for (var i = 0; i < eventObjects.length; i++) {
      if (eventObjects[i][eventName]) {
        return true;
      }
    }
    return false;
  }

  /**
   * Gets the registered events for the widget.
   *
   * These are the events and handlers that were registered on the widget via
   * either JQuery or tinyevents.
   *
   * @param {module:bajaux/Widget} widget
   * @returns {Object}
   */
  function getRegisteredEvents(widget) {
    return widget[REGISTERED_EVENTS] || (widget[REGISTERED_EVENTS] = {});
  }

  /**
   * To match bajaui behavior, a `mouseup` event should be handled even if the
   * mouseup occurred on some other element.
   * @param {module:bajaux/Widget} widget
   * @param {Object} registeredEvents
   */
  function handleMouseup(widget, registeredEvents) {
    var handlingMousedown;
    var mouseDownHandler = function mouseDownHandler(e) {
      handlingMousedown = true;
      handleJQueryEvent(widget, 'mousedown', e);
      $(document).one(MOUSE_UP_EVENT, function (e) {
        handlingMousedown = false;
        handleJQueryEvent(widget, 'mouseup', e);
        e.stopPropagation();
      });
      e.stopPropagation(); //return false prevents button depressing on touch, but we still want to stop propagation
    };
    widget.jq().on(MOUSE_DOWN_EVENT, mouseDownHandler);
    registeredEvents[MOUSE_DOWN_EVENT] = mouseDownHandler;
    var mouseUpHandler = function mouseUpHandler(e) {
      if (!handlingMousedown) {
        handleJQueryEvent(widget, 'mouseup', e);
        e.stopPropagation();
      }
    };
    widget.jq().on(MOUSE_UP_EVENT, mouseUpHandler);
    registeredEvents[MOUSE_UP_EVENT] = mouseUpHandler;
  }
  function handleJQueryEvent(widget, eventName, event) {
    widgetEvents.trigger(widget, eventName, event.originalEvent || event)["catch"](logWarning);
  }
  function registerTinyEvent(widget, registeredEvents, eventName) {
    var handler = function handler() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      widgetEvents.trigger.apply(widgetEvents, [widget, eventName].concat(args))["catch"](logWarning);
    };
    widget.on(eventName, handler);
    registeredEvents[eventName] = handler;
    return handler;
  }
  function deregisterTinyEvent(widget, registeredEvents, eventName) {
    var handler = registeredEvents[eventName];
    if (handler) {
      widget.removeListener(eventName, handler);
      delete registeredEvents[eventName];
    }
  }

  /**
   * @inner
   * @param {module:bajaux/Widget} widget
   * @param {Object} registeredEvents
   * @param {string} eventNames the event names used to register the handler with
   * JQuery
   */
  function registerJQueryEvent(widget, registeredEvents, eventNames) {
    var handler = function handler(e) {
      handleJQueryEvent(widget, eventNames, e);
      e.stopPropagation();
    };
    widget.jq().on(eventNames, handler);
    registeredEvents[eventNames] = handler;
    return handler;
  }

  /**
   * @inner
   * @param {module:bajaux/Widget} widget
   * @param {Object} registeredEvents
   * @param {string} eventName
   */
  function deregisterJQueryEvent(widget, registeredEvents, eventName) {
    var handler = registeredEvents[eventName];
    if (handler) {
      widget.jq().off(eventName, handler);
      delete registeredEvents[eventName];
    }
  }

  /**
   * @param {string[]} registeredEvents
   * @param {string} eventName
   * @returns {boolean}
   */
  function isEventRegisteredOnWidget(registeredEvents, eventName) {
    if (eventName !== "mouseup" && eventName !== "mousedown") {
      return !!registeredEvents[eventName];
    }
    if (eventName === "mouseup" && registeredEvents[MOUSE_UP_EVENT]) {
      return true;
    }
    if (eventName === "mousedown" && registeredEvents[MOUSE_DOWN_EVENT]) {
      return true;
    }
    return false;
  }
  function isInDisabledWidget(widget) {
    return !widget.isEnabled() || widget.jq().closest('.' + Widget.css.disabled).length;
  }

  /**
   * Return true if this is either `iOS` or `macOS` (Desktop Mode on `iOS` disguises itself as `macOS`.
   * @private
   * @return {boolean}
   */

  widgetEvents.$isMacOs = function () {
    return navigator.userAgent.toLowerCase().indexOf('mac os x') > -1;
  };
  return widgetEvents;
});
