function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/binding/impl/WidgetBindingManager
 */
define(['baja!', 'log!nmodule.bajaui.rc.binding.impl.WidgetBindingManager', 'bajaux/Widget', 'niagaraSystemProperties', 'Promise', 'underscore', 'nmodule/bajaui/rc/model/BindingList', 'nmodule/bajaui/rc/binding/impl/WidgetBinding', 'nmodule/bajaui/rc/ux/NullWidget'], function (baja, log, Widget, niagaraSystemProperties, Promise, _, BindingList, WidgetBinding, NullWidget) {
  'use strict';

  var once = _.once,
    without = _.without;
  var SUBSCRIBER_SYMBOL = Symbol('subscriber');
  var REBIND_HANDLER_SYMBOL = Symbol('rebindHandler');
  var REFRESH_HANDLER_SYMBOL = Symbol('refreshHandler');
  var ORIGINAL_ORD_SYMBOL = Symbol('originalOrd');
  var logWarning = log.warning.bind(log);
  var logFine = log.fine.bind(log);

  /**
   * The public API for binding Niagara `Binding`s to bajaux `Widget`s.
   *
   * Since the type extension for `Binding` is an `IValueProvider`, it will be
   * used here to propagate Niagara data from `OrdTarget`s to the `Widget`
   * Properties. If the `Binding` also supports listening for DOM events from
   * the `Widget`, that will also be applied.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/binding/impl/WidgetBindingManager
   * @implements module:nmodule/bajaui/rc/binding/IBinder
   */
  return /*#__PURE__*/function () {
    function WidgetBindingManager() {
      _classCallCheck(this, WidgetBindingManager);
      var substitutionEnabled = WidgetBindingManager.$isOrdSubstitutionEnabled();
      this.$baseOrd = baja.Ord.DEFAULT;
      this.$bindingLists = [];
      var coalescer = this.$coalescer = new baja.OrdCoalescer({
        delay: 10,
        provideSubstitutes: substitutionEnabled
      });
      var $flush = coalescer.$flush;
      coalescer.$flush = function () {
        var totalOrds = Object.keys(coalescer.$pendingSubscribe).length + Object.keys(coalescer.$pendingNoSubscribe).length;
        return log.timing(function () {
          return $flush.call(coalescer);
        }, 'FINE', 'Batch resolved {} binding ORDs in {}ms', totalOrds);
      };
    }

    /**
     * @private
     * @returns {boolean}
     */
    return _createClass(WidgetBindingManager, [{
      key: "setBaseOrd",
      value:
      /**
       * @param {string|baja.Ord} baseOrd the ORD base to resolve binding ORDs
       * against
       */
      function setBaseOrd(baseOrd) {
        this.$baseOrd = baja.Ord.make(baseOrd);
      }

      /**
       * @param {module:nmodule/bajaui/rc/model/BindingList} bindingList
       * @param {module:bajaux/Widget} widget
       * @returns {Promise.<module:nmodule/bajaui/rc/binding/impl/WidgetBinding>}
       */
    }, {
      key: "bind",
      value: function bind(bindingList, widget) {
        var _this = this;
        if (!(bindingList instanceof BindingList)) {
          return reject('BindingList required');
        }
        if (!(widget instanceof Widget)) {
          return reject('Widget required');
        }
        var baseOrd = this.$baseOrd;
        var bindings = bindingList.getBindings();
        bindings.forEach(function (binding) {
          relativizeBindingOrd(binding, baseOrd);
          binding.setWidget(widget);
        });
        this.$bindingLists.push(bindingList);
        return this.$resolve(bindings, {
          subscribe: true
        }).then(function (_ref) {
          var subscriber = _ref.subscriber;
          return WidgetBinding.initialize(bindingList, widget).then(function (widgetBinding) {
            widget.on('loaded', once(function () {
              Promise["try"](function () {
                return runCallbacks(bindings);
              })["catch"](logWarning);
            }));
            var rebindHandler = function rebindHandler(slot) {
              return _this.$rebind(widgetBinding)["catch"](logWarning);
            };
            var refreshHandler = function refreshHandler() {
              return _this.$updateBinding(widgetBinding)["catch"](logWarning);
            };
            bindings.forEach(function (binding) {
              binding.attach('rebind', rebindHandler);
              binding.attach('refresh', refreshHandler);
            });
            widgetBinding[REBIND_HANDLER_SYMBOL] = rebindHandler;
            widgetBinding[REFRESH_HANDLER_SYMBOL] = refreshHandler;
            widgetBinding[SUBSCRIBER_SYMBOL] = subscriber;
            subscriber.attach('changed', function (prop) {
              _this.$updateBinding(widgetBinding)["catch"](logWarning);
            });
            return widgetBinding;
          });
        });
      }

      /**
       * @param {module:nmodule/bajaui/rc/binding/impl/WidgetBinding} widgetBinding
       * @returns {Promise}
       */
    }, {
      key: "unbind",
      value: function unbind(widgetBinding) {
        var bindingList = widgetBinding.getBindingList();
        var rebindHandler = widgetBinding[REBIND_HANDLER_SYMBOL];
        var refreshHandler = widgetBinding[REFRESH_HANDLER_SYMBOL];
        if (rebindHandler) {
          bindingList.getBindings().forEach(function (binding) {
            return binding.detach('rebind', rebindHandler);
          });
        }
        if (refreshHandler) {
          bindingList.getBindings().forEach(function (binding) {
            return binding.detach('refresh', refreshHandler);
          });
        }
        this.$bindingLists = without(this.$bindingLists, widgetBinding.getBindingList());
        var subscriber = widgetBinding[SUBSCRIBER_SYMBOL];
        return Promise.resolve(subscriber && subscriber.unsubscribeAll());
      }

      /**
       * Unbinds and then rebinds the given binding. Call this when the binding's
       * ORD has changed, so it must be re-resolved to a new target from the
       * station.
       *
       * @private
       * @param {module:nmodule/bajaui/rc/binding/impl/WidgetBinding} widgetBinding
       * @returns {Promise}
       */
    }, {
      key: "$rebind",
      value: function $rebind(widgetBinding) {
        var _this2 = this;
        var bindingList = widgetBinding.getBindingList();
        var widget = widgetBinding.getWidget();
        bindingList.getBindings().forEach(function (binding) {
          return binding.removeListeners(widget);
        });
        return this.unbind(widgetBinding)["catch"](logFine).then(function () {
          return _this2.bind(bindingList, widget);
        });
      }

      /**
       * @returns {Promise} to be resolved when all known bindings have been saved
       */
    }, {
      key: "saveAllBindings",
      value: function saveAllBindings() {
        return Promise.all(this.$bindingLists.map(function (l) {
          return l.saveAll();
        }));
      }

      /**
       * Returns true if any of the Bound Widgets are modified.
       * @return {boolean}
       */
    }, {
      key: "isAnyBoundWidgetModified",
      value: function isAnyBoundWidgetModified() {
        for (var i = 0; i < this.$bindingLists.length; i++) {
          var bindings = this.$bindingLists[i].getBindings();
          for (var j = 0; j < bindings.length; j++) {
            var widget = bindings[j].getWidget();
            if (widget && widget.isModified()) {
              return true;
            }
          }
        }
        return false;
      }

      /**
       * Re-resolve the binding's ORD (should incur no network call because it is
       * already subscribed), and update the bound widget accordingly.
       * @private
       * @param {module:nmodule/bajaui/rc/binding/impl/WidgetBinding} widgetBinding
       * @returns {Promise}
       */
    }, {
      key: "$updateBinding",
      value: function $updateBinding(widgetBinding) {
        var bindings = widgetBinding.getBindingList().getBindings();
        return this.$resolve(bindings).then(function () {
          return widgetBinding.propagateAll();
        }).then(function () {
          return runCallbacks(bindings);
        });
      }

      /**
       * @private
       * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
       * @param {object} [params]
       * @param {boolean} [params.subscribe] true if ords should subscribe
       * @returns {Promise.<{ subscriber: baja.Subscriber }>}
       */
    }, {
      key: "$resolve",
      value: function $resolve(bindings) {
        var _this3 = this;
        var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          subscribe = _ref2.subscribe;
        var subscriber = subscribe ? new baja.Subscriber() : undefined;
        return Promise.all(bindings.map(function (binding) {
          var ord = binding.get('ord');
          if (ord.isNull()) {
            return Promise.resolve({});
          }
          return Promise.resolve().then(function () {
            return _this3.$coalescer.resolve(ord, {
              subscriber: subscriber
            });
          }).then(function (ordTarget) {
            binding.set({
              slot: 'ord',
              value: ordTarget.getFacets().get('optimizedOrd')
            });
            binding.setOrdTarget(ordTarget);
          })["catch"](function () {
            var ordStr = ord.toString();
            var msg = 'unresolved: ' + ordStr;
            if (ordStr.startsWith('sys:|') || ordStr.indexOf('|sys:|') >= 0) {
              // Provide a better clue of why an ORD containing a query to the
              // SystemDb might not resolve
              msg = msg + " (ensure the SystemDb is available and/or the base is indexed into the SystemDb)";
            }
            logWarning(msg);
          });
        })).then(function () {
          return {
            subscriber: subscriber
          };
        });
      }

      /**
       * Install the necessary hooks to ensure that any Bindings present in the
       * build contents get correctly bound to the Widget right after it is initialized. This ensures
       * that parent widgets can listen for property updates on their descendants. 
       *
       * @private
       * @param {module:bajaux/lifecycle/WidgetManager} widgetManager
       */
    }, {
      key: "$installHooks",
      value: function $installHooks(widgetManager) {
        var _this4 = this;
        var postInitialize = function postInitialize(widget, buildContext) {
          var bindingList = buildContext.data.bindingList;
          if (widget instanceof NullWidget || !bindingList) {
            return;
          }
          return _this4.bind(bindingList, widget).then(function (token) {
            widget.on('destroyed', function () {
              _this4.unbind(token)["catch"](logWarning);
            });
          });
        };
        return widgetManager.installHooks({
          postInitialize: postInitialize
        });
      }
    }], [{
      key: "$isOrdSubstitutionEnabled",
      value: function $isOrdSubstitutionEnabled() {
        return niagaraSystemProperties['bajaux.binder.disableOrdSubstitution'] !== 'true';
      }
    }]);
  }();

  /**
   * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
   * @returns {Promise} to be resolved when all bindings have had their
   * `targetChanged` and `applyDegradeBehavior` callbacks hit
   */
  function runCallbacks(bindings) {
    return Promise.all(bindings.map(function (binding) {
      return Promise.resolve(binding.targetChanged())["finally"](function () {
        return binding.applyDegradeBehavior();
      });
    }));
  }
  function reject(msg) {
    return Promise.reject(new Error(msg));
  }
  function relativizeBindingOrd(binding, baseOrd) {
    var ord = binding.get('ord');
    var originalOrd = binding[ORIGINAL_ORD_SYMBOL] || (binding[ORIGINAL_ORD_SYMBOL] = ord);
    var relativizedOrd;
    if (!baseOrd.isNull()) {
      relativizedOrd = originalOrd.isNull() ? originalOrd : baja.Ord.make({
        base: baseOrd,
        child: originalOrd
      });
    } else {
      relativizedOrd = originalOrd;
    }
    try {
      relativizedOrd = relativizedOrd.normalize();
    } catch (ignore) {}
    binding.set({
      slot: 'ord',
      value: relativizedOrd
    });
  }
});
