function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/binding/impl/WidgetBinding
 */
define(['baja!', 'bajaux/events', 'Promise', 'underscore'], function (baja, events, Promise, _) {
  'use strict';

  var PROPERTY_CHANGED = events.PROPERTY_CHANGED;
  var union = _.union;

  /**
   * This class manages the interactions between an `IValueProvider` and the
   * `Widget` its values will be applied to.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/binding/impl/WidgetBinding
   */
  return /*#__PURE__*/function () {
    function WidgetBinding(bindingList, widget) {
      _classCallCheck(this, WidgetBinding);
      this.$bindingList = bindingList;
      this.$widget = widget;
    }

    /**
     * Initialize the binding by propagating all values to the Widget's known
     * Properties.
     *
     * If the given `Binding` is also an instance of
     * `IWidgetEventListener`, it will add its event listeners here.
     *
     * @param {module:nmodule/bajaui/rc/model/BindingList} bindingList
     * @param {module:bajaux/Widget} widget
     * @param {object} [cx]
     * @returns {Promise.<module:nmodule/bajaui/rc/binding/impl/WidgetBinding>}
     */
    return _createClass(WidgetBinding, [{
      key: "propagate",
      value:
      /**
       * Apply a single property to the Widget.
       *
       * @param {string} name
       * @param {object} [cx]
       * @returns {Promise}
       */
      function propagate(name, cx) {
        var props = this.$widget.properties();
        return getValueForWidget(this.$bindingList.getBindings(), name, cx).then(function (value) {
          return applyPropertyOverrides(props, [name], [value]);
        });
      }

      /**
       * Update every property on the Widget.
       *
       * @param {object} [cx]
       * @returns {Promise}
       */
    }, {
      key: "propagateAll",
      value: function propagateAll(cx) {
        return applyToAllWidgetProperties(this.$bindingList.getBindings(), this.$widget, cx);
      }
    }, {
      key: "destroy",
      value: function destroy() {
        //widget.off(widgetEvents...
      }

      /**
       * @returns {module:nmodule/bajaui/rc/model/BindingList}
       */
    }, {
      key: "getBindingList",
      value: function getBindingList() {
        return this.$bindingList;
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getWidget",
      value: function getWidget() {
        return this.$widget;
      }

      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/BindingList} bindingList
       * @param {string} name
       * @param {object} [cx]
       * @returns {Promise.<*|null>}
       */
    }], [{
      key: "initialize",
      value: function initialize(bindingList, widget, cx) {
        var bindings = bindingList.getBindings();
        bindings.forEach(function (binding) {
          if (typeof binding.addListeners === 'function') {
            binding.addListeners(widget);
          }
        });
        var props = widget.properties();
        var getValue = props.getValue;
        props.getValue = function (name, def) {
          if (!name) {
            return getValue.call(this);
          }
          var override = this.get(name, "override", def);
          return override === null ? this.get(name, "value", def) : override;
        };
        return applyToAllWidgetProperties(bindings, widget, cx).then(function () {
          return new WidgetBinding(bindingList, widget);
        });
      }
    }, {
      key: "$getValueForWidget",
      value: function $getValueForWidget(bindingList, name, cx) {
        return getValueForWidget(bindingList.getBindings(), name, cx);
      }
    }]);
  }();

  /**
   * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
   * @param {string} name
   * @param {object} [cx]
   * @returns {Promise.<*|null>} the first non-null value in
   */
  function getValueForWidget(bindings, name, cx) {
    return resolveFirstProvidedValue(bindings, name, cx).then(function (providedValue) {
      return providedValue === null ? getFirstFacetValue(bindings, name) : providedValue;
    });
  }

  /**
   * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
   * @param {string} name
   * @param {object} [cx]
   * @returns {Promise.<*|null>} the first non-null value provided by the
   * `provide()` method of a binding in the list
   */
  function resolveFirstProvidedValue(bindings, name, cx) {
    return bindings.reduce(function (prom, binding) {
      return prom.then(function (value) {
        return value === null ? binding.provide(name, cx) : value;
      });
    }, Promise.resolve(null));
  }

  /**
   * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
   * @param {string} name
   * @returns {*|null} the first non-null facet value provided by a binding in
   * the list
   */
  function getFirstFacetValue(bindings, name) {
    for (var i = 0, len = bindings.length; i < len; ++i) {
      var value = getFacetValue(bindings[i], name);
      if (value !== null) {
        return value;
      }
    }
    return null;
  }

  /**
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} binding
   * @param {string} name
   * @returns {*|null} facet value, if present on the binding
   */
  function getFacetValue(binding, name) {
    var facets = getFacets(binding);
    return facets ? facets.get(name) : null;
  }

  /**
   * @param {module:nmodule/bajaui/rc/baja/binding/Binding} binding
   * @returns {baja.Facets|null}
   */
  function getFacets(binding) {
    var ordTarget = binding.getOrdTarget();
    var facets = ordTarget && ordTarget.getFacets();
    return facets || null;
  }

  /**
   * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
   * @param {module:bajaux/Widget} widget
   * @param {object} [cx]
   * @returns {Promise} to be resolved when all values (either from `provide()`
   * or from OrdTarget facets) present in the BindingList have been applied to
   * the widget
   */
  function applyToAllWidgetProperties(bindings, widget, cx) {
    var props = widget.properties();
    var keys = Object.keys(props.toValueMap()); //TODO: Properties#keys
    keys = union(getAllFacetKeys(bindings), keys);
    return Promise.all(keys.map(function (k) {
      return getValueForWidget(bindings, k, cx);
    })).then(function (values) {
      return applyPropertyOverrides(props, keys, values, true);
    });
  }

  /**
   * @param {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>} bindings
   * @returns {string[]} all facet keys present in any of the bindings
   */
  function getAllFacetKeys(bindings) {
    return bindings.reduce(function (keys, binding) {
      var facets = getFacets(binding);
      if (facets) {
        keys = union(keys, facets.getKeys());
      }
      return keys;
    }, []);
  }
  function applyPropertyOverrides(props, keys, values, add) {
    var propsToAdd = [];
    var changedNames = [];
    var changedValues = [];
    values.forEach(function (value, i) {
      var name = keys[i];
      var prop = props.get(name);
      if (value === null && prop) {
        var _prop = prop,
          existingOverride = _prop.override,
          existingValue = _prop.value;
        if (existingOverride !== undefined && !equals(existingOverride, existingValue)) {
          changedNames.push(name);
          changedValues.push(prop.value);
        }
        delete prop.override;
      } else {
        if (!prop) {
          if (add) {
            prop = {
              name: name,
              "transient": true
            };
          } else {
            return;
          }
        }
        var _prop2 = prop,
          _existingOverride = _prop2.override,
          _existingValue = _prop2.value;
        if (_existingOverride !== undefined && !equals(value, _existingOverride) || _existingValue !== undefined && !equals(value, _existingValue)) {
          //!equals(value, existingValue)) { NCCB-46769
          changedNames.push(name);
          changedValues.push(value);
        }
        prop.override = value;
      }
      propsToAdd.push(prop);
    });
    props.addAll(propsToAdd);
    if (changedNames.length) {
      props.emit(PROPERTY_CHANGED, changedNames, changedValues);
    }
  }
  function equals(a, b) {
    return baja.hasType(a, 'baja:Simple') ? a.equals(b) : a === b;
  }
});
