function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/LayoutDimension
 */
define(['baja!'], function (baja) {
  'use strict';

  var ABS = 0;
  var PERCENT = 1;
  var PREF = 2;

  /**
   * BajaScript implementation of `bajaui:LayoutDimension`.
   * @class
   * @alias module:nmodule/bajaui/rc/baja/LayoutDimension
   * @extends baja.Simple
   */
  var LayoutDimension = /*#__PURE__*/function (_baja$Simple) {
    /**
     * @param {object} params
     * @param {number} params.value
     * @param {number} params.unit
     */
    function LayoutDimension() {
      var _this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$value = _ref.value,
        value = _ref$value === void 0 ? 0 : _ref$value,
        _ref$unit = _ref.unit,
        unit = _ref$unit === void 0 ? ABS : _ref$unit;
      _classCallCheck(this, LayoutDimension);
      _this = _callSuper(this, LayoutDimension);
      if (typeof value !== 'number') {
        throw new Error('value required');
      }
      if (typeof unit !== 'number') {
        throw new Error('unit required');
      }
      if (unit !== 0 && unit !== 1 && unit !== 2) {
        throw new Error('unknown unit ' + unit);
      }
      _this.$value = value;
      _this.$unit = unit;
      return _this;
    }

    /**
     * @param {object} params
     * @param {number} params.value
     * @param {number} params.unit
     */
    _inherits(LayoutDimension, _baja$Simple);
    return _createClass(LayoutDimension, [{
      key: "make",
      value:
      /**
       * @param {object} params
       * @param {number} params.value
       * @param {number} params.unit
       */
      function make(params) {
        return LayoutDimension.make(params);
      }

      /**
       * @returns {number}
       */
    }, {
      key: "getValue",
      value: function getValue() {
        return this.$value;
      }

      /**
       * @returns {number}
       */
    }, {
      key: "getUnit",
      value: function getUnit() {
        return this.$unit;
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var value = this.$value;
        var unit = this.$unit;
        if (unit === PREF) {
          return 'pref';
        }
        return value.encodeToString() + (unit === PERCENT ? '%' : '');
      }

      /**
       * @param {string} str
       * @returns {module:nmodule/bajaui/rc/baja/LayoutDimension}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        var value = 0,
          unit;
        if (str === 'pref') {
          unit = PREF;
        } else {
          var _exec = /([^%]*)(%?)$/.exec(str),
            _exec2 = _slicedToArray(_exec, 3),
            valueStr = _exec2[1],
            pct = _exec2[2];
          unit = pct === '%' ? PERCENT : ABS;
          value = baja.Double.DEFAULT.decodeFromString(valueStr);
        }
        return new LayoutDimension({
          value: value,
          unit: unit
        });
      }

      /**
       * @type {number} expresses layout in absolute pixels
       */
    }], [{
      key: "make",
      value: function make(params) {
        return new LayoutDimension(params);
      }
    }, {
      key: "ABS",
      get: function get() {
        return ABS;
      }

      /**
       * @type {number} expresses layout in percentage of container
       */
    }, {
      key: "PERCENT",
      get: function get() {
        return PERCENT;
      }

      /**
       * @type {number} expresses layout as widget's own preferred size
       */
    }, {
      key: "PREF",
      get: function get() {
        return PREF;
      }
    }]);
  }(baja.Simple);
  LayoutDimension.DEFAULT = new LayoutDimension({
    value: 0,
    unit: ABS
  });
  return LayoutDimension;
});
