function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/Border
 */
define(['baja!', 'underscore', 'nmodule/gx/rc/baja/Brush'], function (baja, _, Brush) {
  'use strict';

  var isNumber = _.isNumber,
    isString = _.isString;
  var SINGLE_SIDE = /^\s*([\d.,]+)\s+(\w+)\s+(.*)$/;

  /**
   * BajaScript representation of a `bajaui:Border`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/baja/Border
   * @extends baja.Simple
   */
  var Border = /*#__PURE__*/function (_baja$Simple) {
    /**
     * @param {object|module:nmodule/bajaui/rc/baja/Border~Side} params side
     * definitions for any or all four sides; or a single side definition if all
     * four sides should be equal
     * @param {module:nmodule/bajaui/rc/baja/Border~Side} [params.top]
     * @param {module:nmodule/bajaui/rc/baja/Border~Side} [params.right]
     * @param {module:nmodule/bajaui/rc/baja/Border~Side} [params.bottom]
     * @param {module:nmodule/bajaui/rc/baja/Border~Side} [params.left]
     */
    function Border(params) {
      var _this;
      _classCallCheck(this, Border);
      _this = _callSuper(this, Border);
      var top, right, bottom, left;
      if (!params.top && !params.right && !params.bottom && !params.left) {
        top = right = bottom = left = verifySide(params);
      } else {
        top = verifySide(params.top);
        right = verifySide(params.right);
        bottom = verifySide(params.bottom);
        left = verifySide(params.left);
      }
      _this.$top = top;
      _this.$right = right;
      _this.$bottom = bottom;
      _this.$left = left;
      return _this;
    }

    /**
     * @param {object|string|module:nmodule/bajaui/rc/baja/Border~Side} params
     * @returns {module:nmodule/bajaui/rc/baja/Border}
     */
    _inherits(Border, _baja$Simple);
    return _createClass(Border, [{
      key: "make",
      value:
      /**
       * @param {object|module:nmodule/bajaui/rc/baja/Border~Side} params
       * @returns {module:nmodule/bajaui/rc/baja/Border}
       */
      function make(params) {
        return Border.make(params);
      }

      /**
       * return true if all border sides have a zero width or the `NONE` style.
       * @return {boolean}
       */
    }, {
      key: "isBorderless",
      value: function isBorderless() {
        var top = this.$top;
        var right = this.$right;
        var bottom = this.$bottom;
        var left = this.$left;
        return (!top.width || top.style === Border.NONE) && (!right.width || right.style === Border.NONE) && (!bottom.width || bottom.style === Border.NONE) && (!left.width || left.style === Border.NONE);
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var top = this.$top;
        var right = this.$right;
        var bottom = this.$bottom;
        var left = this.$left;
        if (allSidesEqual(top, right, bottom, left)) {
          if (this.equals(Border.NULL)) {
            return 'null';
          }
          return encodeSide(top);
        } else {
          var NONE = Border.NONE;
          return [top.style !== NONE && "top(".concat(encodeSide(top), ")"), right.style !== NONE && "right(".concat(encodeSide(right), ")"), bottom.style !== NONE && "bottom(".concat(encodeSide(bottom), ")"), left.style !== NONE && "left(".concat(encodeSide(left), ")")].filter(isTruthy).join(' ');
        }
      }

      /**
       * @param str
       * @returns {module:nmodule/bajaui/rc/baja/Border}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        str = str.trim();
        var side = parseSide(str);
        if (side) {
          return Border.make(side);
        }
        var arg = {};
        var regex = /(top|right|bottom|left)\(/g;
        var match = regex.exec(str);
        if (!match) {
          throw new Error("invalid string \"".concat(str, "\""));
        }
        while (match) {
          var nextMatch = regex.exec(str);
          var index = match.index;
          var sideName = match[1];
          var endIndex = nextMatch ? nextMatch.index : str.length - 1;
          var sideString = str.substring(index + sideName.length + 1, endIndex).replace(/\)\s*$/, '');
          arg[sideName] = parseSide(sideString);
          match = nextMatch;
        }
        return Border.make(arg);
      }

      /**
       * @param {module:nmodule/bajaui/rc/baja/Border} border
       * @returns {boolean}
       */
    }, {
      key: "equals",
      value: function equals(border) {
        if (!baja.hasType(border, 'bajaui:Border')) {
          return false;
        }
        return sidesEqual(this.$top, border.$top) && sidesEqual(this.$right, border.$right) && sidesEqual(this.$bottom, border.$bottom) && sidesEqual(this.$left, border.$left);
      }

      /**
       * @param {HTMLElement} el
       */
    }, {
      key: "applyToElement",
      value: function applyToElement(_ref) {
        var style = _ref.style;
        var top = this.$top;
        var right = this.$right;
        var bottom = this.$bottom;
        var left = this.$left;
        style.boxSizing = 'border-box';
        if (allSidesEqual(top, right, bottom, left)) {
          style.border = toCss(top);
        } else {
          style.borderTop = toCss(top);
          style.borderRight = toCss(right);
          style.borderBottom = toCss(bottom);
          style.borderLeft = toCss(left);
        }
      }
    }], [{
      key: "make",
      value: function make(params) {
        if (typeof params === 'string') {
          return Border.DEFAULT.decodeFromString(params);
        }
        return new Border(params);
      }
    }]);
  }(baja.Simple);
  Border.NONE = 0;
  Border.SOLID = 1;
  Border.DOTTED = 2;
  Border.DASHED = 3;
  Border.GROOVE = 4;
  Border.RIDGE = 5;
  Border.INSET = 6;
  Border.OUTSET = 7;
  Border.DEFAULT = Border.make({
    width: 1,
    style: Border.SOLID,
    brush: 'black'
  });
  Border.NULL = Border.make({
    width: 0,
    style: Border.NONE,
    brush: 'null'
  });

  /**
   * @typedef {object} module:nmodule/bajaui/rc/baja/Border~Side
   * @property {number} width border width, in pixels
   * @property {number|string} style border style (a string will be parsed to
   * a number)
   * @property {module:nmodule/gx/rc/baja/Brush|string} brush border color (a
   * string will be parsed to a Brush)
   */

  /**
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side1
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side2
   * @returns {boolean}
   */
  function sidesEqual(side1, side2) {
    return side1.width === side2.width && side1.style === side2.style && side1.brush.equivalent(side2.brush);
  }

  /**
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side1
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side2
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side3
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side4
   * @returns {boolean}
   */
  function allSidesEqual(side1, side2, side3, side4) {
    return sidesEqual(side1, side2) && sidesEqual(side2, side3) && sidesEqual(side3, side4);
  }

  /**
   * @param {number} style
   * @returns {string}
   */
  function toStyleDisplay(style) {
    switch (style) {
      case Border.NONE:
        return 'none';
      case Border.SOLID:
        return 'solid';
      case Border.DOTTED:
        return 'dotted';
      case Border.DASHED:
        return 'dashed';
      case Border.GROOVE:
        return 'groove';
      case Border.RIDGE:
        return 'ridge';
      case Border.INSET:
        return 'inset';
      case Border.OUTSET:
        return 'outset';
    }
  }
  var STYLES_WITH_NO_BRUSH = [Border.GROOVE, Border.RIDGE, Border.INSET, Border.OUTSET];

  /**
   * @param {number} style
   * @param {number} width
   * @returns {number}
   */
  function determineWidth(style, width) {
    if (style === Border.NONE) {
      return 0;
    } else if (style === Border.INSET || style === Border.OUTSET) {
      return 1;
    } else if (style === Border.GROOVE || style === Border.RIDGE) {
      return 2;
    } else {
      return width;
    }
  }

  /**
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side
   * @returns {string}
   */
  function toCss(side) {
    var width = side.width,
      style = side.style,
      brush = side.brush,
      styleDisplay = toStyleDisplay(style),
      determinedWidth = determineWidth(style, width);
    if (STYLES_WITH_NO_BRUSH.includes(style)) {
      return "".concat(determinedWidth, "px ").concat(styleDisplay);
    }
    return "".concat(determinedWidth, "px ").concat(styleDisplay, " ").concat(brush.toString());
  }

  /**
   * If no side parameter is provided, then a `none` Side will be returned.
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} [side]
   * @returns {module:nmodule/bajaui/rc/baja/Border~Side}
   */
  function verifySide(side) {
    if (!side) {
      return {
        width: 0,
        style: Border.NONE,
        brush: 'null'
      };
    }
    var width = side.width,
      style = side.style,
      brush = side.brush;
    style = side.style = parseStyle(style);
    if (isString(brush)) {
      brush = side.brush = Brush.make(brush);
    }
    if (!isNumber(width)) {
      throw new Error('width required');
    }
    if (!isNumber(style)) {
      throw new Error('style required');
    }
    if (!brush) {
      throw new Error('brush required');
    }
    return side;
  }

  /**
   * @param {number|string} style
   * @returns {number}
   */
  function parseStyle(style) {
    if (isString(style)) {
      var num = Border[style.toUpperCase()];
      if (!isNumber(num)) {
        throw new Error("invalid style \"".concat(style, "\""));
      }
      style = num;
    }
    return style;
  }

  /**
   * @param {module:nmodule/bajaui/rc/baja/Border~Side} side
   * @returns {string}
   */
  function encodeSide(_ref2) {
    var width = _ref2.width,
      style = _ref2.style,
      brush = _ref2.brush;
    return "".concat(width, " ").concat(toStyleDisplay(style), " ").concat(brush);
  }

  /**
   * @param str
   * @returns {module:nmodule/bajaui/rc/baja/Border~Side}
   */
  function parseSide(str) {
    var match = SINGLE_SIDE.exec(str);
    if (match) {
      return {
        width: +match[1],
        style: parseStyle(match[2]),
        brush: match[3]
      };
    }
  }
  function isTruthy(x) {
    return x;
  }
  return Border;
});
