/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/kitIo/rc/TabularConversionEditor
 */
define([
  'nmodule/driver/rc/fe/BaseTabularConversionEditor',
  'jquery',
  'Promise',
  'baja!',
  'lex!kitIo',
  'nmodule/driver/rc/fe/XYPointEditor',
  'nmodule/driver/rc/baja/XYPoint',
  'nmodule/kitIo/rc/baja/TabularConversion',
  'underscore'
], function
  (BaseTabularConversionEditor,
   $,
   Promise,
   baja,
   lexs,
   XYPointEditor,
   XYPoint,
   TabularConversion,
   _) {

  'use strict';

  var kitLex = lexs[0];

  /**
   * Bajaux editor for Tabular conversion
   *
   * @class
   * @extends module:nmodule/driver/rc/fe/BaseTabularConversionEditor
   * @alias module:nmodule/kitIo/rc/TabularConversionEditor
   */
  var TabularConversionEditor = function TabularConversionEditor() {
    var that = this;
    BaseTabularConversionEditor.apply(that, arguments);
  };

  //extend and set up prototype chain
  TabularConversionEditor.prototype = Object.create(BaseTabularConversionEditor.prototype);
  TabularConversionEditor.prototype.constructor = TabularConversionEditor;

  /**
   * @see BaseTabularConversionEditor.getInitDomProps
   */
  TabularConversionEditor.prototype.getInitDomProps = function(){
    return {
      labels: {
        desc: kitLex.get("TabularConversion.description"),
        source: kitLex.get("TabularConversion.point.source"),
        result: kitLex.get("TabularConversion.point.result")
      }
    };
  };

  /**
   * Reads the editor data into a TabularConversion object
   * @returns {Promise} promise to be resolved with the current value
   */
  TabularConversionEditor.prototype.doRead = function () {
    return Promise.join(
      this.$getDescEditor().read(),
      this.getBuilder().readAll()
    ).spread(function (desc, points) {
        return TabularConversion.make(desc, points);
      });
  };

  return TabularConversionEditor;
});
