
/**
 * @copyright 2022 TridiumEMEA. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPxBuilding/rc/KitPxBuildingIEnum
 *
 * @author Andy Sutton
 * @creation Feb 2022
 * @since Niagara 4.10 (from 4.10.0.6 / 4.11.0.6 EMEA jars)
 */
define('nmodule/kitPxBuilding/rc/KitPxBuildingIEnum',[
    'baja!'
  ], function (
    baja
  ) {

  'use strict';

  const Component = baja.Component;

  /**
   * extends the BajaScript representation of KitPxBuilding classes that implement BIEnum.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitPxBuilding/rc/KitPxBuildingIEnum}
   */
  return class KitPxBuildingIEnum extends Component {
    /**
     * implement #getEnum
     * (in java world this would come from BIEnum#getEnum, but it's not a Niagara Property
     *  so we don't get it automatically in bajascript)
     */
    getEnum() {
      return this.getOut().getEnum();
    }

    // #getEnumFacets is the other method on BIEnum, so may want to implement something along these lines in the future.
    // getEnumFacets() {
    //   if (typeof this.getEnum().getEnumFacets === 'function') {
    //     return this.getEnum();
    //   }
    //   return undefined;
    // }
  };
});

