function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define([], function () {
  'use strict';

  var ctx, gradient;
  var BRIGHTNESS_THRESHOLD = 140;

  /**
   * API Status: **Private**
   * @exports nmodule/gx/rc/util/colorUtils
   */
  var exports = {};

  /**
   * Blend a foreground color with alpha onto a background color and return the
   * blended color.
   * @param {Array.<number>} fore foreground RGBA [0 - 255]
   * @param {Array.<number>} back background RGB (alpha ignored) [0 - 255]
   * @returns {Array.<number>} blended color [0 - 255] (alpha always 255)
   */
  exports.alphaBlend = function (fore, back) {
    var _fore$map = fore.map(normalizeByte),
      _fore$map2 = _slicedToArray(_fore$map, 4),
      fR = _fore$map2[0],
      fG = _fore$map2[1],
      fB = _fore$map2[2],
      _fore$map2$ = _fore$map2[3],
      fA = _fore$map2$ === void 0 ? 255 : _fore$map2$,
      _back$map = back.map(normalizeByte),
      _back$map2 = _slicedToArray(_back$map, 3),
      bR = _back$map2[0],
      bG = _back$map2[1],
      bB = _back$map2[2],
      a = fA / 255;

    // blended === a * f + (1 - a) * b === a * (f - b) + b

    return [a * (fR - bR) + bR, a * (fG - bG) + bG, a * (fB - bB) + bB, 255].map(Math.round);
  };

  /**
   * @param {Array.<number>} rgb array of RGB values, [0 - 255] (alpha ignored)
   * @returns {Array.<number>} an RGB array of a color computed to contrast
   * legibly with the given color
   */
  exports.getContrastingColor = function (rgb) {
    var brightness = exports.perceivedBrightness(rgb);
    return brightness > BRIGHTNESS_THRESHOLD ? [0, 0, 0] : [255, 255, 255];
  };

  /**
   * Converts an HSV color value to RGB. 
   * @param {Array.<number>} hsv the HSV values. Numbers will be constrained to
   * the ranges [0 - 360], [0 - 100], [0 - 100].
   * @returns {Array.<number>} the RGB values, [0 - 255]
   */
  exports.hsvToRgb = function (hsv) {
    var _hsv = _slicedToArray(hsv, 4),
      h = _hsv[0],
      s = _hsv[1],
      v = _hsv[2],
      a = _hsv[3];
    while (h < 360) {
      h += 360;
    }
    h = h / 360;
    s = normalize(100, s) / 100;
    v = normalize(100, v) / 100;
    if (!isNumber(a)) {
      a = 255;
    }
    var r,
      g,
      b,
      i = Math.floor(h * 6),
      f = h * 6 - i,
      p = v * (1 - s),
      q = v * (1 - f * s),
      t = v * (1 - (1 - f) * s);
    switch (i % 6) {
      case 0:
        r = v;
        g = t;
        b = p;
        break;
      case 1:
        r = q;
        g = v;
        b = p;
        break;
      case 2:
        r = p;
        g = v;
        b = t;
        break;
      case 3:
        r = p;
        g = q;
        b = v;
        break;
      case 4:
        r = t;
        g = p;
        b = v;
        break;
      case 5:
        r = v;
        g = p;
        b = q;
        break;
    }
    return [r, g, b].map(function (v) {
      return Math.round(v * 255);
    }).concat(a);
  };
  var HEX = "[0-9a-fA-F]",
    BYTE = "".concat(HEX, "{2}"),
    NUM = '[\\d\\.]+%?';
  var COLOR_PARSERS = {
    '#aarrggbb': {
      regex: new RegExp("^#(".concat(BYTE, ")(").concat(BYTE, ")(").concat(BYTE, ")(").concat(BYTE, ")$")),
      parse: function parse(_ref) {
        var _ref2 = _slicedToArray(_ref, 4),
          a = _ref2[0],
          r = _ref2[1],
          g = _ref2[2],
          b = _ref2[3];
        return [r, g, b, a].map(fromHex);
      }
    },
    '#rgb': {
      regex: new RegExp("^#(".concat(HEX, ")(").concat(HEX, ")(").concat(HEX, ")$")),
      parse: function parse(res) {
        return res.map(function (s) {
          return fromHex(s + s);
        }).concat(255);
      }
    },
    '#rrggbb': {
      regex: new RegExp("^#(".concat(BYTE, ")(").concat(BYTE, ")(").concat(BYTE, ")$")),
      parse: function parse(res) {
        return res.map(fromHex).concat(255);
      }
    },
    'rgb(#,#,#)': {
      regex: new RegExp("^rgb\\((".concat(NUM, "),(").concat(NUM, "),(").concat(NUM, ")\\)$"), 'i'),
      parse: function parse(res) {
        return res.map(parseCssNumber).concat(255);
      }
    },
    'rgba(#,#,#,#)': {
      regex: new RegExp("^rgba\\((".concat(NUM, "),(").concat(NUM, "),(").concat(NUM, "),(").concat(NUM, ")\\)$"), 'i'),
      parse: function parse(_ref3) {
        var _ref4 = _slicedToArray(_ref3, 4),
          r = _ref4[0],
          g = _ref4[1],
          b = _ref4[2],
          a = _ref4[3];
        return [parseCssNumber(r), parseCssNumber(g), parseCssNumber(b), Math.round(parseCssNumber(a) * 255)];
      }
    }
  };

  /**
   * @param {number[]} rgba1
   * @param {number[]} rgba2
   * @param {number} [ratio=0.5] ratio of first to second color - 0 gives you
   * `rgba1` unchanged, 1 gives you `rgba2` unchanged, 0.5 gives you a color
   * exactly in between the two
   * @returns {number[]} an interpolated color
   */
  exports.interpolateColors = function (rgba1, rgba2) {
    var ratio = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0.5;
    ratio = Math.min(Math.max(ratio, 0), 1);
    var _rgba = _slicedToArray(rgba1, 4),
      r1 = _rgba[0],
      g1 = _rgba[1],
      b1 = _rgba[2],
      _rgba$ = _rgba[3],
      a1 = _rgba$ === void 0 ? 255 : _rgba$;
    var _rgba2 = _slicedToArray(rgba2, 4),
      r2 = _rgba2[0],
      g2 = _rgba2[1],
      b2 = _rgba2[2],
      _rgba2$ = _rgba2[3],
      a2 = _rgba2$ === void 0 ? 255 : _rgba2$;
    return [r1 + (r2 - r1) * ratio, g1 + (g2 - g1) * ratio, b1 + (b2 - b1) * ratio, a1 + (a2 - a1) * ratio].map(Math.floor);
  };

  /**
   * Given a string, parse out RGBA values from it. Matches on:
   * - a known CSS color name, like `red`
   * - `#RGB`
   * - `#RRGGBB`
   * - `#AARRGGBB`
   * - `rgb(r, g, b)`
   * - `rgba(r, g, b, a)`
   * 
   * @param {string} str
   * @returns {Array.<number>} RGBA values [0 - 255]
   * @throws {Error} if string cannot be parsed
   */
  exports.parseRgba = function (str) {
    var keys = Object.keys(COLOR_PARSERS);
    for (var i = 0; i < keys.length; ++i) {
      var _COLOR_PARSERS$keys$i = COLOR_PARSERS[keys[i]],
        regex = _COLOR_PARSERS$keys$i.regex,
        parse = _COLOR_PARSERS$keys$i.parse;
      var res = regex.exec(stripWhitespace(str));
      if (res) {
        return parse(res.slice(1));
      }
    }
    var rgbString = colorNameToRgbString(str);
    if (rgbString) {
      return exports.parseRgba(rgbString);
    }
    throw new Error("Could not parse CSS color string: \"".concat(str, "\""));
  };

  /**
   * @param {Array.<number>} rgb array of RGB values, [0 - 255] (alpha ignored)
   * @returns {number} a perceived brightness / "gray value" for this color
   * [0 - 255]
   * @see {@link http://alienryderflex.com/hsp.html}
   */
  exports.perceivedBrightness = function (rgb) {
    var _rgb$map = rgb.map(normalizeByte),
      _rgb$map2 = _slicedToArray(_rgb$map, 3),
      r = _rgb$map2[0],
      g = _rgb$map2[1],
      b = _rgb$map2[2];
    return Math.sqrt(0.299 * r * r + 0.587 * g * g + 0.114 * b * b);
  };

  /**
   * Converts an RGB color value to HSV. 
   *
   * @param {Array.<number>} rgb the RGB values. Numbers will be constrained
   * to the range [0 - 255].
   * @returns {Array.<number>} The HSV representation in the form of rounded
   * numbers in the ranges [0 - 360], [0 - 100], [0 - 100].
   */
  exports.rgbToHsv = function (rgb) {
    var _rgb$map3 = rgb.map(normalizeByte),
      _rgb$map4 = _slicedToArray(_rgb$map3, 4),
      r = _rgb$map4[0],
      g = _rgb$map4[1],
      b = _rgb$map4[2],
      _rgb$map4$ = _rgb$map4[3],
      a = _rgb$map4$ === void 0 ? 255 : _rgb$map4$,
      max = Math.max(r, g, b),
      min = Math.min(r, g, b),
      h,
      v = max,
      d = max - min,
      s = max === 0 ? 0 : d / max;
    if (max === min) {
      h = 0; // achromatic
    } else {
      switch (max) {
        case r:
          h = (g - b) / d + (g < b ? 6 : 0);
          break;
        case g:
          h = (b - r) / d + 2;
          break;
        case b:
          h = (r - g) / d + 4;
          break;
      }
      h /= 6;
    }
    return [h * 360, s * 100, v / 2.55, a].map(Math.round);
  };

  /**
   * Get a rgb/rgba CSS string that can be applied to an element style.
   * @param {Array.<number>} rgba an array of RGBA numbers, [ 0 - 255 ] (the
   * alpha is optional)
   * @returns {string}
   */
  exports.toRgbCssString = function (rgba) {
    var _rgba$map = rgba.map(Math.round),
      _rgba$map2 = _slicedToArray(_rgba$map, 4),
      r = _rgba$map2[0],
      g = _rgba$map2[1],
      b = _rgba$map2[2],
      a = _rgba$map2[3];
    if (!isNumber(a) || a === 255) {
      return "rgb(".concat(r, ", ").concat(g, ", ").concat(b, ")");
    } else {
      return "rgba(".concat(r, ", ").concat(g, ", ").concat(b, ", ").concat(a / 255, ")");
    }
  };
  function fromHex(hex) {
    return parseInt(hex, 16);
  }
  function isNumber(n) {
    return typeof n === 'number' && !isNaN(n);
  }
  function normalize(max, val) {
    return Math.max(0, Math.min(val, max));
  }
  function normalizeByte(val) {
    return normalize(255, val);
  }
  function parseCssNumber(str) {
    if (str.charAt(str.length - 1) === "%") {
      // Convert percentage to 255 value
      var val = parseInt(str.substring(0, str.length - 1), 10);
      return Math.round(val * 2.55);
    }
    return parseFloat(str);
  }
  function stripWhitespace(str) {
    return str.replace(/\s/g, '');
  }
  function colorNameToRgbString(str) {
    if (!ctx) {
      ctx = document.createElement('canvas').getContext('2d');
      gradient = ctx.createLinearGradient(0, 0, 1, 0);
    }
    ctx.fillStyle = gradient;
    ctx.fillStyle = str;
    var fillStyle = ctx.fillStyle;
    if (fillStyle !== gradient) {
      return fillStyle;
    }
  }
  return exports;
});
