function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/PolygonGeom
*/

define(['baja!', 'underscore', 'nmodule/gx/rc/baja/Point'], function (baja, _, Point) {
  'use strict';

  /**
  * BajaScript representation of a `gx:PolygonGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/PolygonGeom
  * @extends baja.Simple
  */
  var PolygonGeom = /*#__PURE__*/function (_baja$Simple) {
    /**
     * 
     * @constructor
     * @param {Array} xValues Number array of x coordinate values
     * @param {*} yValues Number array of y coordinate values
     * @param {*} size Number of points making the Polygon 
     */
    function PolygonGeom(xValues, yValues, size) {
      var _this;
      _classCallCheck(this, PolygonGeom);
      _this = _callSuper(this, PolygonGeom);
      _this.$size = size;
      _this.$points = _.zip(xValues, yValues).map(function (val) {
        try {
          return new Point(val[0], val[1]);
        } catch (err) {
          throw new Error("Point: " + err.message);
        }
      });
      return _this;
    }

    /**
     * Makes a PolygonGeom from a string input of the form 
     * "x1,y1 x2,y2 x3,y3"
     * 
     * @param {*} geomString 
     * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
     */
    _inherits(PolygonGeom, _baja$Simple);
    return _createClass(PolygonGeom, [{
      key: "make",
      value: function make(geomString) {
        return PolygonGeom.make(geomString);
      }

      /**
       * 
       * @returns {Number} Number of points making the Polygon
       */
    }, {
      key: "size",
      value: function size() {
        return this.$size;
      }

      /**
       * Gets the array of x coordinate values
       * 
       * @returns {Array.<Number>}
       */
    }, {
      key: "x",
      value: function x() {
        return this.$points.map(function (p) {
          return p.x();
        });
      }

      /**
       * Gets the array of y coordinate values
       * 
       * @returns {Number}
       */
    }, {
      key: "y",
      value: function y() {
        return this.$points.map(function (p) {
          return p.y();
        });
      }

      /**
       * Gets the x coordinate value at a particular index
       * 
       * @param {Number} index 
       * @returns {Number} the value at the given index
       */
    }, {
      key: "xAt",
      value: function xAt(index) {
        return this.x()[index];
      }

      /**
       * Gets the y coordinate value at a particular index
       * 
       * @param {Number} index 
       * @returns {Number} the value at the given index
       */
    }, {
      key: "yAt",
      value: function yAt(index) {
        return this.y()[index];
      }

      /**
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(geomString) {
        return PolygonGeom.make(geomString);
      }

      /**
       * Returns the string encoding of the Polygon
       * in the form 'x1,y1 x2,y2 x3,y3 x4,y4' and so on
       * 
       * @returns {String} 
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }
        return this.$points.map(function (p) {
          return p.encodeToString();
        }).join(' ');
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this === PolygonGeom.NULL;
      }
    }], [{
      key: "make",
      value: function make(geomString) {
        if (!geomString) {
          return PolygonGeom.DEFAULT;
        } else {
          geomString = geomString.trim();
        }
        if (geomString === "null") {
          return PolygonGeom.NULL;
        }
        try {
          var points = geomString.split(' ').map(Point.DEFAULT.decodeFromString),
            noOfPoints = points.length,
            arrayOfPoints = _.unzip(points.map(function (p) {
              return [p.x(), p.y()];
            }));
          return _construct(PolygonGeom, _toConsumableArray(arrayOfPoints).concat([noOfPoints]));
        } catch (error) {
          throw new Error("Incorrect format for PolygonGeom: ".concat(error.message));
        }
      }
    }]);
  }(baja.Simple);
  PolygonGeom.DEFAULT = new PolygonGeom([0], [0], 0);
  PolygonGeom.NULL = new PolygonGeom([0], [0], 0);
  return PolygonGeom;
});
